/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.joml.Vector3f;

public class StandingSignSpecialRenderer
implements NoDataSpecialModelRenderer {
    private final Model model;
    private final Material material;

    public StandingSignSpecialRenderer(Model p_389670_, Material p_389667_) {
        this.model = p_389670_;
        this.material = p_389667_;
    }

    @Override
    public void render(ItemDisplayContext p_389518_, PoseStack p_389707_, MultiBufferSource p_389673_, int p_389471_, int p_389604_, boolean p_389437_) {
        SignRenderer.renderInHand(p_389707_, p_389673_, p_389471_, p_389604_, this.model, this.material);
    }

    @Override
    public void getExtents(Set<Vector3f> p_428256_) {
        PoseStack $$1 = new PoseStack();
        SignRenderer.applyInHandTransforms($$1);
        this.model.root().getExtentsForGui($$1, p_428256_);
    }

    public record Unbaked(WoodType woodType, Optional<ResourceLocation> texture) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_389433_ -> p_389433_.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(Unbaked::woodType), (App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(Unbaked::texture)).apply((Applicative)p_389433_, Unbaked::new));

        public Unbaked(WoodType p_389712_) {
            this(p_389712_, Optional.empty());
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public SpecialModelRenderer<?> bake(EntityModelSet p_389399_) {
            Model $$1 = SignRenderer.createSignModel(p_389399_, this.woodType, true);
            Material $$2 = this.texture.map(Sheets.SIGN_MAPPER::apply).orElseGet(() -> Sheets.getSignMaterial(this.woodType));
            return new StandingSignSpecialRenderer($$1, $$2);
        }
    }
}

