/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;

public class ChestSpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final ResourceLocation GIFT_CHEST_TEXTURE = ResourceLocation.withDefaultNamespace("christmas");
    public static final ResourceLocation NORMAL_CHEST_TEXTURE = ResourceLocation.withDefaultNamespace("normal");
    public static final ResourceLocation TRAPPED_CHEST_TEXTURE = ResourceLocation.withDefaultNamespace("trapped");
    public static final ResourceLocation ENDER_CHEST_TEXTURE = ResourceLocation.withDefaultNamespace("ender");
    private final ChestModel model;
    private final Material material;
    private final float openness;

    public ChestSpecialRenderer(ChestModel p_386863_, Material p_388350_, float p_386750_) {
        this.model = p_386863_;
        this.material = p_388350_;
        this.openness = p_386750_;
    }

    @Override
    public void render(ItemDisplayContext p_388647_, PoseStack p_387780_, MultiBufferSource p_386788_, int p_387736_, int p_387546_, boolean p_387869_) {
        VertexConsumer $$6 = this.material.buffer(p_386788_, RenderType::entitySolid);
        this.model.setupAnim(this.openness);
        this.model.renderToBuffer(p_387780_, $$6, p_387736_, p_387546_);
    }

    @Override
    public void getExtents(Set<Vector3f> p_428204_) {
        PoseStack $$1 = new PoseStack();
        this.model.setupAnim(this.openness);
        this.model.root().getExtentsForGui($$1, p_428204_);
    }

    public record Unbaked(ResourceLocation texture, float openness) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_388545_ -> p_388545_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture), (App)Codec.FLOAT.optionalFieldOf("openness", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::openness)).apply((Applicative)p_388545_, Unbaked::new));

        public Unbaked(ResourceLocation p_387139_) {
            this(p_387139_, 0.0f);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public SpecialModelRenderer<?> bake(EntityModelSet p_387681_) {
            ChestModel $$1 = new ChestModel(p_387681_.bakeLayer(ModelLayers.CHEST));
            Material $$2 = Sheets.CHEST_MAPPER.apply(this.texture);
            return new ChestSpecialRenderer($$1, $$2, this.openness);
        }
    }
}

