/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.joml.Vector3f;

public class BannerSpecialRenderer
implements SpecialModelRenderer<BannerPatternLayers> {
    private final BannerRenderer bannerRenderer;
    private final DyeColor baseColor;

    public BannerSpecialRenderer(DyeColor p_388643_, BannerRenderer p_386611_) {
        this.bannerRenderer = p_386611_;
        this.baseColor = p_388643_;
    }

    @Override
    @Nullable
    public BannerPatternLayers extractArgument(ItemStack p_387879_) {
        return p_387879_.get(DataComponents.BANNER_PATTERNS);
    }

    @Override
    public void render(@Nullable BannerPatternLayers p_388526_, ItemDisplayContext p_387517_, PoseStack p_388611_, MultiBufferSource p_388866_, int p_387337_, int p_386801_, boolean p_387745_) {
        this.bannerRenderer.renderInHand(p_388611_, p_388866_, p_387337_, p_386801_, this.baseColor, Objects.requireNonNullElse(p_388526_, BannerPatternLayers.EMPTY));
    }

    @Override
    public void getExtents(Set<Vector3f> p_428463_) {
        this.bannerRenderer.getExtents(p_428463_);
    }

    @Override
    @Nullable
    public /* synthetic */ Object extractArgument(ItemStack itemStack) {
        return this.extractArgument(itemStack);
    }

    public record Unbaked(DyeColor baseColor) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_386477_ -> p_386477_.group((App)DyeColor.CODEC.fieldOf("color").forGetter(Unbaked::baseColor)).apply((Applicative)p_386477_, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public SpecialModelRenderer<?> bake(EntityModelSet p_388010_) {
            return new BannerSpecialRenderer(this.baseColor, new BannerRenderer(p_388010_));
        }
    }
}

