/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item.properties.numeric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class Time
extends NeedleDirectionHelper
implements RangeSelectItemModelProperty {
    public static final MapCodec<Time> MAP_CODEC = RecordCodecBuilder.mapCodec(p_390087_ -> p_390087_.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(NeedleDirectionHelper::wobble), (App)TimeSource.CODEC.fieldOf("source").forGetter(p_390088_ -> p_390088_.source)).apply((Applicative)p_390087_, Time::new));
    private final TimeSource source;
    private final RandomSource randomSource = RandomSource.create();
    private final NeedleDirectionHelper.Wobbler wobbler;

    public Time(boolean p_387033_, TimeSource p_390432_) {
        super(p_387033_);
        this.source = p_390432_;
        this.wobbler = this.newWobbler(0.9f);
    }

    @Override
    protected float calculate(ItemStack p_387493_, ClientLevel p_387362_, int p_388783_, Entity p_388056_) {
        float $$4 = this.source.get(p_387362_, p_387493_, p_388056_, this.randomSource);
        long $$5 = p_387362_.getGameTime();
        if (this.wobbler.shouldUpdate($$5)) {
            this.wobbler.update($$5, $$4);
        }
        return this.wobbler.rotation();
    }

    public MapCodec<Time> type() {
        return MAP_CODEC;
    }

    public static enum TimeSource implements StringRepresentable
    {
        RANDOM("random"){

            @Override
            public float get(ClientLevel p_390411_, ItemStack p_390382_, Entity p_390443_, RandomSource p_390409_) {
                return p_390409_.nextFloat();
            }
        }
        ,
        DAYTIME("daytime"){

            @Override
            public float get(ClientLevel p_390440_, ItemStack p_390494_, Entity p_390360_, RandomSource p_390488_) {
                return p_390440_.getTimeOfDay(1.0f);
            }
        }
        ,
        MOON_PHASE("moon_phase"){

            @Override
            public float get(ClientLevel p_390465_, ItemStack p_390476_, Entity p_390363_, RandomSource p_390375_) {
                return (float)p_390465_.getMoonPhase() / 8.0f;
            }
        };

        public static final Codec<TimeSource> CODEC;
        private final String name;

        TimeSource(String p_390521_) {
            this.name = p_390521_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        abstract float get(ClientLevel var1, ItemStack var2, Entity var3, RandomSource var4);

        static {
            CODEC = StringRepresentable.fromEnum(TimeSource::values);
        }
    }
}

