/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Vector3f;

public class BlockModelWrapper
implements ItemModel {
    private final List<ItemTintSource> tints;
    private final List<BakedQuad> quads;
    private final Supplier<Vector3f[]> extents;
    private final ModelRenderProperties properties;
    private final boolean animated;

    public BlockModelWrapper(List<ItemTintSource> p_388185_, List<BakedQuad> p_405671_, ModelRenderProperties p_404871_) {
        this.tints = p_388185_;
        this.quads = p_405671_;
        this.properties = p_404871_;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.quads));
        boolean $$3 = false;
        for (BakedQuad $$4 : p_405671_) {
            if (!$$4.sprite().isAnimated()) continue;
            $$3 = true;
            break;
        }
        this.animated = $$3;
    }

    public static Vector3f[] computeExtents(List<BakedQuad> p_404655_) {
        HashSet $$1 = new HashSet();
        for (BakedQuad $$2 : p_404655_) {
            FaceBakery.extractPositions($$2.vertices(), $$1::add);
        }
        return (Vector3f[])$$1.toArray(Vector3f[]::new);
    }

    @Override
    public void update(ItemStackRenderState p_386488_, ItemStack p_386443_, ItemModelResolver p_388726_, ItemDisplayContext p_388231_, @Nullable ClientLevel p_387522_, @Nullable LivingEntity p_387263_, int p_388300_) {
        p_386488_.appendModelIdentityElement(this);
        ItemStackRenderState.LayerRenderState $$7 = p_386488_.newLayer();
        if (p_386443_.hasFoil()) {
            ItemStackRenderState.FoilType $$8 = BlockModelWrapper.hasSpecialAnimatedTexture(p_386443_) ? ItemStackRenderState.FoilType.SPECIAL : ItemStackRenderState.FoilType.STANDARD;
            $$7.setFoilType($$8);
            p_386488_.setAnimated();
            p_386488_.appendModelIdentityElement((Object)$$8);
        }
        int $$9 = this.tints.size();
        int[] $$10 = $$7.prepareTintLayers($$9);
        for (int $$11 = 0; $$11 < $$9; ++$$11) {
            int $$12;
            $$10[$$11] = $$12 = this.tints.get($$11).calculate(p_386443_, p_387522_, p_387263_);
            p_386488_.appendModelIdentityElement($$12);
        }
        $$7.setExtents(this.extents);
        $$7.setRenderType(ItemBlockRenderTypes.getRenderType(p_386443_));
        this.properties.applyToLayer($$7, p_388231_);
        $$7.prepareQuadList().addAll(this.quads);
        if (this.animated) {
            p_386488_.setAnimated();
        }
    }

    private static boolean hasSpecialAnimatedTexture(ItemStack p_387217_) {
        return p_387217_.is(ItemTags.COMPASSES) || p_387217_.is(Items.CLOCK);
    }

    public record Unbaked(ResourceLocation model, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_387684_ -> p_387684_.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)p_387684_, Unbaked::new));

        @Override
        public void resolveDependencies(ResolvableModel.Resolver p_387532_) {
            p_387532_.markDependency(this.model);
        }

        @Override
        public ItemModel bake(ItemModel.BakingContext p_388226_) {
            ModelBaker $$1 = p_388226_.blockModelBaker();
            ResolvedModel $$2 = $$1.getModel(this.model);
            TextureSlots $$3 = $$2.getTopTextureSlots();
            List<BakedQuad> $$4 = $$2.bakeTopGeometry($$3, $$1, BlockModelRotation.X0_Y0).getAll();
            ModelRenderProperties $$5 = ModelRenderProperties.fromResolvedModel($$1, $$2, $$3);
            return new BlockModelWrapper(this.tints, $$4, $$5);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

