/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;
import org.joml.Quaternionfc;

public class PlayerRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    public PlayerRenderer(EntityRendererProvider.Context p_174557_, boolean p_174558_) {
        super(p_174557_, new PlayerModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), p_174558_), 0.5f);
        this.addLayer(new HumanoidArmorLayer(this, new HumanoidArmorModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidArmorModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), p_174557_.getEquipmentRenderer()));
        this.addLayer(new PlayerItemInHandLayer<PlayerRenderState, PlayerModel>(this));
        this.addLayer(new ArrowLayer<PlayerModel>(this, p_174557_));
        this.addLayer(new Deadmau5EarsLayer(this, p_174557_.getModelSet()));
        this.addLayer(new CapeLayer(this, p_174557_.getModelSet(), p_174557_.getEquipmentAssets()));
        this.addLayer(new CustomHeadLayer<PlayerRenderState, PlayerModel>(this, p_174557_.getModelSet()));
        this.addLayer(new WingsLayer<PlayerRenderState, PlayerModel>(this, p_174557_.getModelSet(), p_174557_.getEquipmentRenderer()));
        this.addLayer(new ParrotOnShoulderLayer(this, p_174557_.getModelSet()));
        this.addLayer(new SpinAttackEffectLayer(this, p_174557_.getModelSet()));
        this.addLayer(new BeeStingerLayer<PlayerModel>(this, p_174557_));
    }

    @Override
    protected boolean shouldRenderLayers(PlayerRenderState p_362188_) {
        return !p_362188_.isSpectator;
    }

    @Override
    public Vec3 getRenderOffset(PlayerRenderState p_360756_) {
        Vec3 $$1 = super.getRenderOffset(p_360756_);
        if (p_360756_.isCrouching) {
            return $$1.add(0.0, (double)(p_360756_.scale * -2.0f) / 16.0, 0.0);
        }
        return $$1;
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer p_386861_, HumanoidArm p_373044_) {
        ItemStack $$2 = p_386861_.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack $$3 = p_386861_.getItemInHand(InteractionHand.OFF_HAND);
        HumanoidModel.ArmPose $$4 = PlayerRenderer.getArmPose(p_386861_, $$2, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose $$5 = PlayerRenderer.getArmPose(p_386861_, $$3, InteractionHand.OFF_HAND);
        if ($$4.isTwoHanded()) {
            HumanoidModel.ArmPose armPose = $$5 = $$3.isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (p_386861_.getMainArm() == p_373044_) {
            return $$4;
        }
        return $$5;
    }

    private static HumanoidModel.ArmPose getArmPose(Player p_386775_, ItemStack p_388403_, InteractionHand p_117796_) {
        if (p_388403_.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (!p_386775_.swinging && p_388403_.is(Items.CROSSBOW) && CrossbowItem.isCharged(p_388403_)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if (p_386775_.getUsedItemHand() == p_117796_ && p_386775_.getUseItemRemainingTicks() > 0) {
            ItemUseAnimation $$3 = p_388403_.getUseAnimation();
            if ($$3 == ItemUseAnimation.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if ($$3 == ItemUseAnimation.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if ($$3 == ItemUseAnimation.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if ($$3 == ItemUseAnimation.CROSSBOW) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if ($$3 == ItemUseAnimation.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if ($$3 == ItemUseAnimation.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if ($$3 == ItemUseAnimation.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    @Override
    public ResourceLocation getTextureLocation(PlayerRenderState p_364673_) {
        return p_364673_.skin.texture();
    }

    @Override
    protected void scale(PlayerRenderState p_364943_, PoseStack p_117799_) {
        float $$2 = 0.9375f;
        p_117799_.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    protected void renderNameTag(PlayerRenderState p_363185_, Component p_117809_, PoseStack p_117810_, MultiBufferSource p_117811_, int p_117812_) {
        p_117810_.pushPose();
        if (p_363185_.scoreText != null) {
            super.renderNameTag(p_363185_, p_363185_.scoreText, p_117810_, p_117811_, p_117812_);
            Objects.requireNonNull(this.getFont());
            p_117810_.translate(0.0f, 9.0f * 1.15f * 0.025f, 0.0f);
        }
        super.renderNameTag(p_363185_, p_117809_, p_117810_, p_117811_, p_117812_);
        p_117810_.popPose();
    }

    @Override
    public PlayerRenderState createRenderState() {
        return new PlayerRenderState();
    }

    @Override
    public void extractRenderState(AbstractClientPlayer p_361478_, PlayerRenderState p_360583_, float p_364121_) {
        ItemStack $$7;
        super.extractRenderState(p_361478_, p_360583_, p_364121_);
        HumanoidMobRenderer.extractHumanoidRenderState(p_361478_, p_360583_, p_364121_, this.itemModelResolver);
        p_360583_.leftArmPose = PlayerRenderer.getArmPose(p_361478_, HumanoidArm.LEFT);
        p_360583_.rightArmPose = PlayerRenderer.getArmPose(p_361478_, HumanoidArm.RIGHT);
        p_360583_.skin = p_361478_.getSkin();
        p_360583_.arrowCount = p_361478_.getArrowCount();
        p_360583_.stingerCount = p_361478_.getStingerCount();
        p_360583_.useItemRemainingTicks = p_361478_.getUseItemRemainingTicks();
        p_360583_.swinging = p_361478_.swinging;
        p_360583_.isSpectator = p_361478_.isSpectator();
        p_360583_.showHat = p_361478_.isModelPartShown(PlayerModelPart.HAT);
        p_360583_.showJacket = p_361478_.isModelPartShown(PlayerModelPart.JACKET);
        p_360583_.showLeftPants = p_361478_.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
        p_360583_.showRightPants = p_361478_.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
        p_360583_.showLeftSleeve = p_361478_.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
        p_360583_.showRightSleeve = p_361478_.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
        p_360583_.showCape = p_361478_.isModelPartShown(PlayerModelPart.CAPE);
        PlayerRenderer.extractFlightData(p_361478_, p_360583_, p_364121_);
        PlayerRenderer.extractCapeState(p_361478_, p_360583_, p_364121_);
        if (p_360583_.distanceToCameraSq < 100.0) {
            Scoreboard $$3 = p_361478_.getScoreboard();
            Objective $$4 = $$3.getDisplayObjective(DisplaySlot.BELOW_NAME);
            if ($$4 != null) {
                ReadOnlyScoreInfo $$5 = $$3.getPlayerScoreInfo(p_361478_, $$4);
                MutableComponent $$6 = ReadOnlyScoreInfo.safeFormatValue($$5, $$4.numberFormatOrDefault(StyledFormat.NO_STYLE));
                p_360583_.scoreText = Component.empty().append($$6).append(CommonComponents.SPACE).append($$4.getDisplayName());
            } else {
                p_360583_.scoreText = null;
            }
        } else {
            p_360583_.scoreText = null;
        }
        p_360583_.parrotOnLeftShoulder = PlayerRenderer.getParrotOnShoulder(p_361478_, true);
        p_360583_.parrotOnRightShoulder = PlayerRenderer.getParrotOnShoulder(p_361478_, false);
        p_360583_.id = p_361478_.getId();
        p_360583_.name = p_361478_.getGameProfile().getName();
        p_360583_.heldOnHead.clear();
        if (p_360583_.isUsingItem && ($$7 = p_361478_.getItemInHand(p_360583_.useItemHand)).is(Items.SPYGLASS)) {
            this.itemModelResolver.updateForLiving(p_360583_.heldOnHead, $$7, ItemDisplayContext.HEAD, p_361478_);
        }
    }

    private static void extractFlightData(AbstractClientPlayer p_361452_, PlayerRenderState p_363432_, float p_364796_) {
        p_363432_.fallFlyingTimeInTicks = (float)p_361452_.getFallFlyingTicks() + p_364796_;
        Vec3 $$3 = p_361452_.getViewVector(p_364796_);
        Vec3 $$4 = p_361452_.getDeltaMovementLerped(p_364796_);
        if ($$4.horizontalDistanceSqr() > (double)1.0E-5f && $$3.horizontalDistanceSqr() > (double)1.0E-5f) {
            p_363432_.shouldApplyFlyingYRot = true;
            double $$5 = $$4.horizontal().normalize().dot($$3.horizontal().normalize());
            double $$6 = $$4.x * $$3.z - $$4.z * $$3.x;
            p_363432_.flyingYRot = (float)(Math.signum($$6) * Math.acos(Math.min(1.0, Math.abs($$5))));
        } else {
            p_363432_.shouldApplyFlyingYRot = false;
            p_363432_.flyingYRot = 0.0f;
        }
    }

    private static void extractCapeState(AbstractClientPlayer p_364691_, PlayerRenderState p_360814_, float p_364460_) {
        double $$3 = Mth.lerp((double)p_364460_, p_364691_.xCloakO, p_364691_.xCloak) - Mth.lerp((double)p_364460_, p_364691_.xo, p_364691_.getX());
        double $$4 = Mth.lerp((double)p_364460_, p_364691_.yCloakO, p_364691_.yCloak) - Mth.lerp((double)p_364460_, p_364691_.yo, p_364691_.getY());
        double $$5 = Mth.lerp((double)p_364460_, p_364691_.zCloakO, p_364691_.zCloak) - Mth.lerp((double)p_364460_, p_364691_.zo, p_364691_.getZ());
        float $$6 = Mth.rotLerp(p_364460_, p_364691_.yBodyRotO, p_364691_.yBodyRot);
        double $$7 = Mth.sin($$6 * ((float)Math.PI / 180));
        double $$8 = -Mth.cos($$6 * ((float)Math.PI / 180));
        p_360814_.capeFlap = (float)$$4 * 10.0f;
        p_360814_.capeFlap = Mth.clamp(p_360814_.capeFlap, -6.0f, 32.0f);
        p_360814_.capeLean = (float)($$3 * $$7 + $$5 * $$8) * 100.0f;
        p_360814_.capeLean *= 1.0f - p_360814_.fallFlyingScale();
        p_360814_.capeLean = Mth.clamp(p_360814_.capeLean, 0.0f, 150.0f);
        p_360814_.capeLean2 = (float)($$3 * $$8 - $$5 * $$7) * 100.0f;
        p_360814_.capeLean2 = Mth.clamp(p_360814_.capeLean2, -20.0f, 20.0f);
        float $$9 = Mth.lerp(p_364460_, p_364691_.oBob, p_364691_.bob);
        float $$10 = Mth.lerp(p_364460_, p_364691_.walkDistO, p_364691_.walkDist);
        p_360814_.capeFlap += Mth.sin($$10 * 6.0f) * 32.0f * $$9;
    }

    @Nullable
    private static Parrot.Variant getParrotOnShoulder(AbstractClientPlayer p_363115_, boolean p_360551_) {
        CompoundTag $$2;
        CompoundTag compoundTag = $$2 = p_360551_ ? p_363115_.getShoulderEntityLeft() : p_363115_.getShoulderEntityRight();
        if ($$2.isEmpty()) {
            return null;
        }
        EntityType $$3 = $$2.read("id", EntityType.CODEC).orElse(null);
        if ($$3 == EntityType.PARROT) {
            return $$2.read("Variant", Parrot.Variant.LEGACY_CODEC).orElse(Parrot.Variant.RED_BLUE);
        }
        return null;
    }

    public void renderRightHand(PoseStack p_117771_, MultiBufferSource p_117772_, int p_117773_, ResourceLocation p_363694_, boolean p_366898_) {
        this.renderHand(p_117771_, p_117772_, p_117773_, p_363694_, ((PlayerModel)this.model).rightArm, p_366898_);
    }

    public void renderLeftHand(PoseStack p_117814_, MultiBufferSource p_117815_, int p_117816_, ResourceLocation p_361745_, boolean p_366730_) {
        this.renderHand(p_117814_, p_117815_, p_117816_, p_361745_, ((PlayerModel)this.model).leftArm, p_366730_);
    }

    private void renderHand(PoseStack p_117776_, MultiBufferSource p_117777_, int p_117778_, ResourceLocation p_360319_, ModelPart p_117780_, boolean p_366655_) {
        PlayerModel $$6 = (PlayerModel)this.getModel();
        p_117780_.resetPose();
        p_117780_.visible = true;
        $$6.leftSleeve.visible = p_366655_;
        $$6.rightSleeve.visible = p_366655_;
        $$6.leftArm.zRot = -0.1f;
        $$6.rightArm.zRot = 0.1f;
        p_117780_.render(p_117776_, p_117777_.getBuffer(RenderType.entityTranslucent(p_360319_)), p_117778_, OverlayTexture.NO_OVERLAY);
    }

    @Override
    protected void setupRotations(PlayerRenderState p_363355_, PoseStack p_117803_, float p_117804_, float p_117805_) {
        float $$4 = p_363355_.swimAmount;
        float $$5 = p_363355_.xRot;
        if (p_363355_.isFallFlying) {
            super.setupRotations(p_363355_, p_117803_, p_117804_, p_117805_);
            float $$6 = p_363355_.fallFlyingScale();
            if (!p_363355_.isAutoSpinAttack) {
                p_117803_.mulPose((Quaternionfc)Axis.XP.rotationDegrees($$6 * (-90.0f - $$5)));
            }
            if (p_363355_.shouldApplyFlyingYRot) {
                p_117803_.mulPose((Quaternionfc)Axis.YP.rotation(p_363355_.flyingYRot));
            }
        } else if ($$4 > 0.0f) {
            super.setupRotations(p_363355_, p_117803_, p_117804_, p_117805_);
            float $$7 = p_363355_.isInWater ? -90.0f - $$5 : -90.0f;
            float $$8 = Mth.lerp($$4, 0.0f, $$7);
            p_117803_.mulPose((Quaternionfc)Axis.XP.rotationDegrees($$8));
            if (p_363355_.isVisuallySwimming) {
                p_117803_.translate(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.setupRotations(p_363355_, p_117803_, p_117804_, p_117805_);
        }
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((PlayerRenderState)livingEntityRenderState);
    }

    @Override
    protected /* synthetic */ boolean shouldRenderLayers(LivingEntityRenderState livingEntityRenderState) {
        return this.shouldRenderLayers((PlayerRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    public /* synthetic */ Vec3 getRenderOffset(EntityRenderState entityRenderState) {
        return this.getRenderOffset((PlayerRenderState)entityRenderState);
    }
}

