/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class WingsLayer<S extends HumanoidRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final ElytraModel elytraModel;
    private final ElytraModel elytraBabyModel;
    private final EquipmentLayerRenderer equipmentRenderer;

    public WingsLayer(RenderLayerParent<S, M> p_371607_, EntityModelSet p_371817_, EquipmentLayerRenderer p_371554_) {
        super(p_371607_);
        this.elytraModel = new ElytraModel(p_371817_.bakeLayer(ModelLayers.ELYTRA));
        this.elytraBabyModel = new ElytraModel(p_371817_.bakeLayer(ModelLayers.ELYTRA_BABY));
        this.equipmentRenderer = p_371554_;
    }

    @Override
    public void render(PoseStack p_371573_, MultiBufferSource p_371529_, int p_371828_, S p_371273_, float p_371865_, float p_371528_) {
        ItemStack $$6 = ((HumanoidRenderState)p_371273_).chestEquipment;
        Equippable $$7 = $$6.get(DataComponents.EQUIPPABLE);
        if ($$7 == null || $$7.assetId().isEmpty()) {
            return;
        }
        ResourceLocation $$8 = WingsLayer.getPlayerElytraTexture(p_371273_);
        ElytraModel $$9 = ((HumanoidRenderState)p_371273_).isBaby ? this.elytraBabyModel : this.elytraModel;
        p_371573_.pushPose();
        p_371573_.translate(0.0f, 0.0f, 0.125f);
        $$9.setupAnim((HumanoidRenderState)p_371273_);
        this.equipmentRenderer.renderLayers(EquipmentClientInfo.LayerType.WINGS, $$7.assetId().get(), $$9, $$6, p_371573_, p_371529_, p_371828_, $$8);
        p_371573_.popPose();
    }

    @Nullable
    private static ResourceLocation getPlayerElytraTexture(HumanoidRenderState p_371419_) {
        if (p_371419_ instanceof PlayerRenderState) {
            PlayerRenderState $$1 = (PlayerRenderState)p_371419_;
            PlayerSkin $$2 = $$1.skin;
            if ($$2.elytraTexture() != null) {
                return $$2.elytraTexture();
            }
            if ($$2.capeTexture() != null && $$1.showCape) {
                return $$2.capeTexture();
            }
        }
        return null;
    }
}

