/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Quaternionfc;

public abstract class StuckInBodyLayer<M extends PlayerModel>
extends RenderLayer<PlayerRenderState, M> {
    private final Model model;
    private final ResourceLocation texture;
    private final PlacementStyle placementStyle;

    public StuckInBodyLayer(LivingEntityRenderer<?, PlayerRenderState, M> p_117564_, Model p_360318_, ResourceLocation p_363540_, PlacementStyle p_364028_) {
        super(p_117564_);
        this.model = p_360318_;
        this.texture = p_363540_;
        this.placementStyle = p_364028_;
    }

    protected abstract int numStuck(PlayerRenderState var1);

    private void renderStuckItem(PoseStack p_117566_, MultiBufferSource p_117567_, int p_117568_, float p_117570_, float p_117571_, float p_117572_) {
        float $$6 = Mth.sqrt(p_117570_ * p_117570_ + p_117572_ * p_117572_);
        float $$7 = (float)(Math.atan2(p_117570_, p_117572_) * 57.2957763671875);
        float $$8 = (float)(Math.atan2(p_117571_, $$6) * 57.2957763671875);
        p_117566_.mulPose((Quaternionfc)Axis.YP.rotationDegrees($$7 - 90.0f));
        p_117566_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees($$8));
        this.model.renderToBuffer(p_117566_, p_117567_.getBuffer(this.model.renderType(this.texture)), p_117568_, OverlayTexture.NO_OVERLAY);
    }

    @Override
    public void render(PoseStack p_117575_, MultiBufferSource p_117576_, int p_117577_, PlayerRenderState p_363391_, float p_117579_, float p_117580_) {
        int $$6 = this.numStuck(p_363391_);
        if ($$6 <= 0) {
            return;
        }
        RandomSource $$7 = RandomSource.create(p_363391_.id);
        for (int $$8 = 0; $$8 < $$6; ++$$8) {
            p_117575_.pushPose();
            ModelPart $$9 = ((PlayerModel)this.getParentModel()).getRandomBodyPart($$7);
            ModelPart.Cube $$10 = $$9.getRandomCube($$7);
            $$9.translateAndRotate(p_117575_);
            float $$11 = $$7.nextFloat();
            float $$12 = $$7.nextFloat();
            float $$13 = $$7.nextFloat();
            if (this.placementStyle == PlacementStyle.ON_SURFACE) {
                int $$14 = $$7.nextInt(3);
                switch ($$14) {
                    case 0: {
                        $$11 = StuckInBodyLayer.snapToFace($$11);
                        break;
                    }
                    case 1: {
                        $$12 = StuckInBodyLayer.snapToFace($$12);
                        break;
                    }
                    default: {
                        $$13 = StuckInBodyLayer.snapToFace($$13);
                    }
                }
            }
            p_117575_.translate(Mth.lerp($$11, $$10.minX, $$10.maxX) / 16.0f, Mth.lerp($$12, $$10.minY, $$10.maxY) / 16.0f, Mth.lerp($$13, $$10.minZ, $$10.maxZ) / 16.0f);
            this.renderStuckItem(p_117575_, p_117576_, p_117577_, -($$11 * 2.0f - 1.0f), -($$12 * 2.0f - 1.0f), -($$13 * 2.0f - 1.0f));
            p_117575_.popPose();
        }
    }

    private static float snapToFace(float p_361108_) {
        return p_361108_ > 0.5f ? 1.0f : 0.5f;
    }

    public static enum PlacementStyle {
        IN_CUBE,
        ON_SURFACE;

    }
}

