/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.SheepRenderState;
import net.minecraft.resources.ResourceLocation;

public class SheepWoolLayer
extends RenderLayer<SheepRenderState, SheepModel> {
    private static final ResourceLocation SHEEP_WOOL_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/sheep/sheep_wool.png");
    private final EntityModel<SheepRenderState> adultModel;
    private final EntityModel<SheepRenderState> babyModel;

    public SheepWoolLayer(RenderLayerParent<SheepRenderState, SheepModel> p_362577_, EntityModelSet p_362840_) {
        super(p_362577_);
        this.adultModel = new SheepFurModel(p_362840_.bakeLayer(ModelLayers.SHEEP_WOOL));
        this.babyModel = new SheepFurModel(p_362840_.bakeLayer(ModelLayers.SHEEP_BABY_WOOL));
    }

    @Override
    public void render(PoseStack p_360648_, MultiBufferSource p_361412_, int p_361724_, SheepRenderState p_362704_, float p_363845_, float p_360883_) {
        EntityModel<SheepRenderState> $$6;
        if (p_362704_.isSheared) {
            return;
        }
        EntityModel<SheepRenderState> entityModel = $$6 = p_362704_.isBaby ? this.babyModel : this.adultModel;
        if (p_362704_.isInvisible) {
            if (p_362704_.appearsGlowing) {
                $$6.setupAnim(p_362704_);
                VertexConsumer $$7 = p_361412_.getBuffer(RenderType.outline(SHEEP_WOOL_LOCATION));
                $$6.renderToBuffer(p_360648_, $$7, p_361724_, LivingEntityRenderer.getOverlayCoords(p_362704_, 0.0f), -16777216);
            }
            return;
        }
        SheepWoolLayer.coloredCutoutModelCopyLayerRender($$6, SHEEP_WOOL_LOCATION, p_360648_, p_361412_, p_361724_, p_362704_, p_362704_.getWoolColor());
    }
}

