/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.WitherRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.wither.WitherBoss;

public class WitherBossRenderer
extends MobRenderer<WitherBoss, WitherRenderState, WitherBossModel> {
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/wither/wither.png");

    public WitherBossRenderer(EntityRendererProvider.Context p_174445_) {
        super(p_174445_, new WitherBossModel(p_174445_.bakeLayer(ModelLayers.WITHER)), 1.0f);
        this.addLayer(new WitherArmorLayer(this, p_174445_.getModelSet()));
    }

    @Override
    protected int getBlockLightLevel(WitherBoss p_116443_, BlockPos p_116444_) {
        return 15;
    }

    @Override
    public ResourceLocation getTextureLocation(WitherRenderState p_362122_) {
        int $$1 = Mth.floor(p_362122_.invulnerableTicks);
        if ($$1 <= 0 || $$1 <= 80 && $$1 / 5 % 2 == 1) {
            return WITHER_LOCATION;
        }
        return WITHER_INVULNERABLE_LOCATION;
    }

    @Override
    public WitherRenderState createRenderState() {
        return new WitherRenderState();
    }

    @Override
    protected void scale(WitherRenderState p_360406_, PoseStack p_116440_) {
        float $$2 = 2.0f;
        if (p_360406_.invulnerableTicks > 0.0f) {
            $$2 -= p_360406_.invulnerableTicks / 220.0f * 0.5f;
        }
        p_116440_.scale($$2, $$2, $$2);
    }

    @Override
    public void extractRenderState(WitherBoss p_361169_, WitherRenderState p_362092_, float p_363950_) {
        super.extractRenderState(p_361169_, p_362092_, p_363950_);
        int $$3 = p_361169_.getInvulnerableTicks();
        p_362092_.invulnerableTicks = $$3 > 0 ? (float)$$3 - p_363950_ : 0.0f;
        System.arraycopy(p_361169_.getHeadXRots(), 0, p_362092_.xHeadRots, 0, p_362092_.xHeadRots.length);
        System.arraycopy(p_361169_.getHeadYRots(), 0, p_362092_.yHeadRots, 0, p_362092_.yHeadRots.length);
        p_362092_.isPowered = p_361169_.isPowered();
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((WitherRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

