/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.SimpleEquipmentLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.StriderRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Strider;

public class StriderRenderer
extends AgeableMobRenderer<Strider, StriderRenderState, StriderModel> {
    private static final ResourceLocation STRIDER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/strider/strider.png");
    private static final ResourceLocation COLD_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/strider/strider_cold.png");
    private static final float SHADOW_RADIUS = 0.5f;

    public StriderRenderer(EntityRendererProvider.Context p_174411_) {
        super(p_174411_, new StriderModel(p_174411_.bakeLayer(ModelLayers.STRIDER)), new StriderModel(p_174411_.bakeLayer(ModelLayers.STRIDER_BABY)), 0.5f);
        this.addLayer(new SimpleEquipmentLayer<StriderRenderState, StriderModel, StriderModel>(this, p_174411_.getEquipmentRenderer(), EquipmentClientInfo.LayerType.STRIDER_SADDLE, p_397713_ -> p_397713_.saddle, new StriderModel(p_174411_.bakeLayer(ModelLayers.STRIDER_SADDLE)), new StriderModel(p_174411_.bakeLayer(ModelLayers.STRIDER_BABY_SADDLE))));
    }

    @Override
    public ResourceLocation getTextureLocation(StriderRenderState p_363553_) {
        return p_363553_.isSuffocating ? COLD_LOCATION : STRIDER_LOCATION;
    }

    @Override
    protected float getShadowRadius(StriderRenderState p_365429_) {
        float $$1 = super.getShadowRadius(p_365429_);
        if (p_365429_.isBaby) {
            return $$1 * 0.5f;
        }
        return $$1;
    }

    @Override
    public StriderRenderState createRenderState() {
        return new StriderRenderState();
    }

    @Override
    public void extractRenderState(Strider p_362147_, StriderRenderState p_360861_, float p_363151_) {
        super.extractRenderState(p_362147_, p_360861_, p_363151_);
        p_360861_.saddle = p_362147_.getItemBySlot(EquipmentSlot.SADDLE).copy();
        p_360861_.isSuffocating = p_362147_.isSuffocating();
        p_360861_.isRidden = p_362147_.isVehicle();
    }

    @Override
    protected boolean isShaking(StriderRenderState p_360940_) {
        return super.isShaking(p_360940_) || p_360940_.isSuffocating;
    }

    @Override
    protected /* synthetic */ float getShadowRadius(LivingEntityRenderState livingEntityRenderState) {
        return this.getShadowRadius((StriderRenderState)livingEntityRenderState);
    }

    @Override
    protected /* synthetic */ boolean isShaking(LivingEntityRenderState livingEntityRenderState) {
        return this.isShaking((StriderRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((StriderRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
        return this.getShadowRadius((StriderRenderState)entityRenderState);
    }
}

