/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SlimeRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Slime;

public class SlimeRenderer
extends MobRenderer<Slime, SlimeRenderState, SlimeModel> {
    public static final ResourceLocation SLIME_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/slime/slime.png");

    public SlimeRenderer(EntityRendererProvider.Context p_174391_) {
        super(p_174391_, new SlimeModel(p_174391_.bakeLayer(ModelLayers.SLIME)), 0.25f);
        this.addLayer(new SlimeOuterLayer(this, p_174391_.getModelSet()));
    }

    @Override
    protected float getShadowRadius(SlimeRenderState p_383137_) {
        return (float)p_383137_.size * 0.25f;
    }

    @Override
    protected void scale(SlimeRenderState p_364158_, PoseStack p_115964_) {
        float $$2 = 0.999f;
        p_115964_.scale(0.999f, 0.999f, 0.999f);
        p_115964_.translate(0.0f, 0.001f, 0.0f);
        float $$3 = p_364158_.size;
        float $$4 = p_364158_.squish / ($$3 * 0.5f + 1.0f);
        float $$5 = 1.0f / ($$4 + 1.0f);
        p_115964_.scale($$5 * $$3, 1.0f / $$5 * $$3, $$5 * $$3);
    }

    @Override
    public ResourceLocation getTextureLocation(SlimeRenderState p_365351_) {
        return SLIME_LOCATION;
    }

    @Override
    public SlimeRenderState createRenderState() {
        return new SlimeRenderState();
    }

    @Override
    public void extractRenderState(Slime p_362664_, SlimeRenderState p_365237_, float p_361099_) {
        super.extractRenderState(p_362664_, p_365237_, p_361099_);
        p_365237_.squish = Mth.lerp(p_361099_, p_362664_.oSquish, p_362664_.squish);
        p_365237_.size = p_362664_.getSize();
    }

    @Override
    protected /* synthetic */ float getShadowRadius(LivingEntityRenderState livingEntityRenderState) {
        return this.getShadowRadius((SlimeRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
        return this.getShadowRadius((SlimeRenderState)entityRenderState);
    }
}

