/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class OminousItemSpawnerRenderer
extends EntityRenderer<OminousItemSpawner, ItemClusterRenderState> {
    private static final float ROTATION_SPEED = 40.0f;
    private static final int TICKS_SCALING = 50;
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();

    protected OminousItemSpawnerRenderer(EntityRendererProvider.Context p_338603_) {
        super(p_338603_);
        this.itemModelResolver = p_338603_.getItemModelResolver();
    }

    @Override
    public ItemClusterRenderState createRenderState() {
        return new ItemClusterRenderState();
    }

    @Override
    public void extractRenderState(OminousItemSpawner p_361782_, ItemClusterRenderState p_388307_, float p_361351_) {
        super.extractRenderState(p_361782_, p_388307_, p_361351_);
        ItemStack $$3 = p_361782_.getItem();
        p_388307_.extractItemGroupRenderState(p_361782_, $$3, this.itemModelResolver);
    }

    @Override
    public void render(ItemClusterRenderState p_386695_, PoseStack p_338440_, MultiBufferSource p_338413_, int p_338541_) {
        if (p_386695_.item.isEmpty()) {
            return;
        }
        p_338440_.pushPose();
        if (p_386695_.ageInTicks <= 50.0f) {
            float $$4 = Math.min(p_386695_.ageInTicks, 50.0f) / 50.0f;
            p_338440_.scale($$4, $$4, $$4);
        }
        float $$5 = Mth.wrapDegrees(p_386695_.ageInTicks * 40.0f);
        p_338440_.mulPose((Quaternionfc)Axis.YP.rotationDegrees($$5));
        ItemEntityRenderer.renderMultipleFromCount(p_338440_, p_338413_, 0xF000F0, p_386695_, this.random);
        p_338440_.popPose();
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

