/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.SquidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SquidRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SquidRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.GlowSquid;

public class GlowSquidRenderer
extends SquidRenderer<GlowSquid> {
    private static final ResourceLocation GLOW_SQUID_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/squid/glow_squid.png");

    public GlowSquidRenderer(EntityRendererProvider.Context p_174136_, SquidModel p_174137_, SquidModel p_363229_) {
        super(p_174136_, p_174137_, p_363229_);
    }

    @Override
    public ResourceLocation getTextureLocation(SquidRenderState p_362231_) {
        return GLOW_SQUID_LOCATION;
    }

    @Override
    protected int getBlockLightLevel(GlowSquid p_174146_, BlockPos p_174147_) {
        int $$2 = (int)Mth.clampedLerp(0.0f, 15.0f, 1.0f - (float)p_174146_.getDarkTicksRemaining() / 10.0f);
        if ($$2 == 15) {
            return 15;
        }
        return Math.max($$2, super.getBlockLightLevel(p_174146_, p_174147_));
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((SquidRenderState)livingEntityRenderState);
    }
}

