/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FallingBlockRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class FallingBlockRenderer
extends EntityRenderer<FallingBlockEntity, FallingBlockRenderState> {
    private final BlockRenderDispatcher dispatcher;

    public FallingBlockRenderer(EntityRendererProvider.Context p_174112_) {
        super(p_174112_);
        this.shadowRadius = 0.5f;
        this.dispatcher = p_174112_.getBlockRenderDispatcher();
    }

    @Override
    public boolean shouldRender(FallingBlockEntity p_362415_, Frustum p_364047_, double p_362218_, double p_363427_, double p_361722_) {
        if (!super.shouldRender(p_362415_, p_364047_, p_362218_, p_363427_, p_361722_)) {
            return false;
        }
        return p_362415_.getBlockState() != p_362415_.level().getBlockState(p_362415_.blockPosition());
    }

    @Override
    public void render(FallingBlockRenderState p_361300_, PoseStack p_114637_, MultiBufferSource p_114638_, int p_114639_) {
        BlockState $$4 = p_361300_.blockState;
        if ($$4.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        p_114637_.pushPose();
        p_114637_.translate(-0.5, 0.0, -0.5);
        List<BlockModelPart> $$5 = this.dispatcher.getBlockModel($$4).collectParts(RandomSource.create($$4.getSeed(p_361300_.startBlockPos)));
        this.dispatcher.getModelRenderer().tesselateBlock(p_361300_, $$5, $$4, p_361300_.blockPos, p_114637_, p_114638_.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType($$4)), false, OverlayTexture.NO_OVERLAY);
        p_114637_.popPose();
        super.render(p_361300_, p_114637_, p_114638_, p_114639_);
    }

    @Override
    public FallingBlockRenderState createRenderState() {
        return new FallingBlockRenderState();
    }

    @Override
    public void extractRenderState(FallingBlockEntity p_364559_, FallingBlockRenderState p_360509_, float p_361019_) {
        super.extractRenderState(p_364559_, p_360509_, p_361019_);
        BlockPos $$3 = BlockPos.containing(p_364559_.getX(), p_364559_.getBoundingBox().maxY, p_364559_.getZ());
        p_360509_.startBlockPos = p_364559_.getStartPos();
        p_360509_.blockPos = $$3;
        p_360509_.blockState = p_364559_.getBlockState();
        p_360509_.biome = p_364559_.level().getBiome($$3);
        p_360509_.level = p_364559_.level();
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

