/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.HitboxesRenderState;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public abstract class EntityRenderer<T extends Entity, S extends EntityRenderState> {
    protected static final float NAMETAG_SCALE = 0.025f;
    public static final int LEASH_RENDER_STEPS = 24;
    public static final float LEASH_WIDTH = 0.05f;
    protected final EntityRenderDispatcher entityRenderDispatcher;
    private final Font font;
    protected float shadowRadius;
    protected float shadowStrength = 1.0f;
    private final S reusedState = this.createRenderState();

    protected EntityRenderer(EntityRendererProvider.Context p_174008_) {
        this.entityRenderDispatcher = p_174008_.getEntityRenderDispatcher();
        this.font = p_174008_.getFont();
    }

    public final int getPackedLightCoords(T p_114506_, float p_114507_) {
        BlockPos $$2 = BlockPos.containing(((Entity)p_114506_).getLightProbePosition(p_114507_));
        return LightTexture.pack(this.getBlockLightLevel(p_114506_, $$2), this.getSkyLightLevel(p_114506_, $$2));
    }

    protected int getSkyLightLevel(T p_114509_, BlockPos p_114510_) {
        return ((Entity)p_114509_).level().getBrightness(LightLayer.SKY, p_114510_);
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        if (((Entity)p_114496_).isOnFire()) {
            return 15;
        }
        return ((Entity)p_114496_).level().getBrightness(LightLayer.BLOCK, p_114497_);
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        Leashable $$6;
        Entity $$7;
        if (!((Entity)p_114491_).shouldRender(p_114493_, p_114494_, p_114495_)) {
            return false;
        }
        if (!this.affectedByCulling(p_114491_)) {
            return true;
        }
        AABB $$5 = this.getBoundingBoxForCulling(p_114491_).inflate(0.5);
        if ($$5.hasNaN() || $$5.getSize() == 0.0) {
            $$5 = new AABB(((Entity)p_114491_).getX() - 2.0, ((Entity)p_114491_).getY() - 2.0, ((Entity)p_114491_).getZ() - 2.0, ((Entity)p_114491_).getX() + 2.0, ((Entity)p_114491_).getY() + 2.0, ((Entity)p_114491_).getZ() + 2.0);
        }
        if (p_114492_.isVisible($$5)) {
            return true;
        }
        if (p_114491_ instanceof Leashable && ($$7 = ($$6 = (Leashable)p_114491_).getLeashHolder()) != null) {
            AABB $$8 = this.entityRenderDispatcher.getRenderer($$7).getBoundingBoxForCulling($$7);
            return p_114492_.isVisible($$8) || p_114492_.isVisible($$5.minmax($$8));
        }
        return false;
    }

    protected AABB getBoundingBoxForCulling(T p_361260_) {
        return ((Entity)p_361260_).getBoundingBox();
    }

    protected boolean affectedByCulling(T p_365169_) {
        return true;
    }

    public Vec3 getRenderOffset(S p_364311_) {
        if (((EntityRenderState)p_364311_).passengerOffset != null) {
            return ((EntityRenderState)p_364311_).passengerOffset;
        }
        return Vec3.ZERO;
    }

    public void render(S p_364816_, PoseStack p_114488_, MultiBufferSource p_114489_, int p_114490_) {
        if (((EntityRenderState)p_364816_).leashStates != null) {
            for (EntityRenderState.LeashState $$4 : ((EntityRenderState)p_364816_).leashStates) {
                EntityRenderer.renderLeash(p_114488_, p_114489_, $$4);
            }
        }
        if (((EntityRenderState)p_364816_).nameTag != null) {
            this.renderNameTag(p_364816_, ((EntityRenderState)p_364816_).nameTag, p_114488_, p_114489_, p_114490_);
        }
    }

    private static void renderLeash(PoseStack p_352205_, MultiBufferSource p_352444_, EntityRenderState.LeashState p_364529_) {
        float $$3 = (float)(p_364529_.end.x - p_364529_.start.x);
        float $$4 = (float)(p_364529_.end.y - p_364529_.start.y);
        float $$5 = (float)(p_364529_.end.z - p_364529_.start.z);
        float $$6 = Mth.invSqrt($$3 * $$3 + $$5 * $$5) * 0.05f / 2.0f;
        float $$7 = $$5 * $$6;
        float $$8 = $$3 * $$6;
        p_352205_.pushPose();
        p_352205_.translate(p_364529_.offset);
        VertexConsumer $$9 = p_352444_.getBuffer(RenderType.leash());
        Matrix4f $$10 = p_352205_.last().pose();
        for (int $$11 = 0; $$11 <= 24; ++$$11) {
            EntityRenderer.addVertexPair($$9, $$10, $$3, $$4, $$5, 0.05f, 0.05f, $$7, $$8, $$11, false, p_364529_);
        }
        for (int $$12 = 24; $$12 >= 0; --$$12) {
            EntityRenderer.addVertexPair($$9, $$10, $$3, $$4, $$5, 0.05f, 0.0f, $$7, $$8, $$12, true, p_364529_);
        }
        p_352205_.popPose();
    }

    private static void addVertexPair(VertexConsumer p_352095_, Matrix4f p_352142_, float p_352462_, float p_352226_, float p_352086_, float p_352293_, float p_352138_, float p_352315_, float p_352162_, int p_352406_, boolean p_352079_, EntityRenderState.LeashState p_418052_) {
        float $$22;
        float $$12 = (float)p_352406_ / 24.0f;
        int $$13 = (int)Mth.lerp($$12, p_418052_.startBlockLight, p_418052_.endBlockLight);
        int $$14 = (int)Mth.lerp($$12, p_418052_.startSkyLight, p_418052_.endSkyLight);
        int $$15 = LightTexture.pack($$13, $$14);
        float $$16 = p_352406_ % 2 == (p_352079_ ? 1 : 0) ? 0.7f : 1.0f;
        float $$17 = 0.5f * $$16;
        float $$18 = 0.4f * $$16;
        float $$19 = 0.3f * $$16;
        float $$20 = p_352462_ * $$12;
        if (p_418052_.slack) {
            float $$21 = p_352226_ > 0.0f ? p_352226_ * $$12 * $$12 : p_352226_ - p_352226_ * (1.0f - $$12) * (1.0f - $$12);
        } else {
            $$22 = p_352226_ * $$12;
        }
        float $$23 = p_352086_ * $$12;
        p_352095_.addVertex(p_352142_, $$20 - p_352315_, $$22 + p_352138_, $$23 + p_352162_).setColor($$17, $$18, $$19, 1.0f).setLight($$15);
        p_352095_.addVertex(p_352142_, $$20 + p_352315_, $$22 + p_352293_ - p_352138_, $$23 - p_352162_).setColor($$17, $$18, $$19, 1.0f).setLight($$15);
    }

    protected boolean shouldShowName(T p_114504_, double p_361299_) {
        return ((Entity)p_114504_).shouldShowName() || ((Entity)p_114504_).hasCustomName() && p_114504_ == this.entityRenderDispatcher.crosshairPickEntity;
    }

    public Font getFont() {
        return this.font;
    }

    protected void renderNameTag(S p_360768_, Component p_114499_, PoseStack p_114500_, MultiBufferSource p_114501_, int p_114502_) {
        Vec3 $$5 = ((EntityRenderState)p_360768_).nameTagAttachment;
        if ($$5 == null) {
            return;
        }
        boolean $$6 = !((EntityRenderState)p_360768_).isDiscrete;
        int $$7 = "deadmau5".equals(p_114499_.getString()) ? -10 : 0;
        p_114500_.pushPose();
        p_114500_.translate($$5.x, $$5.y + 0.5, $$5.z);
        p_114500_.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        p_114500_.scale(0.025f, -0.025f, 0.025f);
        Matrix4f $$8 = p_114500_.last().pose();
        Font $$9 = this.getFont();
        float $$10 = (float)(-$$9.width(p_114499_)) / 2.0f;
        int $$11 = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
        $$9.drawInBatch(p_114499_, $$10, (float)$$7, -2130706433, false, $$8, p_114501_, $$6 ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, $$11, p_114502_);
        if ($$6) {
            $$9.drawInBatch(p_114499_, $$10, (float)$$7, -1, false, $$8, p_114501_, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission(p_114502_, 2));
        }
        p_114500_.popPose();
    }

    @Nullable
    protected Component getNameTag(T p_364352_) {
        return ((Entity)p_364352_).getDisplayName();
    }

    protected float getShadowRadius(S p_365191_) {
        return this.shadowRadius;
    }

    protected float getShadowStrength(S p_383214_) {
        return this.shadowStrength;
    }

    public abstract S createRenderState();

    public final S createRenderState(T p_361382_, float p_360885_) {
        S $$2 = this.reusedState;
        this.extractRenderState(p_361382_, $$2, p_360885_);
        return $$2;
    }

    public void extractRenderState(T p_362104_, S p_361028_, float p_362204_) {
        Leashable $$9;
        Entity entity;
        boolean $$8;
        NewMinecartBehavior $$4;
        AbstractMinecart $$3;
        Object object;
        ((EntityRenderState)p_361028_).entityType = ((Entity)p_362104_).getType();
        ((EntityRenderState)p_361028_).x = Mth.lerp((double)p_362204_, ((Entity)p_362104_).xOld, ((Entity)p_362104_).getX());
        ((EntityRenderState)p_361028_).y = Mth.lerp((double)p_362204_, ((Entity)p_362104_).yOld, ((Entity)p_362104_).getY());
        ((EntityRenderState)p_361028_).z = Mth.lerp((double)p_362204_, ((Entity)p_362104_).zOld, ((Entity)p_362104_).getZ());
        ((EntityRenderState)p_361028_).isInvisible = ((Entity)p_362104_).isInvisible();
        ((EntityRenderState)p_361028_).ageInTicks = (float)((Entity)p_362104_).tickCount + p_362204_;
        ((EntityRenderState)p_361028_).boundingBoxWidth = ((Entity)p_362104_).getBbWidth();
        ((EntityRenderState)p_361028_).boundingBoxHeight = ((Entity)p_362104_).getBbHeight();
        ((EntityRenderState)p_361028_).eyeHeight = ((Entity)p_362104_).getEyeHeight();
        if (((Entity)p_362104_).isPassenger() && (object = ((Entity)p_362104_).getVehicle()) instanceof AbstractMinecart && (object = ($$3 = (AbstractMinecart)object).getBehavior()) instanceof NewMinecartBehavior && ($$4 = (NewMinecartBehavior)object).cartHasPosRotLerp()) {
            double $$5 = Mth.lerp((double)p_362204_, $$3.xOld, $$3.getX());
            double $$6 = Mth.lerp((double)p_362204_, $$3.yOld, $$3.getY());
            double $$7 = Mth.lerp((double)p_362204_, $$3.zOld, $$3.getZ());
            ((EntityRenderState)p_361028_).passengerOffset = $$4.getCartLerpPosition(p_362204_).subtract(new Vec3($$5, $$6, $$7));
        } else {
            ((EntityRenderState)p_361028_).passengerOffset = null;
        }
        ((EntityRenderState)p_361028_).distanceToCameraSq = this.entityRenderDispatcher.distanceToSqr((Entity)p_362104_);
        boolean bl = $$8 = ((EntityRenderState)p_361028_).distanceToCameraSq < 4096.0 && this.shouldShowName(p_362104_, ((EntityRenderState)p_361028_).distanceToCameraSq);
        if ($$8) {
            ((EntityRenderState)p_361028_).nameTag = this.getNameTag(p_362104_);
            ((EntityRenderState)p_361028_).nameTagAttachment = ((Entity)p_362104_).getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, ((Entity)p_362104_).getYRot(p_362204_));
        } else {
            ((EntityRenderState)p_361028_).nameTag = null;
        }
        ((EntityRenderState)p_361028_).isDiscrete = ((Entity)p_362104_).isDiscrete();
        if (p_362104_ instanceof Leashable && (entity = ($$9 = (Leashable)p_362104_).getLeashHolder()) instanceof Entity) {
            int $$20;
            Entity $$10 = entity;
            float $$11 = ((Entity)p_362104_).getPreciseBodyRotation(p_362204_) * ((float)Math.PI / 180);
            Vec3 $$12 = $$9.getLeashOffset(p_362204_);
            BlockPos $$13 = BlockPos.containing(((Entity)p_362104_).getEyePosition(p_362204_));
            BlockPos $$14 = BlockPos.containing($$10.getEyePosition(p_362204_));
            int $$15 = this.getBlockLightLevel(p_362104_, $$13);
            int $$16 = this.entityRenderDispatcher.getRenderer($$10).getBlockLightLevel($$10, $$14);
            int $$17 = ((Entity)p_362104_).level().getBrightness(LightLayer.SKY, $$13);
            int $$18 = ((Entity)p_362104_).level().getBrightness(LightLayer.SKY, $$14);
            boolean $$19 = $$10.supportQuadLeashAsHolder() && $$9.supportQuadLeash();
            int n = $$20 = $$19 ? 4 : 1;
            if (((EntityRenderState)p_361028_).leashStates == null || ((EntityRenderState)p_361028_).leashStates.size() != $$20) {
                ((EntityRenderState)p_361028_).leashStates = new ArrayList<EntityRenderState.LeashState>($$20);
                for (int $$21 = 0; $$21 < $$20; ++$$21) {
                    ((EntityRenderState)p_361028_).leashStates.add(new EntityRenderState.LeashState());
                }
            }
            if ($$19) {
                float $$22 = $$10.getPreciseBodyRotation(p_362204_) * ((float)Math.PI / 180);
                Vec3 $$23 = $$10.getPosition(p_362204_);
                Vec3[] $$24 = $$9.getQuadLeashOffsets();
                Vec3[] $$25 = $$10.getQuadLeashHolderOffsets();
                for (int $$26 = 0; $$26 < $$20; ++$$26) {
                    EntityRenderState.LeashState $$27 = ((EntityRenderState)p_361028_).leashStates.get($$26);
                    $$27.offset = $$24[$$26].yRot(-$$11);
                    $$27.start = ((Entity)p_362104_).getPosition(p_362204_).add($$27.offset);
                    $$27.end = $$23.add($$25[$$26].yRot(-$$22));
                    $$27.startBlockLight = $$15;
                    $$27.endBlockLight = $$16;
                    $$27.startSkyLight = $$17;
                    $$27.endSkyLight = $$18;
                    $$27.slack = false;
                }
            } else {
                Vec3 $$28 = $$12.yRot(-$$11);
                EntityRenderState.LeashState $$29 = ((EntityRenderState)p_361028_).leashStates.getFirst();
                $$29.offset = $$28;
                $$29.start = ((Entity)p_362104_).getPosition(p_362204_).add($$28);
                $$29.end = $$10.getRopeHoldPosition(p_362204_);
                $$29.startBlockLight = $$15;
                $$29.endBlockLight = $$16;
                $$29.startSkyLight = $$17;
                $$29.endSkyLight = $$18;
            }
        } else {
            ((EntityRenderState)p_361028_).leashStates = null;
        }
        ((EntityRenderState)p_361028_).displayFireAnimation = ((Entity)p_362104_).displayFireAnimation();
        Minecraft $$30 = Minecraft.getInstance();
        if ($$30.getEntityRenderDispatcher().shouldRenderHitBoxes() && !((EntityRenderState)p_361028_).isInvisible && !$$30.showOnlyReducedInfo()) {
            this.extractHitboxes(p_362104_, p_361028_, p_362204_);
        } else {
            ((EntityRenderState)p_361028_).hitboxesRenderState = null;
            ((EntityRenderState)p_361028_).serverHitboxesRenderState = null;
        }
    }

    private void extractHitboxes(T p_412316_, S p_412142_, float p_412603_) {
        ((EntityRenderState)p_412142_).hitboxesRenderState = this.extractHitboxes(p_412316_, p_412603_, false);
        ((EntityRenderState)p_412142_).serverHitboxesRenderState = null;
    }

    private HitboxesRenderState extractHitboxes(T p_412086_, float p_412327_, boolean p_412207_) {
        HitboxRenderState $$6;
        ImmutableList.Builder $$3 = new ImmutableList.Builder();
        AABB $$4 = ((Entity)p_412086_).getBoundingBox();
        if (p_412207_) {
            HitboxRenderState $$5 = new HitboxRenderState($$4.minX - ((Entity)p_412086_).getX(), $$4.minY - ((Entity)p_412086_).getY(), $$4.minZ - ((Entity)p_412086_).getZ(), $$4.maxX - ((Entity)p_412086_).getX(), $$4.maxY - ((Entity)p_412086_).getY(), $$4.maxZ - ((Entity)p_412086_).getZ(), 0.0f, 1.0f, 0.0f);
        } else {
            $$6 = new HitboxRenderState($$4.minX - ((Entity)p_412086_).getX(), $$4.minY - ((Entity)p_412086_).getY(), $$4.minZ - ((Entity)p_412086_).getZ(), $$4.maxX - ((Entity)p_412086_).getX(), $$4.maxY - ((Entity)p_412086_).getY(), $$4.maxZ - ((Entity)p_412086_).getZ(), 1.0f, 1.0f, 1.0f);
        }
        $$3.add((Object)$$6);
        Entity $$7 = ((Entity)p_412086_).getVehicle();
        if ($$7 != null) {
            float $$8 = Math.min($$7.getBbWidth(), ((Entity)p_412086_).getBbWidth()) / 2.0f;
            float $$9 = 0.0625f;
            Vec3 $$10 = $$7.getPassengerRidingPosition((Entity)p_412086_).subtract(((Entity)p_412086_).position());
            HitboxRenderState $$11 = new HitboxRenderState($$10.x - (double)$$8, $$10.y, $$10.z - (double)$$8, $$10.x + (double)$$8, $$10.y + 0.0625, $$10.z + (double)$$8, 1.0f, 1.0f, 0.0f);
            $$3.add((Object)$$11);
        }
        this.extractAdditionalHitboxes(p_412086_, (ImmutableList.Builder<HitboxRenderState>)$$3, p_412327_);
        Vec3 $$12 = ((Entity)p_412086_).getViewVector(p_412327_);
        return new HitboxesRenderState($$12.x, $$12.y, $$12.z, (ImmutableList<HitboxRenderState>)$$3.build());
    }

    protected void extractAdditionalHitboxes(T p_412199_, ImmutableList.Builder<HitboxRenderState> p_412387_, float p_412468_) {
    }

    @Nullable
    private static Entity getServerSideEntity(Entity p_412597_) {
        ServerLevel $$2;
        IntegratedServer $$1 = Minecraft.getInstance().getSingleplayerServer();
        if ($$1 != null && ($$2 = $$1.getLevel(p_412597_.level().dimension())) != null) {
            return $$2.getEntity(p_412597_.getId());
        }
        return null;
    }
}

