/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.DrownedOuterLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;

public class DrownedRenderer
extends AbstractZombieRenderer<Drowned, ZombieRenderState, DrownedModel> {
    private static final ResourceLocation DROWNED_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/zombie/drowned.png");

    public DrownedRenderer(EntityRendererProvider.Context p_173964_) {
        super(p_173964_, new DrownedModel(p_173964_.bakeLayer(ModelLayers.DROWNED)), new DrownedModel(p_173964_.bakeLayer(ModelLayers.DROWNED_BABY)), new DrownedModel(p_173964_.bakeLayer(ModelLayers.DROWNED_INNER_ARMOR)), new DrownedModel(p_173964_.bakeLayer(ModelLayers.DROWNED_OUTER_ARMOR)), new DrownedModel(p_173964_.bakeLayer(ModelLayers.DROWNED_BABY_INNER_ARMOR)), new DrownedModel(p_173964_.bakeLayer(ModelLayers.DROWNED_BABY_OUTER_ARMOR)));
        this.addLayer(new DrownedOuterLayer(this, p_173964_.getModelSet()));
    }

    @Override
    public ZombieRenderState createRenderState() {
        return new ZombieRenderState();
    }

    @Override
    public ResourceLocation getTextureLocation(ZombieRenderState p_361561_) {
        return DROWNED_LOCATION;
    }

    @Override
    protected void setupRotations(ZombieRenderState p_361137_, PoseStack p_114104_, float p_114105_, float p_114106_) {
        super.setupRotations(p_361137_, p_114104_, p_114105_, p_114106_);
        float $$4 = p_361137_.swimAmount;
        if ($$4 > 0.0f) {
            float $$5 = -10.0f - p_361137_.xRot;
            float $$6 = Mth.lerp($$4, 0.0f, $$5);
            p_114104_.rotateAround((Quaternionfc)Axis.XP.rotationDegrees($$6), 0.0f, p_361137_.boundingBoxHeight / 2.0f / p_114106_, 0.0f);
        }
    }

    @Override
    protected HumanoidModel.ArmPose getArmPose(Drowned p_388016_, HumanoidArm p_386643_) {
        ItemStack $$2 = p_388016_.getItemHeldByArm(p_386643_);
        if (p_388016_.getMainArm() == p_386643_ && p_388016_.isAggressive() && $$2.is(Items.TRIDENT)) {
            return HumanoidModel.ArmPose.THROW_SPEAR;
        }
        return HumanoidModel.ArmPose.EMPTY;
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((ZombieRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

