/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.BlockDisplayEntityRenderState;
import net.minecraft.client.renderer.entity.state.DisplayEntityRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemDisplayEntityRenderState;
import net.minecraft.client.renderer.entity.state.TextDisplayEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class DisplayRenderer<T extends Display, S, ST extends DisplayEntityRenderState>
extends EntityRenderer<T, ST> {
    private final EntityRenderDispatcher entityRenderDispatcher;

    protected DisplayRenderer(EntityRendererProvider.Context p_270168_) {
        super(p_270168_);
        this.entityRenderDispatcher = p_270168_.getEntityRenderDispatcher();
    }

    @Override
    protected AABB getBoundingBoxForCulling(T p_363062_) {
        return ((Display)p_363062_).getBoundingBoxForCulling();
    }

    @Override
    protected boolean affectedByCulling(T p_362589_) {
        return ((Display)p_362589_).affectedByCulling();
    }

    private static int getBrightnessOverride(Display p_368691_) {
        Display.RenderState $$1 = p_368691_.renderState();
        return $$1 != null ? $$1.brightnessOverride() : -1;
    }

    @Override
    protected int getSkyLightLevel(T p_368549_, BlockPos p_368562_) {
        int $$2 = DisplayRenderer.getBrightnessOverride(p_368549_);
        if ($$2 != -1) {
            return LightTexture.sky($$2);
        }
        return super.getSkyLightLevel(p_368549_, p_368562_);
    }

    @Override
    protected int getBlockLightLevel(T p_368656_, BlockPos p_368591_) {
        int $$2 = DisplayRenderer.getBrightnessOverride(p_368656_);
        if ($$2 != -1) {
            return LightTexture.block($$2);
        }
        return super.getBlockLightLevel(p_368656_, p_368591_);
    }

    @Override
    protected float getShadowRadius(ST p_382866_) {
        Display.RenderState $$1 = ((DisplayEntityRenderState)p_382866_).renderState;
        if ($$1 == null) {
            return 0.0f;
        }
        return $$1.shadowRadius().get(((DisplayEntityRenderState)p_382866_).interpolationProgress);
    }

    @Override
    protected float getShadowStrength(ST p_383074_) {
        Display.RenderState $$1 = ((DisplayEntityRenderState)p_383074_).renderState;
        if ($$1 == null) {
            return 0.0f;
        }
        return $$1.shadowStrength().get(((DisplayEntityRenderState)p_383074_).interpolationProgress);
    }

    @Override
    public void render(ST p_360624_, PoseStack p_270117_, MultiBufferSource p_270319_, int p_270659_) {
        Display.RenderState $$4 = ((DisplayEntityRenderState)p_360624_).renderState;
        if ($$4 == null || !((DisplayEntityRenderState)p_360624_).hasSubState()) {
            return;
        }
        float $$5 = ((DisplayEntityRenderState)p_360624_).interpolationProgress;
        super.render(p_360624_, p_270117_, p_270319_, p_270659_);
        p_270117_.pushPose();
        p_270117_.mulPose((Quaternionfc)this.calculateOrientation($$4, p_360624_, new Quaternionf()));
        Transformation $$6 = $$4.transformation().get($$5);
        p_270117_.mulPose($$6.getMatrix());
        this.renderInner(p_360624_, p_270117_, p_270319_, p_270659_, $$5);
        p_270117_.popPose();
    }

    private Quaternionf calculateOrientation(Display.RenderState p_277846_, ST p_364909_, Quaternionf p_295809_) {
        Camera $$3 = this.entityRenderDispatcher.camera;
        return switch (p_277846_.billboardConstraints()) {
            default -> throw new MatchException(null, null);
            case Display.BillboardConstraints.FIXED -> p_295809_.rotationYXZ((float)(-Math.PI) / 180 * ((DisplayEntityRenderState)p_364909_).entityYRot, (float)Math.PI / 180 * ((DisplayEntityRenderState)p_364909_).entityXRot, 0.0f);
            case Display.BillboardConstraints.HORIZONTAL -> p_295809_.rotationYXZ((float)(-Math.PI) / 180 * ((DisplayEntityRenderState)p_364909_).entityYRot, (float)Math.PI / 180 * DisplayRenderer.cameraXRot($$3), 0.0f);
            case Display.BillboardConstraints.VERTICAL -> p_295809_.rotationYXZ((float)(-Math.PI) / 180 * DisplayRenderer.cameraYrot($$3), (float)Math.PI / 180 * ((DisplayEntityRenderState)p_364909_).entityXRot, 0.0f);
            case Display.BillboardConstraints.CENTER -> p_295809_.rotationYXZ((float)(-Math.PI) / 180 * DisplayRenderer.cameraYrot($$3), (float)Math.PI / 180 * DisplayRenderer.cameraXRot($$3), 0.0f);
        };
    }

    private static float cameraYrot(Camera p_295988_) {
        return p_295988_.getYRot() - 180.0f;
    }

    private static float cameraXRot(Camera p_295299_) {
        return -p_295299_.getXRot();
    }

    private static <T extends Display> float entityYRot(T p_295109_, float p_295760_) {
        return p_295109_.getYRot(p_295760_);
    }

    private static <T extends Display> float entityXRot(T p_295884_, float p_294935_) {
        return p_295884_.getXRot(p_294935_);
    }

    protected abstract void renderInner(ST var1, PoseStack var2, MultiBufferSource var3, int var4, float var5);

    @Override
    public void extractRenderState(T p_362672_, ST p_361329_, float p_365301_) {
        super.extractRenderState(p_362672_, p_361329_, p_365301_);
        ((DisplayEntityRenderState)p_361329_).renderState = ((Display)p_362672_).renderState();
        ((DisplayEntityRenderState)p_361329_).interpolationProgress = ((Display)p_362672_).calculateInterpolationProgress(p_365301_);
        ((DisplayEntityRenderState)p_361329_).entityYRot = DisplayRenderer.entityYRot(p_362672_, p_365301_);
        ((DisplayEntityRenderState)p_361329_).entityXRot = DisplayRenderer.entityXRot(p_362672_, p_365301_);
    }

    @Override
    protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
        return this.getShadowRadius((ST)((DisplayEntityRenderState)entityRenderState));
    }

    @Override
    protected /* synthetic */ int getBlockLightLevel(Entity entity, BlockPos blockPos) {
        return this.getBlockLightLevel((T)((Display)entity), blockPos);
    }

    @Override
    protected /* synthetic */ int getSkyLightLevel(Entity entity, BlockPos blockPos) {
        return this.getSkyLightLevel((T)((Display)entity), blockPos);
    }

    public static class TextDisplayRenderer
    extends DisplayRenderer<Display.TextDisplay, Display.TextDisplay.TextRenderState, TextDisplayEntityRenderState> {
        private final Font font;

        protected TextDisplayRenderer(EntityRendererProvider.Context p_271012_) {
            super(p_271012_);
            this.font = p_271012_.getFont();
        }

        @Override
        public TextDisplayEntityRenderState createRenderState() {
            return new TextDisplayEntityRenderState();
        }

        @Override
        public void extractRenderState(Display.TextDisplay p_362264_, TextDisplayEntityRenderState p_365023_, float p_365012_) {
            super.extractRenderState(p_362264_, p_365023_, p_365012_);
            p_365023_.textRenderState = p_362264_.textRenderState();
            p_365023_.cachedInfo = p_362264_.cacheDisplay(this::splitLines);
        }

        private Display.TextDisplay.CachedInfo splitLines(Component p_270823_, int p_270893_) {
            List<FormattedCharSequence> $$2 = this.font.split(p_270823_, p_270893_);
            ArrayList<Display.TextDisplay.CachedLine> $$3 = new ArrayList<Display.TextDisplay.CachedLine>($$2.size());
            int $$4 = 0;
            for (FormattedCharSequence $$5 : $$2) {
                int $$6 = this.font.width($$5);
                $$4 = Math.max($$4, $$6);
                $$3.add(new Display.TextDisplay.CachedLine($$5, $$6));
            }
            return new Display.TextDisplay.CachedInfo($$3, $$4);
        }

        @Override
        public void renderInner(TextDisplayEntityRenderState p_363505_, PoseStack p_277503_, MultiBufferSource p_278036_, int p_278079_, float p_277784_) {
            int $$14;
            Display.TextDisplay.TextRenderState $$5 = p_363505_.textRenderState;
            byte $$6 = $$5.flags();
            boolean $$7 = ($$6 & 2) != 0;
            boolean $$8 = ($$6 & 4) != 0;
            boolean $$9 = ($$6 & 1) != 0;
            Display.TextDisplay.Align $$10 = Display.TextDisplay.getAlign($$6);
            byte $$11 = (byte)$$5.textOpacity().get(p_277784_);
            if ($$8) {
                float $$12 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
                int $$13 = (int)($$12 * 255.0f) << 24;
            } else {
                $$14 = $$5.backgroundColor().get(p_277784_);
            }
            float $$15 = 0.0f;
            Matrix4f $$16 = p_277503_.last().pose();
            $$16.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
            $$16.scale(-0.025f, -0.025f, -0.025f);
            Display.TextDisplay.CachedInfo $$17 = p_363505_.cachedInfo;
            boolean $$18 = true;
            int $$19 = this.font.lineHeight + 1;
            int $$20 = $$17.width();
            int $$21 = $$17.lines().size() * $$19 - 1;
            $$16.translate(1.0f - (float)$$20 / 2.0f, (float)(-$$21), 0.0f);
            if ($$14 != 0) {
                VertexConsumer $$22 = p_278036_.getBuffer($$7 ? RenderType.textBackgroundSeeThrough() : RenderType.textBackground());
                $$22.addVertex($$16, -1.0f, -1.0f, 0.0f).setColor($$14).setLight(p_278079_);
                $$22.addVertex($$16, -1.0f, (float)$$21, 0.0f).setColor($$14).setLight(p_278079_);
                $$22.addVertex($$16, (float)$$20, (float)$$21, 0.0f).setColor($$14).setLight(p_278079_);
                $$22.addVertex($$16, (float)$$20, -1.0f, 0.0f).setColor($$14).setLight(p_278079_);
            }
            for (Display.TextDisplay.CachedLine $$23 : $$17.lines()) {
                float $$24 = switch ($$10) {
                    default -> throw new MatchException(null, null);
                    case Display.TextDisplay.Align.LEFT -> 0.0f;
                    case Display.TextDisplay.Align.RIGHT -> $$20 - $$23.width();
                    case Display.TextDisplay.Align.CENTER -> (float)$$20 / 2.0f - (float)$$23.width() / 2.0f;
                };
                this.font.drawInBatch($$23.contents(), $$24, $$15, $$11 << 24 | 0xFFFFFF, $$9, $$16, p_278036_, $$7 ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.POLYGON_OFFSET, 0, p_278079_);
                $$15 += (float)$$19;
            }
        }

        @Override
        public /* synthetic */ EntityRenderState createRenderState() {
            return this.createRenderState();
        }

        @Override
        protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
            return super.getShadowRadius((DisplayEntityRenderState)entityRenderState);
        }

        @Override
        protected /* synthetic */ int getBlockLightLevel(Entity entity, BlockPos blockPos) {
            return super.getBlockLightLevel((Display)entity, blockPos);
        }

        @Override
        protected /* synthetic */ int getSkyLightLevel(Entity entity, BlockPos blockPos) {
            return super.getSkyLightLevel((Display)entity, blockPos);
        }
    }

    public static class ItemDisplayRenderer
    extends DisplayRenderer<Display.ItemDisplay, Display.ItemDisplay.ItemRenderState, ItemDisplayEntityRenderState> {
        private final ItemModelResolver itemModelResolver;

        protected ItemDisplayRenderer(EntityRendererProvider.Context p_270110_) {
            super(p_270110_);
            this.itemModelResolver = p_270110_.getItemModelResolver();
        }

        @Override
        public ItemDisplayEntityRenderState createRenderState() {
            return new ItemDisplayEntityRenderState();
        }

        @Override
        public void extractRenderState(Display.ItemDisplay p_360671_, ItemDisplayEntityRenderState p_361611_, float p_361257_) {
            super.extractRenderState(p_360671_, p_361611_, p_361257_);
            Display.ItemDisplay.ItemRenderState $$3 = p_360671_.itemRenderState();
            if ($$3 != null) {
                this.itemModelResolver.updateForNonLiving(p_361611_.item, $$3.itemStack(), $$3.itemTransform(), p_360671_);
            } else {
                p_361611_.item.clear();
            }
        }

        @Override
        public void renderInner(ItemDisplayEntityRenderState p_364899_, PoseStack p_277361_, MultiBufferSource p_277912_, int p_277474_, float p_278032_) {
            if (p_364899_.item.isEmpty()) {
                return;
            }
            p_277361_.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
            p_364899_.item.render(p_277361_, p_277912_, p_277474_, OverlayTexture.NO_OVERLAY);
        }

        @Override
        public /* synthetic */ EntityRenderState createRenderState() {
            return this.createRenderState();
        }

        @Override
        protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
            return super.getShadowRadius((DisplayEntityRenderState)entityRenderState);
        }

        @Override
        protected /* synthetic */ int getBlockLightLevel(Entity entity, BlockPos blockPos) {
            return super.getBlockLightLevel((Display)entity, blockPos);
        }

        @Override
        protected /* synthetic */ int getSkyLightLevel(Entity entity, BlockPos blockPos) {
            return super.getSkyLightLevel((Display)entity, blockPos);
        }
    }

    public static class BlockDisplayRenderer
    extends DisplayRenderer<Display.BlockDisplay, Display.BlockDisplay.BlockRenderState, BlockDisplayEntityRenderState> {
        private final BlockRenderDispatcher blockRenderer;

        protected BlockDisplayRenderer(EntityRendererProvider.Context p_270283_) {
            super(p_270283_);
            this.blockRenderer = p_270283_.getBlockRenderDispatcher();
        }

        @Override
        public BlockDisplayEntityRenderState createRenderState() {
            return new BlockDisplayEntityRenderState();
        }

        @Override
        public void extractRenderState(Display.BlockDisplay p_362697_, BlockDisplayEntityRenderState p_363759_, float p_360854_) {
            super.extractRenderState(p_362697_, p_363759_, p_360854_);
            p_363759_.blockRenderState = p_362697_.blockRenderState();
        }

        @Override
        public void renderInner(BlockDisplayEntityRenderState p_362193_, PoseStack p_277831_, MultiBufferSource p_277554_, int p_278071_, float p_277847_) {
            this.blockRenderer.renderSingleBlock(p_362193_.blockRenderState.blockState(), p_277831_, p_277554_, p_278071_, OverlayTexture.NO_OVERLAY);
        }

        @Override
        public /* synthetic */ EntityRenderState createRenderState() {
            return this.createRenderState();
        }

        @Override
        protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
            return super.getShadowRadius((DisplayEntityRenderState)entityRenderState);
        }

        @Override
        protected /* synthetic */ int getBlockLightLevel(Entity entity, BlockPos blockPos) {
            return super.getBlockLightLevel((Display)entity, blockPos);
        }

        @Override
        protected /* synthetic */ int getSkyLightLevel(Entity entity, BlockPos blockPos) {
            return super.getSkyLightLevel((Display)entity, blockPos);
        }
    }
}

