/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;

public abstract class AbstractZombieRenderer<T extends Zombie, S extends ZombieRenderState, M extends ZombieModel<S>>
extends HumanoidMobRenderer<T, S, M> {
    private static final ResourceLocation ZOMBIE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/zombie/zombie.png");

    protected AbstractZombieRenderer(EntityRendererProvider.Context p_173910_, M p_173911_, M p_173912_, M p_173913_, M p_362588_, M p_362370_, M p_362061_) {
        super(p_173910_, p_173911_, p_173912_, 0.5f);
        this.addLayer(new HumanoidArmorLayer(this, p_173913_, p_362588_, p_362370_, p_362061_, p_173910_.getEquipmentRenderer()));
    }

    @Override
    public ResourceLocation getTextureLocation(S p_362921_) {
        return ZOMBIE_LOCATION;
    }

    @Override
    public void extractRenderState(T p_360674_, S p_365238_, float p_361332_) {
        super.extractRenderState(p_360674_, p_365238_, p_361332_);
        ((ZombieRenderState)p_365238_).isAggressive = ((Mob)p_360674_).isAggressive();
        ((ZombieRenderState)p_365238_).isConverting = ((Zombie)p_360674_).isUnderWaterConverting();
    }

    @Override
    protected boolean isShaking(S p_363333_) {
        return super.isShaking(p_363333_) || ((ZombieRenderState)p_363333_).isConverting;
    }

    @Override
    protected /* synthetic */ boolean isShaking(LivingEntityRenderState livingEntityRenderState) {
        return this.isShaking((S)((ZombieRenderState)livingEntityRenderState));
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((S)((ZombieRenderState)livingEntityRenderState));
    }
}

