/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.BeeDebugRenderer;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.BreezeDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkBorderRenderer;
import net.minecraft.client.renderer.debug.ChunkCullingDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkDebugRenderer;
import net.minecraft.client.renderer.debug.CollisionBoxRenderer;
import net.minecraft.client.renderer.debug.GameEventListenerRenderer;
import net.minecraft.client.renderer.debug.GameTestDebugRenderer;
import net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer;
import net.minecraft.client.renderer.debug.HeightMapRenderer;
import net.minecraft.client.renderer.debug.LightDebugRenderer;
import net.minecraft.client.renderer.debug.LightSectionDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateRenderer;
import net.minecraft.client.renderer.debug.OctreeDebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingRenderer;
import net.minecraft.client.renderer.debug.RaidDebugRenderer;
import net.minecraft.client.renderer.debug.RedstoneWireOrientationsRenderer;
import net.minecraft.client.renderer.debug.SolidFaceRenderer;
import net.minecraft.client.renderer.debug.StructureRenderer;
import net.minecraft.client.renderer.debug.SupportBlockRenderer;
import net.minecraft.client.renderer.debug.VillageSectionsDebugRenderer;
import net.minecraft.client.renderer.debug.WaterDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionfc;

public class DebugRenderer {
    public final PathfindingRenderer pathfindingRenderer = new PathfindingRenderer();
    public final SimpleDebugRenderer waterDebugRenderer;
    public final SimpleDebugRenderer chunkBorderRenderer;
    public final SimpleDebugRenderer heightMapRenderer;
    public final SimpleDebugRenderer collisionBoxRenderer;
    public final SimpleDebugRenderer supportBlockRenderer;
    public final NeighborsUpdateRenderer neighborsUpdateRenderer;
    public final RedstoneWireOrientationsRenderer redstoneWireOrientationsRenderer;
    public final StructureRenderer structureRenderer;
    public final SimpleDebugRenderer lightDebugRenderer;
    public final SimpleDebugRenderer worldGenAttemptRenderer;
    public final SimpleDebugRenderer solidFaceRenderer;
    public final SimpleDebugRenderer chunkRenderer;
    public final BrainDebugRenderer brainDebugRenderer;
    public final VillageSectionsDebugRenderer villageSectionsDebugRenderer;
    public final BeeDebugRenderer beeDebugRenderer;
    public final RaidDebugRenderer raidDebugRenderer;
    public final GoalSelectorDebugRenderer goalSelectorRenderer;
    public final GameTestDebugRenderer gameTestDebugRenderer;
    public final GameEventListenerRenderer gameEventListenerRenderer;
    public final LightSectionDebugRenderer skyLightSectionDebugRenderer;
    public final BreezeDebugRenderer breezeDebugRenderer;
    public final ChunkCullingDebugRenderer chunkCullingDebugRenderer;
    public final OctreeDebugRenderer octreeDebugRenderer;
    private boolean renderChunkborder;
    private boolean renderOctree;

    public DebugRenderer(Minecraft p_113433_) {
        this.waterDebugRenderer = new WaterDebugRenderer(p_113433_);
        this.chunkBorderRenderer = new ChunkBorderRenderer(p_113433_);
        this.heightMapRenderer = new HeightMapRenderer(p_113433_);
        this.collisionBoxRenderer = new CollisionBoxRenderer(p_113433_);
        this.supportBlockRenderer = new SupportBlockRenderer(p_113433_);
        this.neighborsUpdateRenderer = new NeighborsUpdateRenderer(p_113433_);
        this.redstoneWireOrientationsRenderer = new RedstoneWireOrientationsRenderer(p_113433_);
        this.structureRenderer = new StructureRenderer(p_113433_);
        this.lightDebugRenderer = new LightDebugRenderer(p_113433_);
        this.worldGenAttemptRenderer = new WorldGenAttemptRenderer();
        this.solidFaceRenderer = new SolidFaceRenderer(p_113433_);
        this.chunkRenderer = new ChunkDebugRenderer(p_113433_);
        this.brainDebugRenderer = new BrainDebugRenderer(p_113433_);
        this.villageSectionsDebugRenderer = new VillageSectionsDebugRenderer();
        this.beeDebugRenderer = new BeeDebugRenderer(p_113433_);
        this.raidDebugRenderer = new RaidDebugRenderer(p_113433_);
        this.goalSelectorRenderer = new GoalSelectorDebugRenderer(p_113433_);
        this.gameTestDebugRenderer = new GameTestDebugRenderer();
        this.gameEventListenerRenderer = new GameEventListenerRenderer(p_113433_);
        this.skyLightSectionDebugRenderer = new LightSectionDebugRenderer(p_113433_, LightLayer.SKY);
        this.breezeDebugRenderer = new BreezeDebugRenderer(p_113433_);
        this.chunkCullingDebugRenderer = new ChunkCullingDebugRenderer(p_113433_);
        this.octreeDebugRenderer = new OctreeDebugRenderer(p_113433_);
    }

    public void clear() {
        this.pathfindingRenderer.clear();
        this.waterDebugRenderer.clear();
        this.chunkBorderRenderer.clear();
        this.heightMapRenderer.clear();
        this.collisionBoxRenderer.clear();
        this.supportBlockRenderer.clear();
        this.neighborsUpdateRenderer.clear();
        this.structureRenderer.clear();
        this.lightDebugRenderer.clear();
        this.worldGenAttemptRenderer.clear();
        this.solidFaceRenderer.clear();
        this.chunkRenderer.clear();
        this.brainDebugRenderer.clear();
        this.villageSectionsDebugRenderer.clear();
        this.beeDebugRenderer.clear();
        this.raidDebugRenderer.clear();
        this.goalSelectorRenderer.clear();
        this.gameTestDebugRenderer.clear();
        this.gameEventListenerRenderer.clear();
        this.skyLightSectionDebugRenderer.clear();
        this.breezeDebugRenderer.clear();
        this.chunkCullingDebugRenderer.clear();
    }

    public boolean switchRenderChunkborder() {
        this.renderChunkborder = !this.renderChunkborder;
        return this.renderChunkborder;
    }

    public boolean toggleRenderOctree() {
        this.renderOctree = !this.renderOctree;
        return this.renderOctree;
    }

    public void render(PoseStack p_113458_, Frustum p_366571_, MultiBufferSource.BufferSource p_113459_, double p_113460_, double p_113461_, double p_113462_) {
        if (this.renderChunkborder && !Minecraft.getInstance().showOnlyReducedInfo()) {
            this.chunkBorderRenderer.render(p_113458_, p_113459_, p_113460_, p_113461_, p_113462_);
        }
        if (this.renderOctree) {
            this.octreeDebugRenderer.render(p_113458_, p_366571_, p_113459_, p_113460_, p_113461_, p_113462_);
        }
        this.gameTestDebugRenderer.render(p_113458_, p_113459_, p_113460_, p_113461_, p_113462_);
    }

    public void renderAfterTranslucents(PoseStack p_361527_, MultiBufferSource.BufferSource p_364189_, double p_363297_, double p_362785_, double p_363711_) {
        this.chunkCullingDebugRenderer.render(p_361527_, p_364189_, p_363297_, p_362785_, p_363711_);
    }

    public static Optional<Entity> getTargetedEntity(@Nullable Entity p_113449_, int p_113450_) {
        int $$6;
        AABB $$5;
        Vec3 $$3;
        Vec3 $$4;
        if (p_113449_ == null) {
            return Optional.empty();
        }
        Vec3 $$2 = p_113449_.getEyePosition();
        EntityHitResult $$7 = ProjectileUtil.getEntityHitResult(p_113449_, $$2, $$4 = $$2.add($$3 = p_113449_.getViewVector(1.0f).scale(p_113450_)), $$5 = p_113449_.getBoundingBox().expandTowards($$3).inflate(1.0), EntitySelector.CAN_BE_PICKED, $$6 = p_113450_ * p_113450_);
        if ($$7 == null) {
            return Optional.empty();
        }
        if ($$2.distanceToSqr($$7.getLocation()) > (double)$$6) {
            return Optional.empty();
        }
        return Optional.of($$7.getEntity());
    }

    public static void renderFilledUnitCube(PoseStack p_308923_, MultiBufferSource p_309126_, BlockPos p_309015_, float p_308976_, float p_308978_, float p_309148_, float p_309159_) {
        DebugRenderer.renderFilledBox(p_308923_, p_309126_, p_309015_, p_309015_.offset(1, 1, 1), p_308976_, p_308978_, p_309148_, p_309159_);
    }

    public static void renderFilledBox(PoseStack p_270169_, MultiBufferSource p_270417_, BlockPos p_270790_, BlockPos p_270610_, float p_270515_, float p_270494_, float p_270869_, float p_270844_) {
        Camera $$8 = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (!$$8.isInitialized()) {
            return;
        }
        Vec3 $$9 = $$8.getPosition().reverse();
        AABB $$10 = AABB.encapsulatingFullBlocks(p_270790_, p_270610_).move($$9);
        DebugRenderer.renderFilledBox(p_270169_, p_270417_, $$10, p_270515_, p_270494_, p_270869_, p_270844_);
    }

    public static void renderFilledBox(PoseStack p_270877_, MultiBufferSource p_270925_, BlockPos p_270480_, float p_270569_, float p_270315_, float p_270182_, float p_270862_, float p_270973_) {
        Camera $$8 = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (!$$8.isInitialized()) {
            return;
        }
        Vec3 $$9 = $$8.getPosition().reverse();
        AABB $$10 = new AABB(p_270480_).move($$9).inflate(p_270569_);
        DebugRenderer.renderFilledBox(p_270877_, p_270925_, $$10, p_270315_, p_270182_, p_270862_, p_270973_);
    }

    public static void renderFilledBox(PoseStack p_271017_, MultiBufferSource p_270356_, AABB p_270833_, float p_270850_, float p_270249_, float p_270654_, float p_270476_) {
        DebugRenderer.renderFilledBox(p_271017_, p_270356_, p_270833_.minX, p_270833_.minY, p_270833_.minZ, p_270833_.maxX, p_270833_.maxY, p_270833_.maxZ, p_270850_, p_270249_, p_270654_, p_270476_);
    }

    public static void renderFilledBox(PoseStack p_270616_, MultiBufferSource p_270769_, double p_270653_, double p_270967_, double p_270556_, double p_270724_, double p_270427_, double p_270138_, float p_270391_, float p_270093_, float p_270312_, float p_270567_) {
        VertexConsumer $$12 = p_270769_.getBuffer(RenderType.debugFilledBox());
        ShapeRenderer.addChainedFilledBoxVertices(p_270616_, $$12, p_270653_, p_270967_, p_270556_, p_270724_, p_270427_, p_270138_, p_270391_, p_270093_, p_270312_, p_270567_);
    }

    public static void renderFloatingText(PoseStack p_270671_, MultiBufferSource p_271023_, String p_270521_, int p_270729_, int p_270562_, int p_270828_, int p_270164_) {
        DebugRenderer.renderFloatingText(p_270671_, p_271023_, p_270521_, (double)p_270729_ + 0.5, (double)p_270562_ + 0.5, (double)p_270828_ + 0.5, p_270164_);
    }

    public static void renderFloatingText(PoseStack p_270905_, MultiBufferSource p_270581_, String p_270305_, double p_270645_, double p_270746_, double p_270364_, int p_270977_) {
        DebugRenderer.renderFloatingText(p_270905_, p_270581_, p_270305_, p_270645_, p_270746_, p_270364_, p_270977_, 0.02f);
    }

    public static void renderFloatingText(PoseStack p_270216_, MultiBufferSource p_270684_, String p_270564_, double p_270935_, double p_270856_, double p_270908_, int p_270180_, float p_270685_) {
        DebugRenderer.renderFloatingText(p_270216_, p_270684_, p_270564_, p_270935_, p_270856_, p_270908_, p_270180_, p_270685_, true, 0.0f, false);
    }

    public static void renderFloatingText(PoseStack p_270649_, MultiBufferSource p_270695_, String p_270703_, double p_270942_, double p_270292_, double p_270885_, int p_270956_, float p_270657_, boolean p_270731_, float p_270825_, boolean p_270222_) {
        Minecraft $$11 = Minecraft.getInstance();
        Camera $$12 = $$11.gameRenderer.getMainCamera();
        if (!$$12.isInitialized() || $$11.getEntityRenderDispatcher().options == null) {
            return;
        }
        Font $$13 = $$11.font;
        double $$14 = $$12.getPosition().x;
        double $$15 = $$12.getPosition().y;
        double $$16 = $$12.getPosition().z;
        p_270649_.pushPose();
        p_270649_.translate((float)(p_270942_ - $$14), (float)(p_270292_ - $$15) + 0.07f, (float)(p_270885_ - $$16));
        p_270649_.mulPose((Quaternionfc)$$12.rotation());
        p_270649_.scale(p_270657_, -p_270657_, p_270657_);
        float $$17 = p_270731_ ? (float)(-$$13.width(p_270703_)) / 2.0f : 0.0f;
        $$13.drawInBatch(p_270703_, $$17 -= p_270825_ / p_270657_, 0.0f, p_270956_, false, p_270649_.last().pose(), p_270695_, p_270222_ ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        p_270649_.popPose();
    }

    private static Vec3 mixColor(float p_362997_) {
        float $$1 = 5.99999f;
        int $$2 = (int)(Mth.clamp(p_362997_, 0.0f, 1.0f) * 5.99999f);
        float $$3 = p_362997_ * 5.99999f - (float)$$2;
        return switch ($$2) {
            case 0 -> new Vec3(1.0, $$3, 0.0);
            case 1 -> new Vec3(1.0f - $$3, 1.0, 0.0);
            case 2 -> new Vec3(0.0, 1.0, $$3);
            case 3 -> new Vec3(0.0, 1.0 - (double)$$3, 1.0);
            case 4 -> new Vec3($$3, 0.0, 1.0);
            case 5 -> new Vec3(1.0, 0.0, 1.0 - (double)$$3);
            default -> throw new IllegalStateException("Unexpected value: " + $$2);
        };
    }

    private static Vec3 shiftHue(float p_363162_, float p_360992_, float p_363824_, float p_363167_) {
        Vec3 $$4 = DebugRenderer.mixColor(p_363167_).scale(p_363162_);
        Vec3 $$5 = DebugRenderer.mixColor((p_363167_ + 0.33333334f) % 1.0f).scale(p_360992_);
        Vec3 $$6 = DebugRenderer.mixColor((p_363167_ + 0.6666667f) % 1.0f).scale(p_363824_);
        Vec3 $$7 = $$4.add($$5).add($$6);
        double $$8 = Math.max(Math.max(1.0, $$7.x), Math.max($$7.y, $$7.z));
        return new Vec3($$7.x / $$8, $$7.y / $$8, $$7.z / $$8);
    }

    public static void renderVoxelShape(PoseStack p_361654_, VertexConsumer p_362910_, VoxelShape p_360834_, double p_361501_, double p_364243_, double p_363862_, float p_365460_, float p_364173_, float p_365309_, float p_360313_, boolean p_362872_) {
        List<AABB> $$11 = p_360834_.toAabbs();
        if ($$11.isEmpty()) {
            return;
        }
        int $$12 = p_362872_ ? $$11.size() : $$11.size() * 8;
        ShapeRenderer.renderShape(p_361654_, p_362910_, Shapes.create($$11.get(0)), p_361501_, p_364243_, p_363862_, ARGB.colorFromFloat(p_360313_, p_365460_, p_364173_, p_365309_));
        for (int $$13 = 1; $$13 < $$11.size(); ++$$13) {
            AABB $$14 = $$11.get($$13);
            float $$15 = (float)$$13 / (float)$$12;
            Vec3 $$16 = DebugRenderer.shiftHue(p_365460_, p_364173_, p_365309_, $$15);
            ShapeRenderer.renderShape(p_361654_, p_362910_, Shapes.create($$14), p_361501_, p_364243_, p_363862_, ARGB.colorFromFloat(p_360313_, (float)$$16.x, (float)$$16.y, (float)$$16.z));
        }
    }

    public static interface SimpleDebugRenderer {
        public void render(PoseStack var1, MultiBufferSource var2, double var3, double var5, double var7);

        default public void clear() {
        }
    }
}

