/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionOcclusionGraph;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ChunkCullingDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    public static final Direction[] DIRECTIONS = Direction.values();
    private final Minecraft minecraft;

    public ChunkCullingDebugRenderer(Minecraft p_362015_) {
        this.minecraft = p_362015_;
    }

    @Override
    public void render(PoseStack p_362623_, MultiBufferSource p_361977_, double p_364318_, double p_361586_, double p_365009_) {
        Frustum $$26;
        LevelRenderer $$5 = this.minecraft.levelRenderer;
        if (this.minecraft.sectionPath || this.minecraft.sectionVisibility) {
            SectionOcclusionGraph $$6 = $$5.getSectionOcclusionGraph();
            for (SectionRenderDispatcher.RenderSection $$7 : $$5.getVisibleSections()) {
                SectionOcclusionGraph.Node $$8 = $$6.getNode($$7);
                if ($$8 == null) continue;
                BlockPos $$9 = $$7.getRenderOrigin();
                p_362623_.pushPose();
                p_362623_.translate((double)$$9.getX() - p_364318_, (double)$$9.getY() - p_361586_, (double)$$9.getZ() - p_365009_);
                Matrix4f $$10 = p_362623_.last().pose();
                if (this.minecraft.sectionPath) {
                    VertexConsumer $$11 = p_361977_.getBuffer(RenderType.lines());
                    int $$12 = $$8.step == 0 ? 0 : Mth.hsvToRgb((float)$$8.step / 50.0f, 0.9f, 0.9f);
                    int $$13 = $$12 >> 16 & 0xFF;
                    int $$14 = $$12 >> 8 & 0xFF;
                    int $$15 = $$12 & 0xFF;
                    for (int $$16 = 0; $$16 < DIRECTIONS.length; ++$$16) {
                        if (!$$8.hasSourceDirection($$16)) continue;
                        Direction $$17 = DIRECTIONS[$$16];
                        $$11.addVertex($$10, 8.0f, 8.0f, 8.0f).setColor($$13, $$14, $$15, 255).setNormal($$17.getStepX(), $$17.getStepY(), $$17.getStepZ());
                        $$11.addVertex($$10, (float)(8 - 16 * $$17.getStepX()), (float)(8 - 16 * $$17.getStepY()), (float)(8 - 16 * $$17.getStepZ())).setColor($$13, $$14, $$15, 255).setNormal($$17.getStepX(), $$17.getStepY(), $$17.getStepZ());
                    }
                }
                if (this.minecraft.sectionVisibility && $$7.getSectionMesh().hasRenderableLayers()) {
                    VertexConsumer $$18 = p_361977_.getBuffer(RenderType.lines());
                    int $$19 = 0;
                    for (Direction $$20 : DIRECTIONS) {
                        for (Direction $$21 : DIRECTIONS) {
                            boolean $$22 = $$7.getSectionMesh().facesCanSeeEachother($$20, $$21);
                            if ($$22) continue;
                            ++$$19;
                            $$18.addVertex($$10, (float)(8 + 8 * $$20.getStepX()), (float)(8 + 8 * $$20.getStepY()), (float)(8 + 8 * $$20.getStepZ())).setColor(255, 0, 0, 255).setNormal($$20.getStepX(), $$20.getStepY(), $$20.getStepZ());
                            $$18.addVertex($$10, (float)(8 + 8 * $$21.getStepX()), (float)(8 + 8 * $$21.getStepY()), (float)(8 + 8 * $$21.getStepZ())).setColor(255, 0, 0, 255).setNormal($$21.getStepX(), $$21.getStepY(), $$21.getStepZ());
                        }
                    }
                    if ($$19 > 0) {
                        VertexConsumer $$23 = p_361977_.getBuffer(RenderType.debugQuads());
                        float $$24 = 0.5f;
                        float $$25 = 0.2f;
                        $$23.addVertex($$10, 0.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 15.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$23.addVertex($$10, 0.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                    }
                }
                p_362623_.popPose();
            }
        }
        if (($$26 = $$5.getCapturedFrustum()) != null) {
            p_362623_.pushPose();
            p_362623_.translate((float)($$26.getCamX() - p_364318_), (float)($$26.getCamY() - p_361586_), (float)($$26.getCamZ() - p_365009_));
            Matrix4f $$27 = p_362623_.last().pose();
            Vector4f[] $$28 = $$26.getFrustumPoints();
            VertexConsumer $$29 = p_361977_.getBuffer(RenderType.debugQuads());
            this.addFrustumQuad($$29, $$27, $$28, 0, 1, 2, 3, 0, 1, 1);
            this.addFrustumQuad($$29, $$27, $$28, 4, 5, 6, 7, 1, 0, 0);
            this.addFrustumQuad($$29, $$27, $$28, 0, 1, 5, 4, 1, 1, 0);
            this.addFrustumQuad($$29, $$27, $$28, 2, 3, 7, 6, 0, 0, 1);
            this.addFrustumQuad($$29, $$27, $$28, 0, 4, 7, 3, 0, 1, 0);
            this.addFrustumQuad($$29, $$27, $$28, 1, 5, 6, 2, 1, 0, 1);
            VertexConsumer $$30 = p_361977_.getBuffer(RenderType.lines());
            this.addFrustumVertex($$30, $$27, $$28[0]);
            this.addFrustumVertex($$30, $$27, $$28[1]);
            this.addFrustumVertex($$30, $$27, $$28[1]);
            this.addFrustumVertex($$30, $$27, $$28[2]);
            this.addFrustumVertex($$30, $$27, $$28[2]);
            this.addFrustumVertex($$30, $$27, $$28[3]);
            this.addFrustumVertex($$30, $$27, $$28[3]);
            this.addFrustumVertex($$30, $$27, $$28[0]);
            this.addFrustumVertex($$30, $$27, $$28[4]);
            this.addFrustumVertex($$30, $$27, $$28[5]);
            this.addFrustumVertex($$30, $$27, $$28[5]);
            this.addFrustumVertex($$30, $$27, $$28[6]);
            this.addFrustumVertex($$30, $$27, $$28[6]);
            this.addFrustumVertex($$30, $$27, $$28[7]);
            this.addFrustumVertex($$30, $$27, $$28[7]);
            this.addFrustumVertex($$30, $$27, $$28[4]);
            this.addFrustumVertex($$30, $$27, $$28[0]);
            this.addFrustumVertex($$30, $$27, $$28[4]);
            this.addFrustumVertex($$30, $$27, $$28[1]);
            this.addFrustumVertex($$30, $$27, $$28[5]);
            this.addFrustumVertex($$30, $$27, $$28[2]);
            this.addFrustumVertex($$30, $$27, $$28[6]);
            this.addFrustumVertex($$30, $$27, $$28[3]);
            this.addFrustumVertex($$30, $$27, $$28[7]);
            p_362623_.popPose();
        }
    }

    private void addFrustumVertex(VertexConsumer p_360922_, Matrix4f p_363048_, Vector4f p_362450_) {
        p_360922_.addVertex(p_363048_, p_362450_.x(), p_362450_.y(), p_362450_.z()).setColor(-16777216).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void addFrustumQuad(VertexConsumer p_360778_, Matrix4f p_364409_, Vector4f[] p_360544_, int p_363131_, int p_364933_, int p_363857_, int p_360531_, int p_365365_, int p_360692_, int p_363466_) {
        float $$10 = 0.25f;
        p_360778_.addVertex(p_364409_, p_360544_[p_363131_].x(), p_360544_[p_363131_].y(), p_360544_[p_363131_].z()).setColor((float)p_365365_, (float)p_360692_, (float)p_363466_, 0.25f);
        p_360778_.addVertex(p_364409_, p_360544_[p_364933_].x(), p_360544_[p_364933_].y(), p_360544_[p_364933_].z()).setColor((float)p_365365_, (float)p_360692_, (float)p_363466_, 0.25f);
        p_360778_.addVertex(p_364409_, p_360544_[p_363857_].x(), p_360544_[p_363857_].y(), p_360544_[p_363857_].z()).setColor((float)p_365365_, (float)p_360692_, (float)p_363466_, 0.25f);
        p_360778_.addVertex(p_364409_, p_360544_[p_360531_].x(), p_360544_[p_360531_].y(), p_360544_[p_360531_].z()).setColor((float)p_365365_, (float)p_360692_, (float)p_363466_, 0.25f);
    }
}

