/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;

public enum ChunkSectionLayer {
    SOLID(RenderPipelines.SOLID, 0x400000, true, false),
    CUTOUT_MIPPED(RenderPipelines.CUTOUT_MIPPED, 0x400000, true, false),
    CUTOUT(RenderPipelines.CUTOUT, 786432, false, false),
    TRANSLUCENT(RenderPipelines.TRANSLUCENT, 786432, true, true),
    TRIPWIRE(RenderPipelines.TRIPWIRE, 1536, true, true);

    private final RenderPipeline pipeline;
    private final int bufferSize;
    private final boolean useMipmaps;
    private final boolean sortOnUpload;
    private final String label;

    private ChunkSectionLayer(RenderPipeline p_427401_, int p_427231_, boolean p_427353_, boolean p_427370_) {
        this.pipeline = p_427401_;
        this.bufferSize = p_427231_;
        this.useMipmaps = p_427353_;
        this.sortOnUpload = p_427370_;
        this.label = this.toString().toLowerCase(Locale.ROOT);
    }

    public RenderPipeline pipeline() {
        return this.pipeline;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String label() {
        return this.label;
    }

    public boolean sortOnUpload() {
        return this.sortOnUpload;
    }

    public GpuTextureView textureView() {
        TextureManager $$0 = Minecraft.getInstance().getTextureManager();
        AbstractTexture $$1 = $$0.getTexture(TextureAtlas.LOCATION_BLOCKS);
        $$1.setUseMipmaps(this.useMipmaps);
        return $$1.getTextureView();
    }

    public RenderTarget outputTarget() {
        Minecraft $$0 = Minecraft.getInstance();
        switch (this.ordinal()) {
            case 4: {
                RenderTarget $$1 = $$0.levelRenderer.getWeatherTarget();
                return $$1 != null ? $$1 : $$0.getMainRenderTarget();
            }
            case 3: {
                RenderTarget $$2 = $$0.levelRenderer.getTranslucentTarget();
                return $$2 != null ? $$2 : $$0.getMainRenderTarget();
            }
        }
        return $$0.getMainRenderTarget();
    }
}

