/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PiglinHeadModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.dragon.DragonHeadModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;

public class SkullBlockRenderer
implements BlockEntityRenderer<SkullBlockEntity> {
    private final Function<SkullBlock.Type, SkullModelBase> modelByType;
    private static final Map<SkullBlock.Type, ResourceLocation> SKIN_BY_TYPE = Util.make(Maps.newHashMap(), p_349877_ -> {
        p_349877_.put(SkullBlock.Types.SKELETON, ResourceLocation.withDefaultNamespace("textures/entity/skeleton/skeleton.png"));
        p_349877_.put(SkullBlock.Types.WITHER_SKELETON, ResourceLocation.withDefaultNamespace("textures/entity/skeleton/wither_skeleton.png"));
        p_349877_.put(SkullBlock.Types.ZOMBIE, ResourceLocation.withDefaultNamespace("textures/entity/zombie/zombie.png"));
        p_349877_.put(SkullBlock.Types.CREEPER, ResourceLocation.withDefaultNamespace("textures/entity/creeper/creeper.png"));
        p_349877_.put(SkullBlock.Types.DRAGON, ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon.png"));
        p_349877_.put(SkullBlock.Types.PIGLIN, ResourceLocation.withDefaultNamespace("textures/entity/piglin/piglin.png"));
        p_349877_.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.getDefaultTexture());
    });

    @Nullable
    public static SkullModelBase createModel(EntityModelSet p_387840_, SkullBlock.Type p_388801_) {
        if (p_388801_ instanceof SkullBlock.Types) {
            SkullBlock.Types $$2 = (SkullBlock.Types)p_388801_;
            return switch ($$2) {
                default -> throw new MatchException(null, null);
                case SkullBlock.Types.SKELETON -> new SkullModel(p_387840_.bakeLayer(ModelLayers.SKELETON_SKULL));
                case SkullBlock.Types.WITHER_SKELETON -> new SkullModel(p_387840_.bakeLayer(ModelLayers.WITHER_SKELETON_SKULL));
                case SkullBlock.Types.PLAYER -> new SkullModel(p_387840_.bakeLayer(ModelLayers.PLAYER_HEAD));
                case SkullBlock.Types.ZOMBIE -> new SkullModel(p_387840_.bakeLayer(ModelLayers.ZOMBIE_HEAD));
                case SkullBlock.Types.CREEPER -> new SkullModel(p_387840_.bakeLayer(ModelLayers.CREEPER_HEAD));
                case SkullBlock.Types.DRAGON -> new DragonHeadModel(p_387840_.bakeLayer(ModelLayers.DRAGON_SKULL));
                case SkullBlock.Types.PIGLIN -> new PiglinHeadModel(p_387840_.bakeLayer(ModelLayers.PIGLIN_HEAD));
            };
        }
        return null;
    }

    public SkullBlockRenderer(BlockEntityRendererProvider.Context p_173660_) {
        EntityModelSet $$1 = p_173660_.getModelSet();
        this.modelByType = Util.memoize(p_386232_ -> SkullBlockRenderer.createModel($$1, p_386232_));
    }

    @Override
    public void render(SkullBlockEntity p_112534_, float p_112535_, PoseStack p_112536_, MultiBufferSource p_112537_, int p_112538_, int p_112539_, Vec3 p_401159_) {
        float $$7 = p_112534_.getAnimation(p_112535_);
        BlockState $$8 = p_112534_.getBlockState();
        boolean $$9 = $$8.getBlock() instanceof WallSkullBlock;
        Direction $$10 = $$9 ? $$8.getValue(WallSkullBlock.FACING) : null;
        int $$11 = $$9 ? RotationSegment.convertToSegment($$10.getOpposite()) : $$8.getValue(SkullBlock.ROTATION);
        float $$12 = RotationSegment.convertToDegrees($$11);
        SkullBlock.Type $$13 = ((AbstractSkullBlock)$$8.getBlock()).getType();
        SkullModelBase $$14 = this.modelByType.apply($$13);
        RenderType $$15 = SkullBlockRenderer.getRenderType($$13, p_112534_.getOwnerProfile());
        SkullBlockRenderer.renderSkull($$10, $$12, $$7, p_112536_, p_112537_, p_112538_, $$14, $$15);
    }

    public static void renderSkull(@Nullable Direction p_173664_, float p_173665_, float p_173666_, PoseStack p_173667_, MultiBufferSource p_173668_, int p_173669_, SkullModelBase p_173670_, RenderType p_173671_) {
        p_173667_.pushPose();
        if (p_173664_ == null) {
            p_173667_.translate(0.5f, 0.0f, 0.5f);
        } else {
            float $$8 = 0.25f;
            p_173667_.translate(0.5f - (float)p_173664_.getStepX() * 0.25f, 0.25f, 0.5f - (float)p_173664_.getStepZ() * 0.25f);
        }
        p_173667_.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer $$9 = p_173668_.getBuffer(p_173671_);
        p_173670_.setupAnim(p_173666_, p_173665_, 0.0f);
        p_173670_.renderToBuffer(p_173667_, $$9, p_173669_, OverlayTexture.NO_OVERLAY);
        p_173667_.popPose();
    }

    public static RenderType getRenderType(SkullBlock.Type p_112524_, @Nullable ResolvableProfile p_332722_) {
        if (p_112524_ != SkullBlock.Types.PLAYER || p_332722_ == null) {
            return SkullBlockRenderer.getSkullRenderType(p_112524_, null);
        }
        return SkullBlockRenderer.getPlayerSkinRenderType(Minecraft.getInstance().getSkinManager().getInsecureSkin(p_332722_.gameProfile()).texture());
    }

    public static RenderType getSkullRenderType(SkullBlock.Type p_428198_, @Nullable ResourceLocation p_428351_) {
        return RenderType.entityCutoutNoCullZOffset(p_428351_ != null ? p_428351_ : SKIN_BY_TYPE.get(p_428198_));
    }

    public static RenderType getPlayerSkinRenderType(ResourceLocation p_428466_) {
        return RenderType.entityTranslucent(p_428466_);
    }
}

