/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.phys.Vec3;

public class PistonHeadRenderer
implements BlockEntityRenderer<PistonMovingBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public PistonHeadRenderer(BlockEntityRendererProvider.Context p_173623_) {
        this.blockRenderer = p_173623_.getBlockRenderDispatcher();
    }

    @Override
    public void render(PistonMovingBlockEntity p_112452_, float p_112453_, PoseStack p_112454_, MultiBufferSource p_112455_, int p_112456_, int p_112457_, Vec3 p_401129_) {
        Level $$7 = p_112452_.getLevel();
        if ($$7 == null) {
            return;
        }
        BlockPos $$8 = p_112452_.getBlockPos().relative(p_112452_.getMovementDirection().getOpposite());
        BlockState $$9 = p_112452_.getMovedState();
        if ($$9.isAir()) {
            return;
        }
        ModelBlockRenderer.enableCaching();
        p_112454_.pushPose();
        p_112454_.translate(p_112452_.getXOff(p_112453_), p_112452_.getYOff(p_112453_), p_112452_.getZOff(p_112453_));
        if ($$9.is(Blocks.PISTON_HEAD) && p_112452_.getProgress(p_112453_) <= 4.0f) {
            $$9 = (BlockState)$$9.setValue(PistonHeadBlock.SHORT, p_112452_.getProgress(p_112453_) <= 0.5f);
            this.renderBlock($$8, $$9, p_112454_, p_112455_, $$7, false, p_112457_);
        } else if (p_112452_.isSourcePiston() && !p_112452_.isExtending()) {
            PistonType $$10 = $$9.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState $$11 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.TYPE, $$10)).setValue(PistonHeadBlock.FACING, (Direction)$$9.getValue(PistonBaseBlock.FACING));
            $$11 = (BlockState)$$11.setValue(PistonHeadBlock.SHORT, p_112452_.getProgress(p_112453_) >= 0.5f);
            this.renderBlock($$8, $$11, p_112454_, p_112455_, $$7, false, p_112457_);
            BlockPos $$12 = $$8.relative(p_112452_.getMovementDirection());
            p_112454_.popPose();
            p_112454_.pushPose();
            $$9 = (BlockState)$$9.setValue(PistonBaseBlock.EXTENDED, true);
            this.renderBlock($$12, $$9, p_112454_, p_112455_, $$7, true, p_112457_);
        } else {
            this.renderBlock($$8, $$9, p_112454_, p_112455_, $$7, false, p_112457_);
        }
        p_112454_.popPose();
        ModelBlockRenderer.clearCache();
    }

    private void renderBlock(BlockPos p_112459_, BlockState p_112460_, PoseStack p_112461_, MultiBufferSource p_112462_, Level p_112463_, boolean p_112464_, int p_112465_) {
        RenderType $$7 = ItemBlockRenderTypes.getMovingBlockRenderType(p_112460_);
        VertexConsumer $$8 = p_112462_.getBuffer($$7);
        List<BlockModelPart> $$9 = this.blockRenderer.getBlockModel(p_112460_).collectParts(RandomSource.create(p_112460_.getSeed(p_112459_)));
        this.blockRenderer.getModelRenderer().tesselateBlock(p_112463_, $$9, p_112460_, p_112459_, p_112461_, $$8, p_112464_, p_112465_);
    }

    @Override
    public int getViewDistance() {
        return 68;
    }
}

