/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class EnchantTableRenderer
implements BlockEntityRenderer<EnchantingTableBlockEntity> {
    public static final Material BOOK_LOCATION = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/enchanting_table_book"));
    private final BookModel bookModel;

    public EnchantTableRenderer(BlockEntityRendererProvider.Context p_173619_) {
        this.bookModel = new BookModel(p_173619_.bakeLayer(ModelLayers.BOOK));
    }

    @Override
    public void render(EnchantingTableBlockEntity p_341203_, float p_112419_, PoseStack p_112420_, MultiBufferSource p_112421_, int p_112422_, int p_112423_, Vec3 p_401253_) {
        float $$8;
        p_112420_.pushPose();
        p_112420_.translate(0.5f, 0.75f, 0.5f);
        float $$7 = (float)p_341203_.time + p_112419_;
        p_112420_.translate(0.0f, 0.1f + Mth.sin($$7 * 0.1f) * 0.01f, 0.0f);
        for ($$8 = p_341203_.rot - p_341203_.oRot; $$8 >= (float)Math.PI; $$8 -= (float)Math.PI * 2) {
        }
        while ($$8 < (float)(-Math.PI)) {
            $$8 += (float)Math.PI * 2;
        }
        float $$9 = p_341203_.oRot + $$8 * p_112419_;
        p_112420_.mulPose((Quaternionfc)Axis.YP.rotation(-$$9));
        p_112420_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(80.0f));
        float $$10 = Mth.lerp(p_112419_, p_341203_.oFlip, p_341203_.flip);
        float $$11 = Mth.frac($$10 + 0.25f) * 1.6f - 0.3f;
        float $$12 = Mth.frac($$10 + 0.75f) * 1.6f - 0.3f;
        float $$13 = Mth.lerp(p_112419_, p_341203_.oOpen, p_341203_.open);
        this.bookModel.setupAnim($$7, Mth.clamp($$11, 0.0f, 1.0f), Mth.clamp($$12, 0.0f, 1.0f), $$13);
        VertexConsumer $$14 = BOOK_LOCATION.buffer(p_112421_, RenderType::entitySolid);
        this.bookModel.renderToBuffer(p_112420_, $$14, p_112422_, p_112423_);
        p_112420_.popPose();
    }
}

