/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ChestModel singleModel;
    private final ChestModel doubleLeftModel;
    private final ChestModel doubleRightModel;
    private final boolean xmasTextures = ChestRenderer.xmasTextures();

    public ChestRenderer(BlockEntityRendererProvider.Context p_173607_) {
        this.singleModel = new ChestModel(p_173607_.bakeLayer(ModelLayers.CHEST));
        this.doubleLeftModel = new ChestModel(p_173607_.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT));
        this.doubleRightModel = new ChestModel(p_173607_.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT));
    }

    public static boolean xmasTextures() {
        Calendar $$0 = Calendar.getInstance();
        return $$0.get(2) + 1 == 12 && $$0.get(5) >= 24 && $$0.get(5) <= 26;
    }

    @Override
    public void render(T p_112363_, float p_112364_, PoseStack p_112365_, MultiBufferSource p_112366_, int p_112367_, int p_112368_, Vec3 p_401038_) {
        DoubleBlockCombiner.NeighborCombineResult<ChestBlockEntity> $$16;
        Level $$7 = ((BlockEntity)p_112363_).getLevel();
        boolean $$8 = $$7 != null;
        BlockState $$9 = $$8 ? ((BlockEntity)p_112363_).getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue(ChestBlock.FACING, Direction.SOUTH);
        ChestType $$10 = $$9.hasProperty(ChestBlock.TYPE) ? $$9.getValue(ChestBlock.TYPE) : ChestType.SINGLE;
        Block $$11 = $$9.getBlock();
        if (!($$11 instanceof AbstractChestBlock)) {
            return;
        }
        AbstractChestBlock $$12 = (AbstractChestBlock)$$11;
        boolean $$13 = $$10 != ChestType.SINGLE;
        p_112365_.pushPose();
        float $$14 = $$9.getValue(ChestBlock.FACING).toYRot();
        p_112365_.translate(0.5f, 0.5f, 0.5f);
        p_112365_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-$$14));
        p_112365_.translate(-0.5f, -0.5f, -0.5f);
        if ($$8) {
            DoubleBlockCombiner.NeighborCombineResult<ChestBlockEntity> $$15 = $$12.combine($$9, $$7, ((BlockEntity)p_112363_).getBlockPos(), true);
        } else {
            $$16 = DoubleBlockCombiner.Combiner::acceptNone;
        }
        float $$17 = $$16.apply(ChestBlock.opennessCombiner((LidBlockEntity)p_112363_)).get(p_112364_);
        $$17 = 1.0f - $$17;
        $$17 = 1.0f - $$17 * $$17 * $$17;
        int $$18 = ((Int2IntFunction)$$16.apply(new BrightnessCombiner())).applyAsInt(p_112367_);
        Material $$19 = Sheets.chooseMaterial(p_112363_, $$10, this.xmasTextures);
        VertexConsumer $$20 = $$19.buffer(p_112366_, RenderType::entityCutout);
        if ($$13) {
            if ($$10 == ChestType.LEFT) {
                this.render(p_112365_, $$20, this.doubleLeftModel, $$17, $$18, p_112368_);
            } else {
                this.render(p_112365_, $$20, this.doubleRightModel, $$17, $$18, p_112368_);
            }
        } else {
            this.render(p_112365_, $$20, this.singleModel, $$17, $$18, p_112368_);
        }
        p_112365_.popPose();
    }

    private void render(PoseStack p_112370_, VertexConsumer p_112371_, ChestModel p_364178_, float p_112375_, int p_112376_, int p_112377_) {
        p_364178_.setupAnim(p_112375_);
        p_364178_.renderToBuffer(p_112370_, p_112371_, p_112376_, p_112377_);
    }
}

