/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BedRenderer
implements BlockEntityRenderer<BedBlockEntity> {
    private final Model headModel;
    private final Model footModel;

    public BedRenderer(BlockEntityRendererProvider.Context p_173540_) {
        this(p_173540_.getModelSet());
    }

    public BedRenderer(EntityModelSet p_387957_) {
        this.headModel = new Model.Simple(p_387957_.bakeLayer(ModelLayers.BED_HEAD), RenderType::entitySolid);
        this.footModel = new Model.Simple(p_387957_.bakeLayer(ModelLayers.BED_FOOT), RenderType::entitySolid);
    }

    public static LayerDefinition createHeadLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.ZERO);
        $$1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 6).addBox(0.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, 1.5707964f));
        $$1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 18).addBox(-16.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, (float)Math.PI));
        return LayerDefinition.create($$0, 64, 64);
    }

    public static LayerDefinition createFootLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.ZERO);
        $$1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 0).addBox(0.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, 0.0f));
        $$1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 12).addBox(-16.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, 4.712389f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void render(BedBlockEntity p_112205_, float p_112206_, PoseStack p_112207_, MultiBufferSource p_112208_, int p_112209_, int p_112210_, Vec3 p_401344_) {
        Level $$7 = p_112205_.getLevel();
        if ($$7 != null) {
            Material $$8 = Sheets.getBedMaterial(p_112205_.getColor());
            BlockState $$9 = p_112205_.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult<BedBlockEntity> $$10 = DoubleBlockCombiner.combineWithNeigbour(BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, ChestBlock.FACING, $$9, $$7, p_112205_.getBlockPos(), (p_112202_, p_112203_) -> false);
            int $$11 = ((Int2IntFunction)$$10.apply(new BrightnessCombiner())).get(p_112209_);
            this.renderPiece(p_112207_, p_112208_, $$9.getValue(BedBlock.PART) == BedPart.HEAD ? this.headModel : this.footModel, (Direction)$$9.getValue(BedBlock.FACING), $$8, $$11, p_112210_, false);
        }
    }

    public void renderInHand(PoseStack p_388130_, MultiBufferSource p_388011_, int p_386978_, int p_388446_, Material p_388516_) {
        this.renderPiece(p_388130_, p_388011_, this.headModel, Direction.SOUTH, p_388516_, p_386978_, p_388446_, false);
        this.renderPiece(p_388130_, p_388011_, this.footModel, Direction.SOUTH, p_388516_, p_386978_, p_388446_, true);
    }

    private void renderPiece(PoseStack p_173542_, MultiBufferSource p_173543_, Model p_363684_, Direction p_173545_, Material p_173546_, int p_173547_, int p_173548_, boolean p_173549_) {
        p_173542_.pushPose();
        BedRenderer.preparePose(p_173542_, p_173549_, p_173545_);
        VertexConsumer $$8 = p_173546_.buffer(p_173543_, RenderType::entitySolid);
        p_363684_.renderToBuffer(p_173542_, $$8, p_173547_, p_173548_);
        p_173542_.popPose();
    }

    private static void preparePose(PoseStack p_428361_, boolean p_428252_, Direction p_428231_) {
        p_428361_.translate(0.0f, 0.5625f, p_428252_ ? -1.0f : 0.0f);
        p_428361_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        p_428361_.translate(0.5f, 0.5f, 0.5f);
        p_428361_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f + p_428231_.toYRot()));
        p_428361_.translate(-0.5f, -0.5f, -0.5f);
    }

    public void getExtents(Set<Vector3f> p_428359_) {
        PoseStack $$1 = new PoseStack();
        BedRenderer.preparePose($$1, false, Direction.SOUTH);
        this.headModel.root().getExtentsForGui($$1, p_428359_);
        $$1.setIdentity();
        BedRenderer.preparePose($$1, true, Direction.SOUTH);
        this.footModel.root().getExtentsForGui($$1, p_428359_);
    }
}

