/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public record KeyValueCondition(Map<String, Terms> tests) implements Condition
{
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<KeyValueCondition> CODEC = ExtraCodecs.nonEmptyMap(Codec.unboundedMap((Codec)Codec.STRING, Terms.CODEC)).xmap(KeyValueCondition::new, KeyValueCondition::tests);

    @Override
    public <O, S extends StateHolder<O, S>> Predicate<S> instantiate(StateDefinition<O, S> p_405000_) {
        ArrayList $$1 = new ArrayList(this.tests.size());
        this.tests.forEach((p_404083_, p_404084_) -> $$1.add(KeyValueCondition.instantiate(p_405000_, p_404083_, p_404084_)));
        return Util.allOf($$1);
    }

    private static <O, S extends StateHolder<O, S>> Predicate<S> instantiate(StateDefinition<O, S> p_405206_, String p_405083_, Terms p_405754_) {
        Property<?> $$3 = p_405206_.getProperty(p_405083_);
        if ($$3 == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown property '%s' on '%s'", p_405083_, p_405206_.getOwner()));
        }
        return p_405754_.instantiate(p_405206_.getOwner(), $$3);
    }

    public record Terms(List<Term> entries) {
        private static final char SEPARATOR = '|';
        private static final Joiner JOINER = Joiner.on((char)'|');
        private static final Splitter SPLITTER = Splitter.on((char)'|');
        private static final Codec<String> LEGACY_REPRESENTATION_CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.BOOL).flatComapMap(p_405478_ -> (String)p_405478_.map(String::valueOf, String::valueOf), p_405596_ -> DataResult.error(() -> "This codec can't be used for encoding"));
        public static final Codec<Terms> CODEC = Codec.withAlternative((Codec)Codec.STRING, LEGACY_REPRESENTATION_CODEC).comapFlatMap(Terms::parse, Terms::toString);

        public Terms {
            if (entries.isEmpty()) {
                throw new IllegalArgumentException("Empty value for property");
            }
        }

        public static DataResult<Terms> parse(String p_405101_) {
            List<Term> $$1 = SPLITTER.splitToStream((CharSequence)p_405101_).map(Term::parse).toList();
            if ($$1.isEmpty()) {
                return DataResult.error(() -> "Empty value for property");
            }
            for (Term $$2 : $$1) {
                if (!$$2.value.isEmpty()) continue;
                return DataResult.error(() -> "Empty term in value '" + p_405101_ + "'");
            }
            return DataResult.success((Object)new Terms($$1));
        }

        @Override
        public String toString() {
            return JOINER.join(this.entries);
        }

        public <O, S extends StateHolder<O, S>, T extends Comparable<T>> Predicate<S> instantiate(O p_404984_, Property<T> p_405617_) {
            ArrayList $$11;
            boolean $$9;
            Predicate $$2 = Util.anyOf(Lists.transform(this.entries, p_405722_ -> this.instantiate(p_404984_, p_405617_, (Term)p_405722_)));
            ArrayList<T> $$3 = new ArrayList<T>(p_405617_.getPossibleValues());
            int $$4 = $$3.size();
            $$3.removeIf($$2.negate());
            int $$5 = $$3.size();
            if ($$5 == 0) {
                LOGGER.warn("Condition {} for property {} on {} is always false", new Object[]{this, p_405617_.getName(), p_404984_});
                return p_405630_ -> false;
            }
            int $$6 = $$4 - $$5;
            if ($$6 == 0) {
                LOGGER.warn("Condition {} for property {} on {} is always true", new Object[]{this, p_405617_.getName(), p_404984_});
                return p_404757_ -> true;
            }
            if ($$5 <= $$6) {
                boolean $$7 = false;
                ArrayList<T> $$8 = $$3;
            } else {
                $$9 = true;
                ArrayList $$10 = new ArrayList(p_405617_.getPossibleValues());
                $$10.removeIf($$2);
                $$11 = $$10;
            }
            if ($$11.size() == 1) {
                Comparable $$12 = (Comparable)$$11.getFirst();
                return p_404713_ -> {
                    Object $$4 = p_404713_.getValue(p_405617_);
                    return $$12.equals($$4) ^ $$9;
                };
            }
            return p_405532_ -> {
                Object $$4 = p_405532_.getValue(p_405617_);
                return $$11.contains($$4) ^ $$9;
            };
        }

        private <T extends Comparable<T>> T getValueOrThrow(Object p_405650_, Property<T> p_405129_, String p_405218_) {
            Optional<T> $$3 = p_405129_.getValue(p_405218_);
            if ($$3.isEmpty()) {
                throw new RuntimeException(String.format(Locale.ROOT, "Unknown value '%s' for property '%s' on '%s' in '%s'", p_405218_, p_405129_, p_405650_, this));
            }
            return (T)((Comparable)$$3.get());
        }

        private <T extends Comparable<T>> Predicate<T> instantiate(Object p_405656_, Property<T> p_405057_, Term p_405563_) {
            Object $$3 = this.getValueOrThrow(p_405656_, p_405057_, p_405563_.value);
            if (p_405563_.negated) {
                return p_405370_ -> !p_405370_.equals($$3);
            }
            return p_404808_ -> p_404808_.equals($$3);
        }
    }

    public record Term(String value, boolean negated) {
        private static final String NEGATE = "!";

        public Term {
            if (value.isEmpty()) {
                throw new IllegalArgumentException("Empty term");
            }
        }

        public static Term parse(String p_405246_) {
            if (p_405246_.startsWith(NEGATE)) {
                return new Term(p_405246_.substring(1), true);
            }
            return new Term(p_405246_, false);
        }

        @Override
        public String toString() {
            return this.negated ? NEGATE + this.value : this.value;
        }
    }
}

