/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class TextureSlots {
    public static final TextureSlots EMPTY = new TextureSlots(Map.of());
    private static final char REFERENCE_CHAR = '#';
    private final Map<String, Material> resolvedValues;

    TextureSlots(Map<String, Material> p_387448_) {
        this.resolvedValues = p_387448_;
    }

    @Nullable
    public Material getMaterial(String p_387889_) {
        if (TextureSlots.isTextureReference(p_387889_)) {
            p_387889_ = p_387889_.substring(1);
        }
        return this.resolvedValues.get(p_387889_);
    }

    private static boolean isTextureReference(String p_388918_) {
        return p_388918_.charAt(0) == '#';
    }

    public static Data parseTextureMap(JsonObject p_387105_, ResourceLocation p_387237_) {
        Data.Builder $$2 = new Data.Builder();
        for (Map.Entry $$3 : p_387105_.entrySet()) {
            TextureSlots.parseEntry(p_387237_, (String)$$3.getKey(), ((JsonElement)$$3.getValue()).getAsString(), $$2);
        }
        return $$2.build();
    }

    private static void parseEntry(ResourceLocation p_387514_, String p_388911_, String p_386463_, Data.Builder p_387858_) {
        if (TextureSlots.isTextureReference(p_386463_)) {
            p_387858_.addReference(p_388911_, p_386463_.substring(1));
        } else {
            ResourceLocation $$4 = ResourceLocation.tryParse(p_386463_);
            if ($$4 == null) {
                throw new JsonParseException(p_386463_ + " is not valid resource location");
            }
            p_387858_.addTexture(p_388911_, new Material(p_387514_, $$4));
        }
    }

    public record Data(Map<String, SlotContents> values) {
        public static final Data EMPTY = new Data(Map.of());

        public static class Builder {
            private final Map<String, SlotContents> textureMap = new HashMap<String, SlotContents>();

            public Builder addReference(String p_388062_, String p_388610_) {
                this.textureMap.put(p_388062_, new Reference(p_388610_));
                return this;
            }

            public Builder addTexture(String p_388884_, Material p_387399_) {
                this.textureMap.put(p_388884_, new Value(p_387399_));
                return this;
            }

            public Data build() {
                if (this.textureMap.isEmpty()) {
                    return EMPTY;
                }
                return new Data(Map.copyOf(this.textureMap));
            }
        }
    }

    public static class Resolver {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final List<Data> entries = new ArrayList<Data>();

        public Resolver addLast(Data p_387439_) {
            this.entries.addLast(p_387439_);
            return this;
        }

        public Resolver addFirst(Data p_388591_) {
            this.entries.addFirst(p_388591_);
            return this;
        }

        public TextureSlots resolve(ModelDebugName p_388348_) {
            if (this.entries.isEmpty()) {
                return EMPTY;
            }
            Object2ObjectArrayMap $$1 = new Object2ObjectArrayMap();
            Object2ObjectArrayMap $$2 = new Object2ObjectArrayMap();
            for (Data $$3 : Lists.reverse(this.entries)) {
                $$3.values.forEach((arg_0, arg_1) -> Resolver.lambda$resolve$0((Object2ObjectMap)$$2, (Object2ObjectMap)$$1, arg_0, arg_1));
            }
            if ($$2.isEmpty()) {
                return new TextureSlots((Map<String, Material>)$$1);
            }
            boolean $$4 = true;
            while ($$4) {
                $$4 = false;
                ObjectIterator $$5 = Object2ObjectMaps.fastIterator((Object2ObjectMap)$$2);
                while ($$5.hasNext()) {
                    Object2ObjectMap.Entry $$6 = (Object2ObjectMap.Entry)$$5.next();
                    Material $$7 = (Material)$$1.get((Object)((Reference)$$6.getValue()).target);
                    if ($$7 == null) continue;
                    $$1.put((Object)((String)$$6.getKey()), (Object)$$7);
                    $$5.remove();
                    $$4 = true;
                }
            }
            if (!$$2.isEmpty()) {
                LOGGER.warn("Unresolved texture references in {}:\n{}", (Object)p_388348_.debugName(), (Object)$$2.entrySet().stream().map(p_387981_ -> "\t#" + (String)p_387981_.getKey() + "-> #" + ((Reference)p_387981_.getValue()).target + "\n").collect(Collectors.joining()));
            }
            return new TextureSlots((Map<String, Material>)$$1);
        }

        private static /* synthetic */ void lambda$resolve$0(Object2ObjectMap p_389332_, Object2ObjectMap p_389333_, String p_389334_, SlotContents p_389335_) {
            SlotContents slotContents = p_389335_;
            Objects.requireNonNull(slotContents);
            SlotContents $$4 = slotContents;
            int $$5 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Value.class, Reference.class}, (Object)$$4, $$5)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Value $$6 = (Value)$$4;
                    p_389332_.remove((Object)p_389334_);
                    p_389333_.put((Object)p_389334_, (Object)$$6.material());
                    break;
                }
                case 1: {
                    Reference $$7 = (Reference)$$4;
                    p_389333_.remove((Object)p_389334_);
                    p_389332_.put((Object)p_389334_, (Object)$$7);
                }
            }
        }
    }

    record Reference(String target) implements SlotContents
    {
    }

    record Value(Material material) implements SlotContents
    {
    }

    public static sealed interface SlotContents
    permits Value, Reference {
    }
}

