/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.math.MatrixUtil;
import com.mojang.math.Quadrant;
import com.mojang.math.Transformation;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FaceBakery {
    public static final int VERTEX_INT_SIZE = 8;
    public static final int VERTEX_COUNT = 4;
    private static final int COLOR_INDEX = 3;
    public static final int UV_INDEX = 4;
    private static final Vector3fc NO_RESCALE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3fc BLOCK_MIDDLE = new Vector3f(0.5f, 0.5f, 0.5f);

    @VisibleForTesting
    static BlockElementFace.UVs defaultFaceUV(Vector3fc p_404839_, Vector3fc p_405755_, Direction p_404690_) {
        return switch (p_404690_) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new BlockElementFace.UVs(p_404839_.x(), 16.0f - p_405755_.z(), p_405755_.x(), 16.0f - p_404839_.z());
            case Direction.UP -> new BlockElementFace.UVs(p_404839_.x(), p_404839_.z(), p_405755_.x(), p_405755_.z());
            case Direction.NORTH -> new BlockElementFace.UVs(16.0f - p_405755_.x(), 16.0f - p_405755_.y(), 16.0f - p_404839_.x(), 16.0f - p_404839_.y());
            case Direction.SOUTH -> new BlockElementFace.UVs(p_404839_.x(), 16.0f - p_405755_.y(), p_405755_.x(), 16.0f - p_404839_.y());
            case Direction.WEST -> new BlockElementFace.UVs(p_404839_.z(), 16.0f - p_405755_.y(), p_405755_.z(), 16.0f - p_404839_.y());
            case Direction.EAST -> new BlockElementFace.UVs(16.0f - p_405755_.z(), 16.0f - p_405755_.y(), 16.0f - p_404839_.z(), 16.0f - p_404839_.y());
        };
    }

    public static BakedQuad bakeQuad(Vector3fc p_404957_, Vector3fc p_405340_, BlockElementFace p_111603_, TextureAtlasSprite p_111604_, Direction p_111605_, ModelState p_111606_, @Nullable BlockElementRotation p_111607_, boolean p_111608_, int p_364857_) {
        BlockElementFace.UVs $$9 = p_111603_.uvs();
        if ($$9 == null) {
            $$9 = FaceBakery.defaultFaceUV(p_404957_, p_405340_, p_111605_);
        }
        $$9 = FaceBakery.shrinkUVs(p_111604_, $$9);
        Matrix4fc $$10 = p_111606_.inverseFaceTransformation(p_111605_);
        int[] $$11 = FaceBakery.makeVertices($$9, p_111603_.rotation(), $$10, p_111604_, p_111605_, FaceBakery.setupShape(p_404957_, p_405340_), p_111606_.transformation(), p_111607_);
        Direction $$12 = FaceBakery.calculateFacing($$11);
        if (p_111607_ == null) {
            FaceBakery.recalculateWinding($$11, $$12);
        }
        return new BakedQuad($$11, p_111603_.tintIndex(), $$12, p_111604_, p_111608_, p_364857_);
    }

    private static BlockElementFace.UVs shrinkUVs(TextureAtlasSprite p_404992_, BlockElementFace.UVs p_405227_) {
        float $$2 = p_405227_.minU();
        float $$3 = p_405227_.minV();
        float $$4 = p_405227_.maxU();
        float $$5 = p_405227_.maxV();
        float $$6 = p_404992_.uvShrinkRatio();
        float $$7 = ($$2 + $$2 + $$4 + $$4) / 4.0f;
        float $$8 = ($$3 + $$3 + $$5 + $$5) / 4.0f;
        return new BlockElementFace.UVs(Mth.lerp($$6, $$2, $$7), Mth.lerp($$6, $$3, $$8), Mth.lerp($$6, $$4, $$7), Mth.lerp($$6, $$5, $$8));
    }

    private static int[] makeVertices(BlockElementFace.UVs p_405062_, Quadrant p_405779_, Matrix4fc p_404746_, TextureAtlasSprite p_111575_, Direction p_111576_, float[] p_111577_, Transformation p_111578_, @Nullable BlockElementRotation p_111579_) {
        FaceInfo $$8 = FaceInfo.fromFacing(p_111576_);
        int[] $$9 = new int[32];
        for (int $$10 = 0; $$10 < 4; ++$$10) {
            FaceBakery.bakeVertex($$9, $$10, $$8, p_405062_, p_405779_, p_404746_, p_111577_, p_111575_, p_111578_, p_111579_);
        }
        return $$9;
    }

    private static float[] setupShape(Vector3fc p_405761_, Vector3fc p_404891_) {
        float[] $$2 = new float[Direction.values().length];
        $$2[FaceInfo.Constants.MIN_X] = p_405761_.x() / 16.0f;
        $$2[FaceInfo.Constants.MIN_Y] = p_405761_.y() / 16.0f;
        $$2[FaceInfo.Constants.MIN_Z] = p_405761_.z() / 16.0f;
        $$2[FaceInfo.Constants.MAX_X] = p_404891_.x() / 16.0f;
        $$2[FaceInfo.Constants.MAX_Y] = p_404891_.y() / 16.0f;
        $$2[FaceInfo.Constants.MAX_Z] = p_404891_.z() / 16.0f;
        return $$2;
    }

    private static void bakeVertex(int[] p_111621_, int p_111622_, FaceInfo p_405531_, BlockElementFace.UVs p_405537_, Quadrant p_404831_, Matrix4fc p_405449_, float[] p_111625_, TextureAtlasSprite p_111626_, Transformation p_111627_, @Nullable BlockElementRotation p_111628_) {
        float $$18;
        float $$17;
        FaceInfo.VertexInfo $$10 = p_405531_.getVertexInfo(p_111622_);
        Vector3f $$11 = new Vector3f(p_111625_[$$10.xFace], p_111625_[$$10.yFace], p_111625_[$$10.zFace]);
        FaceBakery.applyElementRotation($$11, p_111628_);
        FaceBakery.applyModelRotation($$11, p_111627_);
        float $$12 = BlockElementFace.getU(p_405537_, p_404831_, p_111622_);
        float $$13 = BlockElementFace.getV(p_405537_, p_404831_, p_111622_);
        if (MatrixUtil.isIdentity(p_405449_)) {
            float $$14 = $$12;
            float $$15 = $$13;
        } else {
            Vector3f $$16 = p_405449_.transformPosition(new Vector3f(FaceBakery.cornerToCenter($$12), FaceBakery.cornerToCenter($$13), 0.0f));
            $$17 = FaceBakery.centerToCorner($$16.x);
            $$18 = FaceBakery.centerToCorner($$16.y);
        }
        FaceBakery.fillVertex(p_111621_, p_111622_, $$11, p_111626_, $$17, $$18);
    }

    private static float cornerToCenter(float p_405629_) {
        return p_405629_ - 0.5f;
    }

    private static float centerToCorner(float p_405087_) {
        return p_405087_ + 0.5f;
    }

    private static void fillVertex(int[] p_111615_, int p_111616_, Vector3f p_254291_, TextureAtlasSprite p_111618_, float p_405674_, float p_405591_) {
        int $$6 = p_111616_ * 8;
        p_111615_[$$6] = Float.floatToRawIntBits(p_254291_.x());
        p_111615_[$$6 + 1] = Float.floatToRawIntBits(p_254291_.y());
        p_111615_[$$6 + 2] = Float.floatToRawIntBits(p_254291_.z());
        p_111615_[$$6 + 3] = -1;
        p_111615_[$$6 + 4] = Float.floatToRawIntBits(p_111618_.getU(p_405674_));
        p_111615_[$$6 + 4 + 1] = Float.floatToRawIntBits(p_111618_.getV(p_405591_));
    }

    private static void applyElementRotation(Vector3f p_254412_, @Nullable BlockElementRotation p_254150_) {
        if (p_254150_ == null) {
            return;
        }
        Vector3fc $$2 = p_254150_.axis().getPositive().getUnitVec3f();
        Matrix4f $$3 = new Matrix4f().rotation(p_254150_.angle() * ((float)Math.PI / 180), $$2);
        Vector3fc $$4 = p_254150_.rescale() ? FaceBakery.computeRescale(p_254150_) : NO_RESCALE;
        FaceBakery.rotateVertexBy(p_254412_, (Vector3fc)p_254150_.origin(), (Matrix4fc)$$3, $$4);
    }

    private static Vector3fc computeRescale(BlockElementRotation p_418070_) {
        if (p_418070_.angle() == 0.0f) {
            return NO_RESCALE;
        }
        float $$1 = Math.abs(p_418070_.angle());
        float $$2 = 1.0f / Mth.cos($$1 * ((float)Math.PI / 180));
        return switch (p_418070_.axis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> new Vector3f(1.0f, $$2, $$2);
            case Direction.Axis.Y -> new Vector3f($$2, 1.0f, $$2);
            case Direction.Axis.Z -> new Vector3f($$2, $$2, 1.0f);
        };
    }

    private static void applyModelRotation(Vector3f p_254561_, Transformation p_253793_) {
        if (p_253793_ == Transformation.identity()) {
            return;
        }
        FaceBakery.rotateVertexBy(p_254561_, BLOCK_MIDDLE, p_253793_.getMatrix(), NO_RESCALE);
    }

    private static void rotateVertexBy(Vector3f p_404849_, Vector3fc p_404934_, Matrix4fc p_405201_, Vector3fc p_405230_) {
        p_404849_.sub(p_404934_);
        p_405201_.transformPosition(p_404849_);
        p_404849_.mul(p_405230_);
        p_404849_.add(p_404934_);
    }

    private static Direction calculateFacing(int[] p_111613_) {
        Vector3f $$1 = FaceBakery.vectorFromData(p_111613_, 0);
        Vector3f $$2 = FaceBakery.vectorFromData(p_111613_, 8);
        Vector3f $$3 = FaceBakery.vectorFromData(p_111613_, 16);
        Vector3f $$4 = new Vector3f((Vector3fc)$$1).sub((Vector3fc)$$2);
        Vector3f $$5 = new Vector3f((Vector3fc)$$3).sub((Vector3fc)$$2);
        Vector3f $$6 = new Vector3f((Vector3fc)$$5).cross((Vector3fc)$$4).normalize();
        if (!$$6.isFinite()) {
            return Direction.UP;
        }
        Direction $$7 = null;
        float $$8 = 0.0f;
        for (Direction $$9 : Direction.values()) {
            float $$10 = $$6.dot($$9.getUnitVec3f());
            if (!($$10 >= 0.0f) || !($$10 > $$8)) continue;
            $$8 = $$10;
            $$7 = $$9;
        }
        if ($$7 == null) {
            return Direction.UP;
        }
        return $$7;
    }

    private static float xFromData(int[] p_404923_, int p_404736_) {
        return Float.intBitsToFloat(p_404923_[p_404736_]);
    }

    private static float yFromData(int[] p_405832_, int p_405261_) {
        return Float.intBitsToFloat(p_405832_[p_405261_ + 1]);
    }

    private static float zFromData(int[] p_405720_, int p_405821_) {
        return Float.intBitsToFloat(p_405720_[p_405821_ + 2]);
    }

    private static Vector3f vectorFromData(int[] p_405451_, int p_404978_) {
        return new Vector3f(FaceBakery.xFromData(p_405451_, p_404978_), FaceBakery.yFromData(p_405451_, p_404978_), FaceBakery.zFromData(p_405451_, p_404978_));
    }

    private static void recalculateWinding(int[] p_111631_, Direction p_111632_) {
        int[] $$2 = new int[p_111631_.length];
        System.arraycopy(p_111631_, 0, $$2, 0, p_111631_.length);
        float[] $$3 = new float[Direction.values().length];
        $$3[FaceInfo.Constants.MIN_X] = 999.0f;
        $$3[FaceInfo.Constants.MIN_Y] = 999.0f;
        $$3[FaceInfo.Constants.MIN_Z] = 999.0f;
        $$3[FaceInfo.Constants.MAX_X] = -999.0f;
        $$3[FaceInfo.Constants.MAX_Y] = -999.0f;
        $$3[FaceInfo.Constants.MAX_Z] = -999.0f;
        for (int $$4 = 0; $$4 < 4; ++$$4) {
            int $$5 = 8 * $$4;
            float $$6 = FaceBakery.xFromData($$2, $$5);
            float $$7 = FaceBakery.yFromData($$2, $$5);
            float $$8 = FaceBakery.zFromData($$2, $$5);
            if ($$6 < $$3[FaceInfo.Constants.MIN_X]) {
                $$3[FaceInfo.Constants.MIN_X] = $$6;
            }
            if ($$7 < $$3[FaceInfo.Constants.MIN_Y]) {
                $$3[FaceInfo.Constants.MIN_Y] = $$7;
            }
            if ($$8 < $$3[FaceInfo.Constants.MIN_Z]) {
                $$3[FaceInfo.Constants.MIN_Z] = $$8;
            }
            if ($$6 > $$3[FaceInfo.Constants.MAX_X]) {
                $$3[FaceInfo.Constants.MAX_X] = $$6;
            }
            if ($$7 > $$3[FaceInfo.Constants.MAX_Y]) {
                $$3[FaceInfo.Constants.MAX_Y] = $$7;
            }
            if (!($$8 > $$3[FaceInfo.Constants.MAX_Z])) continue;
            $$3[FaceInfo.Constants.MAX_Z] = $$8;
        }
        FaceInfo $$9 = FaceInfo.fromFacing(p_111632_);
        for (int $$10 = 0; $$10 < 4; ++$$10) {
            int $$11 = 8 * $$10;
            FaceInfo.VertexInfo $$12 = $$9.getVertexInfo($$10);
            float $$13 = $$3[$$12.xFace];
            float $$14 = $$3[$$12.yFace];
            float $$15 = $$3[$$12.zFace];
            p_111631_[$$11] = Float.floatToRawIntBits($$13);
            p_111631_[$$11 + 1] = Float.floatToRawIntBits($$14);
            p_111631_[$$11 + 2] = Float.floatToRawIntBits($$15);
            for (int $$16 = 0; $$16 < 4; ++$$16) {
                int $$17 = 8 * $$16;
                float $$18 = FaceBakery.xFromData($$2, $$17);
                float $$19 = FaceBakery.yFromData($$2, $$17);
                float $$20 = FaceBakery.zFromData($$2, $$17);
                if (!Mth.equal($$13, $$18) || !Mth.equal($$14, $$19) || !Mth.equal($$15, $$20)) continue;
                p_111631_[$$11 + 4] = $$2[$$17 + 4];
                p_111631_[$$11 + 4 + 1] = $$2[$$17 + 4 + 1];
            }
        }
    }

    public static void extractPositions(int[] p_405530_, Consumer<Vector3f> p_404815_) {
        for (int $$2 = 0; $$2 < 4; ++$$2) {
            p_404815_.accept(FaceBakery.vectorFromData(p_405530_, 8 * $$2));
        }
    }
}

