/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.WeightedVariants;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.block.state.BlockState;

public interface BlockStateModel {
    public void collectParts(RandomSource var1, List<BlockModelPart> var2);

    default public List<BlockModelPart> collectParts(RandomSource p_410570_) {
        ObjectArrayList $$1 = new ObjectArrayList();
        this.collectParts(p_410570_, (List<BlockModelPart>)$$1);
        return $$1;
    }

    public TextureAtlasSprite particleIcon();

    public static class SimpleCachedUnbakedRoot
    implements UnbakedRoot {
        final Unbaked contents;
        private final ModelBaker.SharedOperationKey<BlockStateModel> bakingKey = new ModelBaker.SharedOperationKey<BlockStateModel>(){

            @Override
            public BlockStateModel compute(ModelBaker p_409856_) {
                return contents.bake(p_409856_);
            }

            @Override
            public /* synthetic */ Object compute(ModelBaker modelBaker) {
                return this.compute(modelBaker);
            }
        };

        public SimpleCachedUnbakedRoot(Unbaked p_410217_) {
            this.contents = p_410217_;
        }

        @Override
        public void resolveDependencies(ResolvableModel.Resolver p_410344_) {
            this.contents.resolveDependencies(p_410344_);
        }

        @Override
        public BlockStateModel bake(BlockState p_410257_, ModelBaker p_410233_) {
            return p_410233_.compute(this.bakingKey);
        }

        @Override
        public Object visualEqualityGroup(BlockState p_409960_) {
            return this;
        }
    }

    public static interface Unbaked
    extends ResolvableModel {
        public static final Codec<Weighted<Variant>> ELEMENT_CODEC = RecordCodecBuilder.create(p_409971_ -> p_409971_.group((App)Variant.MAP_CODEC.forGetter(Weighted::value), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Weighted::weight)).apply((Applicative)p_409971_, Weighted::new));
        public static final Codec<WeightedVariants.Unbaked> HARDCODED_WEIGHTED_CODEC = ExtraCodecs.nonEmptyList(ELEMENT_CODEC.listOf()).flatComapMap(p_409703_ -> new WeightedVariants.Unbaked(WeightedList.of(Lists.transform((List)p_409703_, p_409617_ -> p_409617_.map(SingleVariant.Unbaked::new)))), p_409817_ -> {
            List<Weighted<Unbaked>> $$1 = p_409817_.entries().unwrap();
            ArrayList<Weighted<Variant>> $$2 = new ArrayList<Weighted<Variant>>($$1.size());
            for (Weighted<Unbaked> $$3 : $$1) {
                Unbaked $$4 = $$3.value();
                if ($$4 instanceof SingleVariant.Unbaked) {
                    SingleVariant.Unbaked $$5 = (SingleVariant.Unbaked)$$4;
                    $$2.add(new Weighted<Variant>($$5.variant(), $$3.weight()));
                    continue;
                }
                return DataResult.error(() -> "Only single variants are supported");
            }
            return DataResult.success($$2);
        });
        public static final Codec<Unbaked> CODEC = Codec.either(HARDCODED_WEIGHTED_CODEC, SingleVariant.Unbaked.CODEC).flatComapMap(p_410308_ -> (Unbaked)p_410308_.map(p_410746_ -> p_410746_, p_410169_ -> p_410169_), p_410404_ -> {
            Unbaked unbaked = p_410404_;
            Objects.requireNonNull(unbaked);
            Unbaked $$1 = unbaked;
            int $$2 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleVariant.Unbaked.class, WeightedVariants.Unbaked.class}, (Object)$$1, $$2)) {
                case 0 -> {
                    SingleVariant.Unbaked $$3 = (SingleVariant.Unbaked)$$1;
                    yield DataResult.success((Object)Either.right((Object)$$3));
                }
                case 1 -> {
                    WeightedVariants.Unbaked $$4 = (WeightedVariants.Unbaked)$$1;
                    yield DataResult.success((Object)Either.left((Object)$$4));
                }
                default -> DataResult.error(() -> "Only a single variant or a list of variants are supported");
            };
        });

        public BlockStateModel bake(ModelBaker var1);

        default public UnbakedRoot asRoot() {
            return new SimpleCachedUnbakedRoot(this);
        }
    }

    public static interface UnbakedRoot
    extends ResolvableModel {
        public BlockStateModel bake(BlockState var1, ModelBaker var2);

        public Object visualEqualityGroup(BlockState var1);
    }
}

