/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record BlockElement(Vector3fc from, Vector3fc to, Map<Direction, BlockElementFace> faces, @Nullable BlockElementRotation rotation, boolean shade, int lightEmission) {
    private static final boolean DEFAULT_RESCALE = false;
    private static final float MIN_EXTENT = -16.0f;
    private static final float MAX_EXTENT = 32.0f;

    public BlockElement(Vector3fc p_405527_, Vector3fc p_405454_, Map<Direction, BlockElementFace> p_362722_) {
        this(p_405527_, p_405454_, p_362722_, null, true, 0);
    }

    protected static class Deserializer
    implements JsonDeserializer<BlockElement> {
        private static final boolean DEFAULT_SHADE = true;
        private static final int DEFAULT_LIGHT_EMISSION = 0;

        protected Deserializer() {
        }

        public BlockElement deserialize(JsonElement p_111329_, Type p_111330_, JsonDeserializationContext p_111331_) throws JsonParseException {
            JsonObject $$3 = p_111329_.getAsJsonObject();
            Vector3f $$4 = this.getFrom($$3);
            Vector3f $$5 = this.getTo($$3);
            BlockElementRotation $$6 = this.getRotation($$3);
            Map<Direction, BlockElementFace> $$7 = this.getFaces(p_111331_, $$3);
            if ($$3.has("shade") && !GsonHelper.isBooleanValue($$3, "shade")) {
                throw new JsonParseException("Expected shade to be a Boolean");
            }
            boolean $$8 = GsonHelper.getAsBoolean($$3, "shade", true);
            int $$9 = 0;
            if ($$3.has("light_emission")) {
                boolean $$10 = GsonHelper.isNumberValue($$3, "light_emission");
                if ($$10) {
                    $$9 = GsonHelper.getAsInt($$3, "light_emission");
                }
                if (!$$10 || $$9 < 0 || $$9 > 15) {
                    throw new JsonParseException("Expected light_emission to be an Integer between (inclusive) 0 and 15");
                }
            }
            return new BlockElement((Vector3fc)$$4, (Vector3fc)$$5, $$7, $$6, $$8, $$9);
        }

        @Nullable
        private BlockElementRotation getRotation(JsonObject p_111333_) {
            BlockElementRotation $$1 = null;
            if (p_111333_.has("rotation")) {
                JsonObject $$2 = GsonHelper.getAsJsonObject(p_111333_, "rotation");
                Vector3f $$3 = this.getVector3f($$2, "origin");
                $$3.mul(0.0625f);
                Direction.Axis $$4 = this.getAxis($$2);
                float $$5 = this.getAngle($$2);
                boolean $$6 = GsonHelper.getAsBoolean($$2, "rescale", false);
                $$1 = new BlockElementRotation($$3, $$4, $$5, $$6);
            }
            return $$1;
        }

        private float getAngle(JsonObject p_111343_) {
            float $$1 = GsonHelper.getAsFloat(p_111343_, "angle");
            if (Mth.abs($$1) > 45.0f) {
                throw new JsonParseException("Invalid rotation " + $$1 + " found, only values in [-45,45] range allowed");
            }
            return $$1;
        }

        private Direction.Axis getAxis(JsonObject p_111345_) {
            String $$1 = GsonHelper.getAsString(p_111345_, "axis");
            Direction.Axis $$2 = Direction.Axis.byName($$1.toLowerCase(Locale.ROOT));
            if ($$2 == null) {
                throw new JsonParseException("Invalid rotation axis: " + $$1);
            }
            return $$2;
        }

        private Map<Direction, BlockElementFace> getFaces(JsonDeserializationContext p_111326_, JsonObject p_111327_) {
            Map<Direction, BlockElementFace> $$2 = this.filterNullFromFaces(p_111326_, p_111327_);
            if ($$2.isEmpty()) {
                throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
            }
            return $$2;
        }

        private Map<Direction, BlockElementFace> filterNullFromFaces(JsonDeserializationContext p_111340_, JsonObject p_111341_) {
            EnumMap $$2 = Maps.newEnumMap(Direction.class);
            JsonObject $$3 = GsonHelper.getAsJsonObject(p_111341_, "faces");
            for (Map.Entry $$4 : $$3.entrySet()) {
                Direction $$5 = this.getFacing((String)$$4.getKey());
                $$2.put($$5, (BlockElementFace)p_111340_.deserialize((JsonElement)$$4.getValue(), BlockElementFace.class));
            }
            return $$2;
        }

        private Direction getFacing(String p_111338_) {
            Direction $$1 = Direction.byName(p_111338_);
            if ($$1 == null) {
                throw new JsonParseException("Unknown facing: " + p_111338_);
            }
            return $$1;
        }

        private Vector3f getTo(JsonObject p_111353_) {
            Vector3f $$1 = this.getVector3f(p_111353_, "to");
            if ($$1.x() < -16.0f || $$1.y() < -16.0f || $$1.z() < -16.0f || $$1.x() > 32.0f || $$1.y() > 32.0f || $$1.z() > 32.0f) {
                throw new JsonParseException("'to' specifier exceeds the allowed boundaries: " + String.valueOf($$1));
            }
            return $$1;
        }

        private Vector3f getFrom(JsonObject p_111347_) {
            Vector3f $$1 = this.getVector3f(p_111347_, "from");
            if ($$1.x() < -16.0f || $$1.y() < -16.0f || $$1.z() < -16.0f || $$1.x() > 32.0f || $$1.y() > 32.0f || $$1.z() > 32.0f) {
                throw new JsonParseException("'from' specifier exceeds the allowed boundaries: " + String.valueOf($$1));
            }
            return $$1;
        }

        private Vector3f getVector3f(JsonObject p_111335_, String p_111336_) {
            JsonArray $$2 = GsonHelper.getAsJsonArray(p_111335_, p_111336_);
            if ($$2.size() != 3) {
                throw new JsonParseException("Expected 3 " + p_111336_ + " values, found: " + $$2.size());
            }
            float[] $$3 = new float[3];
            for (int $$4 = 0; $$4 < $$3.length; ++$$4) {
                $$3[$$4] = GsonHelper.convertToFloat($$2.get($$4), p_111336_ + "[" + $$4 + "]");
            }
            return new Vector3f($$3[0], $$3[1], $$3[2]);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

