/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class WorldBorderRenderer {
    public static final ResourceLocation FORCEFIELD_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/forcefield.png");
    private boolean needsRebuild = true;
    private double lastMinX;
    private double lastMinZ;
    private double lastBorderMinX;
    private double lastBorderMaxX;
    private double lastBorderMinZ;
    private double lastBorderMaxZ;
    private final GpuBuffer worldBorderBuffer = RenderSystem.getDevice().createBuffer(() -> "World border vertex buffer", 40, 16 * DefaultVertexFormat.POSITION_TEX.getVertexSize());
    private final RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);

    private void rebuildWorldBorderBuffer(WorldBorder p_401795_, double p_401863_, double p_401925_, double p_401782_, float p_401880_, float p_401871_, float p_401854_) {
        try (ByteBufferBuilder $$7 = ByteBufferBuilder.exactlySized(DefaultVertexFormat.POSITION_TEX.getVertexSize() * 4 * 4);){
            double $$8 = p_401795_.getMinX();
            double $$9 = p_401795_.getMaxX();
            double $$10 = p_401795_.getMinZ();
            double $$11 = p_401795_.getMaxZ();
            double $$12 = Math.max((double)Mth.floor(p_401925_ - p_401863_), $$10);
            double $$13 = Math.min((double)Mth.ceil(p_401925_ + p_401863_), $$11);
            float $$14 = (float)(Mth.floor($$12) & 1) * 0.5f;
            float $$15 = (float)($$13 - $$12) / 2.0f;
            double $$16 = Math.max((double)Mth.floor(p_401782_ - p_401863_), $$8);
            double $$17 = Math.min((double)Mth.ceil(p_401782_ + p_401863_), $$9);
            float $$18 = (float)(Mth.floor($$16) & 1) * 0.5f;
            float $$19 = (float)($$17 - $$16) / 2.0f;
            BufferBuilder $$20 = new BufferBuilder($$7, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            $$20.addVertex(0.0f, -p_401880_, (float)($$11 - $$12)).setUv($$18, p_401871_);
            $$20.addVertex((float)($$17 - $$16), -p_401880_, (float)($$11 - $$12)).setUv($$19 + $$18, p_401871_);
            $$20.addVertex((float)($$17 - $$16), p_401880_, (float)($$11 - $$12)).setUv($$19 + $$18, p_401854_);
            $$20.addVertex(0.0f, p_401880_, (float)($$11 - $$12)).setUv($$18, p_401854_);
            $$20.addVertex(0.0f, -p_401880_, 0.0f).setUv($$14, p_401871_);
            $$20.addVertex(0.0f, -p_401880_, (float)($$13 - $$12)).setUv($$15 + $$14, p_401871_);
            $$20.addVertex(0.0f, p_401880_, (float)($$13 - $$12)).setUv($$15 + $$14, p_401854_);
            $$20.addVertex(0.0f, p_401880_, 0.0f).setUv($$14, p_401854_);
            $$20.addVertex((float)($$17 - $$16), -p_401880_, 0.0f).setUv($$18, p_401871_);
            $$20.addVertex(0.0f, -p_401880_, 0.0f).setUv($$19 + $$18, p_401871_);
            $$20.addVertex(0.0f, p_401880_, 0.0f).setUv($$19 + $$18, p_401854_);
            $$20.addVertex((float)($$17 - $$16), p_401880_, 0.0f).setUv($$18, p_401854_);
            $$20.addVertex((float)($$9 - $$16), -p_401880_, (float)($$13 - $$12)).setUv($$14, p_401871_);
            $$20.addVertex((float)($$9 - $$16), -p_401880_, 0.0f).setUv($$15 + $$14, p_401871_);
            $$20.addVertex((float)($$9 - $$16), p_401880_, 0.0f).setUv($$15 + $$14, p_401854_);
            $$20.addVertex((float)($$9 - $$16), p_401880_, (float)($$13 - $$12)).setUv($$14, p_401854_);
            try (MeshData $$21 = $$20.buildOrThrow();){
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(this.worldBorderBuffer.slice(), $$21.vertexBuffer());
            }
            this.lastBorderMinX = $$8;
            this.lastBorderMaxX = $$9;
            this.lastBorderMinZ = $$10;
            this.lastBorderMaxZ = $$11;
            this.lastMinX = $$16;
            this.lastMinZ = $$12;
            this.needsRebuild = false;
        }
    }

    public void render(WorldBorder p_365515_, Vec3 p_360961_, double p_364707_, double p_361253_) {
        GpuTextureView $$27;
        GpuTextureView $$26;
        double $$4 = p_365515_.getMinX();
        double $$5 = p_365515_.getMaxX();
        double $$6 = p_365515_.getMinZ();
        double $$7 = p_365515_.getMaxZ();
        if (p_360961_.x < $$5 - p_364707_ && p_360961_.x > $$4 + p_364707_ && p_360961_.z < $$7 - p_364707_ && p_360961_.z > $$6 + p_364707_ || p_360961_.x < $$4 - p_364707_ || p_360961_.x > $$5 + p_364707_ || p_360961_.z < $$6 - p_364707_ || p_360961_.z > $$7 + p_364707_) {
            return;
        }
        double $$8 = 1.0 - p_365515_.getDistanceToBorder(p_360961_.x, p_360961_.z) / p_364707_;
        $$8 = Math.pow($$8, 4.0);
        $$8 = Mth.clamp($$8, 0.0, 1.0);
        double $$9 = p_360961_.x;
        double $$10 = p_360961_.z;
        float $$11 = (float)p_361253_;
        int $$12 = p_365515_.getStatus().getColor();
        float $$13 = (float)ARGB.red($$12) / 255.0f;
        float $$14 = (float)ARGB.green($$12) / 255.0f;
        float $$15 = (float)ARGB.blue($$12) / 255.0f;
        float $$16 = (float)(Util.getMillis() % 3000L) / 3000.0f;
        float $$17 = (float)(-Mth.frac(p_360961_.y * 0.5));
        float $$18 = $$17 + $$11;
        if (this.shouldRebuildWorldBorderBuffer(p_365515_)) {
            this.rebuildWorldBorderBuffer(p_365515_, p_364707_, $$10, $$9, $$11, $$18, $$17);
        }
        TextureManager $$19 = Minecraft.getInstance().getTextureManager();
        AbstractTexture $$20 = $$19.getTexture(FORCEFIELD_LOCATION);
        $$20.setUseMipmaps(false);
        RenderPipeline $$21 = RenderPipelines.WORLD_BORDER;
        RenderTarget $$22 = Minecraft.getInstance().getMainRenderTarget();
        RenderTarget $$23 = Minecraft.getInstance().levelRenderer.getWeatherTarget();
        if ($$23 != null) {
            GpuTextureView $$24 = $$23.getColorTextureView();
            GpuTextureView $$25 = $$23.getDepthTextureView();
        } else {
            $$26 = $$22.getColorTextureView();
            $$27 = $$22.getDepthTextureView();
        }
        GpuBuffer $$28 = this.indices.getBuffer(6);
        GpuBufferSlice $$29 = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f($$13, $$14, $$15, (float)$$8), (Vector3fc)new Vector3f((float)(this.lastMinX - $$9), (float)(-p_360961_.y), (float)(this.lastMinZ - $$10)), (Matrix4fc)new Matrix4f().translation($$16, $$16, 0.0f), 0.0f);
        try (RenderPass $$30 = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "World border", $$26, OptionalInt.empty(), $$27, OptionalDouble.empty());){
            $$30.setPipeline($$21);
            RenderSystem.bindDefaultUniforms($$30);
            $$30.setUniform("DynamicTransforms", $$29);
            $$30.setIndexBuffer($$28, this.indices.type());
            $$30.bindSampler("Sampler0", $$20.getTextureView());
            $$30.setVertexBuffer(0, this.worldBorderBuffer);
            ArrayList $$31 = new ArrayList();
            for (WorldBorder.DistancePerDirection $$32 : p_365515_.closestBorder($$9, $$10)) {
                if (!($$32.distance() < p_364707_)) continue;
                int $$33 = $$32.direction().get2DDataValue();
                $$31.add(new RenderPass.Draw(0, this.worldBorderBuffer, $$28, this.indices.type(), 6 * $$33, 6));
            }
            $$30.drawMultipleIndexed($$31, null, null, Collections.emptyList(), this);
        }
    }

    public void invalidate() {
        this.needsRebuild = true;
    }

    private boolean shouldRebuildWorldBorderBuffer(WorldBorder p_401887_) {
        return this.needsRebuild || p_401887_.getMinX() != this.lastBorderMinX || p_401887_.getMinZ() != this.lastBorderMinZ || p_401887_.getMaxX() != this.lastBorderMaxX || p_401887_.getMaxZ() != this.lastBorderMaxZ;
    }
}

