/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WeatherEffectRenderer {
    private static final int RAIN_RADIUS = 10;
    private static final int RAIN_DIAMETER = 21;
    private static final ResourceLocation RAIN_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/snow.png");
    private static final int RAIN_TABLE_SIZE = 32;
    private static final int HALF_RAIN_TABLE_SIZE = 16;
    private int rainSoundTime;
    private final float[] columnSizeX = new float[1024];
    private final float[] columnSizeZ = new float[1024];

    public WeatherEffectRenderer() {
        for (int $$0 = 0; $$0 < 32; ++$$0) {
            for (int $$1 = 0; $$1 < 32; ++$$1) {
                float $$2 = $$1 - 16;
                float $$3 = $$0 - 16;
                float $$4 = Mth.length($$2, $$3);
                this.columnSizeX[$$0 * 32 + $$1] = -$$3 / $$4;
                this.columnSizeZ[$$0 * 32 + $$1] = $$2 / $$4;
            }
        }
    }

    public void render(Level p_364994_, MultiBufferSource p_383071_, int p_363664_, float p_361655_, Vec3 p_363375_) {
        float $$5 = p_364994_.getRainLevel(p_361655_);
        if ($$5 <= 0.0f) {
            return;
        }
        int $$6 = Minecraft.useFancyGraphics() ? 10 : 5;
        ArrayList<ColumnInstance> $$7 = new ArrayList<ColumnInstance>();
        ArrayList<ColumnInstance> $$8 = new ArrayList<ColumnInstance>();
        this.collectColumnInstances(p_364994_, p_363664_, p_361655_, p_363375_, $$6, $$7, $$8);
        if (!$$7.isEmpty() || !$$8.isEmpty()) {
            this.render(p_383071_, p_363375_, $$6, $$5, $$7, $$8);
        }
    }

    private void collectColumnInstances(Level p_363309_, int p_364806_, float p_363571_, Vec3 p_361736_, int p_365047_, List<ColumnInstance> p_363743_, List<ColumnInstance> p_363189_) {
        int $$7 = Mth.floor(p_361736_.x);
        int $$8 = Mth.floor(p_361736_.y);
        int $$9 = Mth.floor(p_361736_.z);
        BlockPos.MutableBlockPos $$10 = new BlockPos.MutableBlockPos();
        RandomSource $$11 = RandomSource.create();
        for (int $$12 = $$9 - p_365047_; $$12 <= $$9 + p_365047_; ++$$12) {
            for (int $$13 = $$7 - p_365047_; $$13 <= $$7 + p_365047_; ++$$13) {
                Biome.Precipitation $$17;
                int $$14 = p_363309_.getHeight(Heightmap.Types.MOTION_BLOCKING, $$13, $$12);
                int $$15 = Math.max($$8 - p_365047_, $$14);
                int $$16 = Math.max($$8 + p_365047_, $$14);
                if ($$16 - $$15 == 0 || ($$17 = this.getPrecipitationAt(p_363309_, $$10.set($$13, $$8, $$12))) == Biome.Precipitation.NONE) continue;
                int $$18 = $$13 * $$13 * 3121 + $$13 * 45238971 ^ $$12 * $$12 * 418711 + $$12 * 13761;
                $$11.setSeed($$18);
                int $$19 = Math.max($$8, $$14);
                int $$20 = LevelRenderer.getLightColor(p_363309_, $$10.set($$13, $$19, $$12));
                if ($$17 == Biome.Precipitation.RAIN) {
                    p_363743_.add(this.createRainColumnInstance($$11, p_364806_, $$13, $$15, $$16, $$12, $$20, p_363571_));
                    continue;
                }
                if ($$17 != Biome.Precipitation.SNOW) continue;
                p_363189_.add(this.createSnowColumnInstance($$11, p_364806_, $$13, $$15, $$16, $$12, $$20, p_363571_));
            }
        }
    }

    private void render(MultiBufferSource p_382792_, Vec3 p_360652_, int p_365362_, float p_362894_, List<ColumnInstance> p_362059_, List<ColumnInstance> p_362633_) {
        if (!p_362059_.isEmpty()) {
            RenderType $$6 = RenderType.weather(RAIN_LOCATION, Minecraft.useShaderTransparency());
            this.renderInstances(p_382792_.getBuffer($$6), p_362059_, p_360652_, 1.0f, p_365362_, p_362894_);
        }
        if (!p_362633_.isEmpty()) {
            RenderType $$7 = RenderType.weather(SNOW_LOCATION, Minecraft.useShaderTransparency());
            this.renderInstances(p_382792_.getBuffer($$7), p_362633_, p_360652_, 0.8f, p_365362_, p_362894_);
        }
    }

    private ColumnInstance createRainColumnInstance(RandomSource p_364494_, int p_361188_, int p_362466_, int p_364844_, int p_361656_, int p_364160_, int p_361622_, float p_363800_) {
        int $$8 = p_361188_ & 0x1FFFF;
        int $$9 = p_362466_ * p_362466_ * 3121 + p_362466_ * 45238971 + p_364160_ * p_364160_ * 418711 + p_364160_ * 13761 & 0xFF;
        float $$10 = 3.0f + p_364494_.nextFloat();
        float $$11 = -((float)($$8 + $$9) + p_363800_) / 32.0f * $$10;
        float $$12 = $$11 % 32.0f;
        return new ColumnInstance(p_362466_, p_364160_, p_364844_, p_361656_, 0.0f, $$12, p_361622_);
    }

    private ColumnInstance createSnowColumnInstance(RandomSource p_364207_, int p_364249_, int p_360966_, int p_361182_, int p_360486_, int p_364645_, int p_361024_, float p_362542_) {
        float $$8 = (float)p_364249_ + p_362542_;
        float $$9 = (float)(p_364207_.nextDouble() + (double)($$8 * 0.01f * (float)p_364207_.nextGaussian()));
        float $$10 = (float)(p_364207_.nextDouble() + (double)($$8 * (float)p_364207_.nextGaussian() * 0.001f));
        float $$11 = -((float)(p_364249_ & 0x1FF) + p_362542_) / 512.0f;
        int $$12 = LightTexture.pack((LightTexture.block(p_361024_) * 3 + 15) / 4, (LightTexture.sky(p_361024_) * 3 + 15) / 4);
        return new ColumnInstance(p_360966_, p_364645_, p_361182_, p_360486_, $$9, $$11 + $$10, $$12);
    }

    private void renderInstances(VertexConsumer p_383100_, List<ColumnInstance> p_364429_, Vec3 p_363972_, float p_364489_, int p_361243_, float p_362812_) {
        for (ColumnInstance $$6 : p_364429_) {
            float $$7 = (float)((double)$$6.x + 0.5 - p_363972_.x);
            float $$8 = (float)((double)$$6.z + 0.5 - p_363972_.z);
            float $$9 = (float)Mth.lengthSquared($$7, $$8);
            float $$10 = Mth.lerp($$9 / (float)(p_361243_ * p_361243_), p_364489_, 0.5f) * p_362812_;
            int $$11 = ARGB.white($$10);
            int $$12 = ($$6.z - Mth.floor(p_363972_.z) + 16) * 32 + $$6.x - Mth.floor(p_363972_.x) + 16;
            float $$13 = this.columnSizeX[$$12] / 2.0f;
            float $$14 = this.columnSizeZ[$$12] / 2.0f;
            float $$15 = $$7 - $$13;
            float $$16 = $$7 + $$13;
            float $$17 = (float)((double)$$6.topY - p_363972_.y);
            float $$18 = (float)((double)$$6.bottomY - p_363972_.y);
            float $$19 = $$8 - $$14;
            float $$20 = $$8 + $$14;
            float $$21 = $$6.uOffset + 0.0f;
            float $$22 = $$6.uOffset + 1.0f;
            float $$23 = (float)$$6.bottomY * 0.25f + $$6.vOffset;
            float $$24 = (float)$$6.topY * 0.25f + $$6.vOffset;
            p_383100_.addVertex($$15, $$17, $$19).setUv($$21, $$23).setColor($$11).setLight($$6.lightCoords);
            p_383100_.addVertex($$16, $$17, $$20).setUv($$22, $$23).setColor($$11).setLight($$6.lightCoords);
            p_383100_.addVertex($$16, $$18, $$20).setUv($$22, $$24).setColor($$11).setLight($$6.lightCoords);
            p_383100_.addVertex($$15, $$18, $$19).setUv($$21, $$24).setColor($$11).setLight($$6.lightCoords);
        }
    }

    public void tickRainParticles(ClientLevel p_361823_, Camera p_364990_, int p_361788_, ParticleStatus p_363302_) {
        float $$4 = p_361823_.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        if ($$4 <= 0.0f) {
            return;
        }
        RandomSource $$5 = RandomSource.create((long)p_361788_ * 312987231L);
        BlockPos $$6 = BlockPos.containing(p_364990_.getPosition());
        Vec3i $$7 = null;
        int $$8 = (int)(100.0f * $$4 * $$4) / (p_363302_ == ParticleStatus.DECREASED ? 2 : 1);
        for (int $$9 = 0; $$9 < $$8; ++$$9) {
            int $$11;
            int $$10 = $$5.nextInt(21) - 10;
            BlockPos $$12 = p_361823_.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, $$6.offset($$10, 0, $$11 = $$5.nextInt(21) - 10));
            if ($$12.getY() <= p_361823_.getMinY() || $$12.getY() > $$6.getY() + 10 || $$12.getY() < $$6.getY() - 10 || this.getPrecipitationAt(p_361823_, $$12) != Biome.Precipitation.RAIN) continue;
            $$7 = $$12.below();
            if (p_363302_ == ParticleStatus.MINIMAL) break;
            double $$13 = $$5.nextDouble();
            double $$14 = $$5.nextDouble();
            BlockState $$15 = p_361823_.getBlockState((BlockPos)$$7);
            FluidState $$16 = p_361823_.getFluidState((BlockPos)$$7);
            VoxelShape $$17 = $$15.getCollisionShape(p_361823_, (BlockPos)$$7);
            double $$18 = $$17.max(Direction.Axis.Y, $$13, $$14);
            double $$19 = $$16.getHeight(p_361823_, (BlockPos)$$7);
            double $$20 = Math.max($$18, $$19);
            SimpleParticleType $$21 = $$16.is(FluidTags.LAVA) || $$15.is(Blocks.MAGMA_BLOCK) || CampfireBlock.isLitCampfire($$15) ? ParticleTypes.SMOKE : ParticleTypes.RAIN;
            p_361823_.addParticle($$21, (double)$$7.getX() + $$13, (double)$$7.getY() + $$20, (double)$$7.getZ() + $$14, 0.0, 0.0, 0.0);
        }
        if ($$7 != null && $$5.nextInt(3) < this.rainSoundTime++) {
            this.rainSoundTime = 0;
            if ($$7.getY() > $$6.getY() + 1 && p_361823_.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, $$6).getY() > Mth.floor($$6.getY())) {
                p_361823_.playLocalSound((BlockPos)$$7, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
            } else {
                p_361823_.playLocalSound((BlockPos)$$7, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
            }
        }
    }

    private Biome.Precipitation getPrecipitationAt(Level p_362885_, BlockPos p_362817_) {
        if (!p_362885_.getChunkSource().hasChunk(SectionPos.blockToSectionCoord(p_362817_.getX()), SectionPos.blockToSectionCoord(p_362817_.getZ()))) {
            return Biome.Precipitation.NONE;
        }
        Biome $$2 = p_362885_.getBiome(p_362817_).value();
        return $$2.getPrecipitationAt(p_362817_, p_362885_.getSeaLevel());
    }

    record ColumnInstance(int x, int z, int bottomY, int topY, float uOffset, float vOffset, int lightCoords) {
    }
}

