/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;

public record ShaderDefines(Map<String, String> values, Set<String> flags) {
    public static final ShaderDefines EMPTY = new ShaderDefines(Map.of(), Set.of());
    public static final Codec<ShaderDefines> CODEC = RecordCodecBuilder.create(p_366546_ -> p_366546_.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("values", Map.of()).forGetter(ShaderDefines::values), (App)Codec.STRING.listOf().xmap(Set::copyOf, List::copyOf).optionalFieldOf("flags", Set.of()).forGetter(ShaderDefines::flags)).apply((Applicative)p_366546_, ShaderDefines::new));

    public static Builder builder() {
        return new Builder();
    }

    public ShaderDefines withOverrides(ShaderDefines p_366677_) {
        if (this.isEmpty()) {
            return p_366677_;
        }
        if (p_366677_.isEmpty()) {
            return this;
        }
        ImmutableMap.Builder $$1 = ImmutableMap.builderWithExpectedSize((int)(this.values.size() + p_366677_.values.size()));
        $$1.putAll(this.values);
        $$1.putAll(p_366677_.values);
        ImmutableSet.Builder $$2 = ImmutableSet.builderWithExpectedSize((int)(this.flags.size() + p_366677_.flags.size()));
        $$2.addAll(this.flags);
        $$2.addAll(p_366677_.flags);
        return new ShaderDefines((Map<String, String>)$$1.buildKeepingLast(), (Set<String>)$$2.build());
    }

    public String asSourceDirectives() {
        StringBuilder $$0 = new StringBuilder();
        for (Map.Entry<String, String> $$1 : this.values.entrySet()) {
            String $$2 = $$1.getKey();
            String $$3 = $$1.getValue();
            $$0.append("#define ").append($$2).append(" ").append($$3).append('\n');
        }
        for (String $$4 : this.flags) {
            $$0.append("#define ").append($$4).append('\n');
        }
        return $$0.toString();
    }

    public boolean isEmpty() {
        return this.values.isEmpty() && this.flags.isEmpty();
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, String> values = ImmutableMap.builder();
        private final ImmutableSet.Builder<String> flags = ImmutableSet.builder();

        Builder() {
        }

        public Builder define(String p_366680_, String p_366593_) {
            if (p_366593_.isBlank()) {
                throw new IllegalArgumentException("Cannot define empty string");
            }
            this.values.put((Object)p_366680_, (Object)Builder.escapeNewLines(p_366593_));
            return this;
        }

        private static String escapeNewLines(String p_366812_) {
            return p_366812_.replaceAll("\n", "\\\\\n");
        }

        public Builder define(String p_366704_, float p_366833_) {
            this.values.put((Object)p_366704_, (Object)String.valueOf(p_366833_));
            return this;
        }

        public Builder define(String p_404977_, int p_404735_) {
            this.values.put((Object)p_404977_, (Object)String.valueOf(p_404735_));
            return this;
        }

        public Builder define(String p_366554_) {
            this.flags.add((Object)p_366554_);
            return this;
        }

        public ShaderDefines build() {
            return new ShaderDefines((Map<String, String>)this.values.build(), (Set<String>)this.flags.build());
        }
    }
}

