/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Octree;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.CompiledSectionMesh;
import net.minecraft.client.renderer.chunk.SectionMesh;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;

public class SectionOcclusionGraph {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final int MINIMUM_ADVANCED_CULLING_DISTANCE = 60;
    private static final int MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE = SectionPos.blockToSectionCoord(60);
    private static final double CEILED_SECTION_DIAGONAL = Math.ceil(Math.sqrt(3.0) * 16.0);
    private boolean needsFullUpdate = true;
    @Nullable
    private Future<?> fullUpdateTask;
    @Nullable
    private ViewArea viewArea;
    private final AtomicReference<GraphState> currentGraph = new AtomicReference();
    private final AtomicReference<GraphEvents> nextGraphEvents = new AtomicReference();
    private final AtomicBoolean needsFrustumUpdate = new AtomicBoolean(false);

    public void waitAndReset(@Nullable ViewArea p_294431_) {
        if (this.fullUpdateTask != null) {
            try {
                this.fullUpdateTask.get();
                this.fullUpdateTask = null;
            }
            catch (Exception $$1) {
                LOGGER.warn("Full update failed", (Throwable)$$1);
            }
        }
        this.viewArea = p_294431_;
        if (p_294431_ != null) {
            this.currentGraph.set(new GraphState(p_294431_));
            this.invalidate();
        } else {
            this.currentGraph.set(null);
        }
    }

    public void invalidate() {
        this.needsFullUpdate = true;
    }

    public void addSectionsInFrustum(Frustum p_294180_, List<SectionRenderDispatcher.RenderSection> p_296160_, List<SectionRenderDispatcher.RenderSection> p_371751_) {
        this.currentGraph.get().storage().sectionTree.visitNodes((p_370300_, p_370301_, p_370302_, p_370303_) -> {
            SectionRenderDispatcher.RenderSection $$6 = p_370300_.getSection();
            if ($$6 != null) {
                p_296160_.add($$6);
                if (p_370303_) {
                    p_371751_.add($$6);
                }
            }
        }, p_294180_, 32);
    }

    public boolean consumeFrustumUpdate() {
        return this.needsFrustumUpdate.compareAndSet(true, false);
    }

    public void onChunkReadyToRender(ChunkPos p_294122_) {
        GraphEvents $$2;
        GraphEvents $$1 = this.nextGraphEvents.get();
        if ($$1 != null) {
            this.addNeighbors($$1, p_294122_);
        }
        if (($$2 = this.currentGraph.get().events) != $$1) {
            this.addNeighbors($$2, p_294122_);
        }
    }

    public void schedulePropagationFrom(SectionRenderDispatcher.RenderSection p_295414_) {
        GraphEvents $$2;
        GraphEvents $$1 = this.nextGraphEvents.get();
        if ($$1 != null) {
            $$1.sectionsToPropagateFrom.add(p_295414_);
        }
        if (($$2 = this.currentGraph.get().events) != $$1) {
            $$2.sectionsToPropagateFrom.add(p_295414_);
        }
    }

    public void update(boolean p_294298_, Camera p_294529_, Frustum p_294426_, List<SectionRenderDispatcher.RenderSection> p_295280_, LongOpenHashSet p_366410_) {
        Vec3 $$5 = p_294529_.getPosition();
        if (this.needsFullUpdate && (this.fullUpdateTask == null || this.fullUpdateTask.isDone())) {
            this.scheduleFullUpdate(p_294298_, p_294529_, $$5, p_366410_);
        }
        this.runPartialUpdate(p_294298_, p_294426_, p_295280_, $$5, p_366410_);
    }

    private void scheduleFullUpdate(boolean p_294514_, Camera p_295663_, Vec3 p_295096_, LongOpenHashSet p_366772_) {
        this.needsFullUpdate = false;
        LongOpenHashSet $$4 = p_366772_.clone();
        this.fullUpdateTask = CompletableFuture.runAsync(() -> {
            GraphState $$4 = new GraphState(this.viewArea);
            this.nextGraphEvents.set($$4.events);
            ArrayDeque $$5 = Queues.newArrayDeque();
            this.initializeQueueForFullUpdate(p_295663_, $$5);
            $$5.forEach(p_295724_ -> p_296303_.storage.sectionToNodeMap.put(p_295724_.section, (Node)p_295724_));
            this.runUpdates($$4.storage, p_295096_, $$5, p_294514_, p_294678_ -> {}, $$4);
            this.currentGraph.set($$4);
            this.nextGraphEvents.set(null);
            this.needsFrustumUpdate.set(true);
        }, Util.backgroundExecutor());
    }

    private void runPartialUpdate(boolean p_294795_, Frustum p_294341_, List<SectionRenderDispatcher.RenderSection> p_294796_, Vec3 p_295915_, LongOpenHashSet p_366753_) {
        GraphState $$5 = this.currentGraph.get();
        this.queueSectionsWithNewNeighbors($$5);
        if (!$$5.events.sectionsToPropagateFrom.isEmpty()) {
            ArrayDeque $$6 = Queues.newArrayDeque();
            while (!$$5.events.sectionsToPropagateFrom.isEmpty()) {
                SectionRenderDispatcher.RenderSection $$7 = (SectionRenderDispatcher.RenderSection)$$5.events.sectionsToPropagateFrom.poll();
                Node $$8 = $$5.storage.sectionToNodeMap.get($$7);
                if ($$8 == null || $$8.section != $$7) continue;
                $$6.add($$8);
            }
            Frustum $$9 = LevelRenderer.offsetFrustum(p_294341_);
            Consumer<SectionRenderDispatcher.RenderSection> $$10 = p_370305_ -> {
                if ($$9.isVisible(p_370305_.getBoundingBox())) {
                    this.needsFrustumUpdate.set(true);
                }
            };
            this.runUpdates($$5.storage, p_295915_, $$6, p_294795_, $$10, p_366753_);
        }
    }

    private void queueSectionsWithNewNeighbors(GraphState p_296471_) {
        LongIterator $$1 = p_296471_.events.chunksWhichReceivedNeighbors.iterator();
        while ($$1.hasNext()) {
            long $$2 = $$1.nextLong();
            List $$3 = (List)p_296471_.storage.chunksWaitingForNeighbors.get($$2);
            if ($$3 == null || !((SectionRenderDispatcher.RenderSection)$$3.get(0)).hasAllNeighbors()) continue;
            p_296471_.events.sectionsToPropagateFrom.addAll($$3);
            p_296471_.storage.chunksWaitingForNeighbors.remove($$2);
        }
        p_296471_.events.chunksWhichReceivedNeighbors.clear();
    }

    private void addNeighbors(GraphEvents p_295866_, ChunkPos p_295968_) {
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x - 1, p_295968_.z));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x, p_295968_.z - 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x + 1, p_295968_.z));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x, p_295968_.z + 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x - 1, p_295968_.z - 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x - 1, p_295968_.z + 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x + 1, p_295968_.z - 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x + 1, p_295968_.z + 1));
    }

    private void initializeQueueForFullUpdate(Camera p_295148_, Queue<Node> p_294801_) {
        BlockPos $$2 = p_295148_.getBlockPosition();
        long $$3 = SectionPos.asLong($$2);
        int $$4 = SectionPos.y($$3);
        SectionRenderDispatcher.RenderSection $$5 = this.viewArea.getRenderSection($$3);
        if ($$5 == null) {
            LevelHeightAccessor $$6 = this.viewArea.getLevelHeightAccessor();
            boolean $$7 = $$4 < $$6.getMinSectionY();
            int $$8 = $$7 ? $$6.getMinSectionY() : $$6.getMaxSectionY();
            int $$9 = this.viewArea.getViewDistance();
            ArrayList $$10 = Lists.newArrayList();
            int $$11 = SectionPos.x($$3);
            int $$12 = SectionPos.z($$3);
            for (int $$13 = -$$9; $$13 <= $$9; ++$$13) {
                for (int $$14 = -$$9; $$14 <= $$9; ++$$14) {
                    SectionRenderDispatcher.RenderSection $$15 = this.viewArea.getRenderSection(SectionPos.asLong($$13 + $$11, $$8, $$14 + $$12));
                    if ($$15 == null || !this.isInViewDistance($$3, $$15.getSectionNode())) continue;
                    Direction $$16 = $$7 ? Direction.UP : Direction.DOWN;
                    Node $$17 = new Node($$15, $$16, 0);
                    $$17.setDirections($$17.directions, $$16);
                    if ($$13 > 0) {
                        $$17.setDirections($$17.directions, Direction.EAST);
                    } else if ($$13 < 0) {
                        $$17.setDirections($$17.directions, Direction.WEST);
                    }
                    if ($$14 > 0) {
                        $$17.setDirections($$17.directions, Direction.SOUTH);
                    } else if ($$14 < 0) {
                        $$17.setDirections($$17.directions, Direction.NORTH);
                    }
                    $$10.add($$17);
                }
            }
            $$10.sort(Comparator.comparingDouble(p_392553_ -> $$2.distSqr(SectionPos.of(p_392553_.section.getSectionNode()).center())));
            p_294801_.addAll($$10);
        } else {
            p_294801_.add(new Node($$5, null, 0));
        }
    }

    private void runUpdates(GraphStorage p_295507_, Vec3 p_294343_, Queue<Node> p_295598_, boolean p_295668_, Consumer<SectionRenderDispatcher.RenderSection> p_295393_, LongOpenHashSet p_366468_) {
        SectionPos $$6 = SectionPos.of(p_294343_);
        long $$7 = $$6.asLong();
        BlockPos $$8 = $$6.center();
        while (!p_295598_.isEmpty()) {
            long $$11;
            Node $$9 = p_295598_.poll();
            SectionRenderDispatcher.RenderSection $$10 = $$9.section;
            if (!p_366468_.contains($$9.section.getSectionNode())) {
                if (p_295507_.sectionTree.add($$9.section)) {
                    p_295393_.accept($$9.section);
                }
            } else {
                $$9.section.sectionMesh.compareAndSet(CompiledSectionMesh.UNCOMPILED, CompiledSectionMesh.EMPTY);
            }
            boolean $$12 = Math.abs(SectionPos.x($$11 = $$10.getSectionNode()) - $$6.x()) > MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE || Math.abs(SectionPos.y($$11) - $$6.y()) > MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE || Math.abs(SectionPos.z($$11) - $$6.z()) > MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE;
            for (Direction $$13 : DIRECTIONS) {
                Node $$29;
                SectionRenderDispatcher.RenderSection $$14 = this.getRelativeFrom($$7, $$10, $$13);
                if ($$14 == null || p_295668_ && $$9.hasDirection($$13.getOpposite())) continue;
                if (p_295668_ && $$9.hasSourceDirections()) {
                    SectionMesh $$15 = $$10.getSectionMesh();
                    boolean $$16 = false;
                    for (int $$17 = 0; $$17 < DIRECTIONS.length; ++$$17) {
                        if (!$$9.hasSourceDirection($$17) || !$$15.facesCanSeeEachother(DIRECTIONS[$$17].getOpposite(), $$13)) continue;
                        $$16 = true;
                        break;
                    }
                    if (!$$16) continue;
                }
                if (p_295668_ && $$12) {
                    boolean $$22;
                    boolean $$21;
                    int $$18 = SectionPos.sectionToBlockCoord(SectionPos.x($$11));
                    int $$19 = SectionPos.sectionToBlockCoord(SectionPos.y($$11));
                    int $$20 = SectionPos.sectionToBlockCoord(SectionPos.z($$11));
                    boolean bl = $$13.getAxis() == Direction.Axis.X ? $$8.getX() > $$18 : ($$21 = $$8.getX() < $$18);
                    boolean bl2 = $$13.getAxis() == Direction.Axis.Y ? $$8.getY() > $$19 : ($$22 = $$8.getY() < $$19);
                    boolean $$23 = $$13.getAxis() == Direction.Axis.Z ? $$8.getZ() > $$20 : $$8.getZ() < $$20;
                    Vector3d $$24 = new Vector3d((double)($$18 + ($$21 ? 16 : 0)), (double)($$19 + ($$22 ? 16 : 0)), (double)($$20 + ($$23 ? 16 : 0)));
                    Vector3d $$25 = new Vector3d(p_294343_.x, p_294343_.y, p_294343_.z).sub((Vector3dc)$$24).normalize().mul(CEILED_SECTION_DIAGONAL);
                    boolean $$26 = true;
                    while ($$24.distanceSquared(p_294343_.x, p_294343_.y, p_294343_.z) > 3600.0) {
                        $$24.add((Vector3dc)$$25);
                        LevelHeightAccessor $$27 = this.viewArea.getLevelHeightAccessor();
                        if ($$24.y > (double)$$27.getMaxY() || $$24.y < (double)$$27.getMinY()) break;
                        SectionRenderDispatcher.RenderSection $$28 = this.viewArea.getRenderSectionAt(BlockPos.containing($$24.x, $$24.y, $$24.z));
                        if ($$28 != null && p_295507_.sectionToNodeMap.get($$28) != null) continue;
                        $$26 = false;
                        break;
                    }
                    if (!$$26) continue;
                }
                if (($$29 = p_295507_.sectionToNodeMap.get($$14)) != null) {
                    $$29.addSourceDirection($$13);
                    continue;
                }
                Node $$30 = new Node($$14, $$13, $$9.step + 1);
                $$30.setDirections($$9.directions, $$13);
                if ($$14.hasAllNeighbors()) {
                    p_295598_.add($$30);
                    p_295507_.sectionToNodeMap.put($$14, $$30);
                    continue;
                }
                if (!this.isInViewDistance($$7, $$14.getSectionNode())) continue;
                p_295507_.sectionToNodeMap.put($$14, $$30);
                long $$31 = SectionPos.sectionToChunk($$14.getSectionNode());
                ((List)p_295507_.chunksWaitingForNeighbors.computeIfAbsent($$31, p_294377_ -> new ArrayList())).add($$14);
            }
        }
    }

    private boolean isInViewDistance(long p_366544_, long p_366485_) {
        return ChunkTrackingView.isInViewDistance(SectionPos.x(p_366544_), SectionPos.z(p_366544_), this.viewArea.getViewDistance(), SectionPos.x(p_366485_), SectionPos.z(p_366485_));
    }

    @Nullable
    private SectionRenderDispatcher.RenderSection getRelativeFrom(long p_366669_, SectionRenderDispatcher.RenderSection p_295211_, Direction p_294491_) {
        long $$3 = p_295211_.getNeighborSectionNode(p_294491_);
        if (!this.isInViewDistance(p_366669_, $$3)) {
            return null;
        }
        if (Mth.abs(SectionPos.y(p_366669_) - SectionPos.y($$3)) > this.viewArea.getViewDistance()) {
            return null;
        }
        return this.viewArea.getRenderSection($$3);
    }

    @Nullable
    @VisibleForDebug
    public Node getNode(SectionRenderDispatcher.RenderSection p_296364_) {
        return this.currentGraph.get().storage.sectionToNodeMap.get(p_296364_);
    }

    public Octree getOctree() {
        return this.currentGraph.get().storage.sectionTree;
    }

    record GraphState(GraphStorage storage, GraphEvents events) {
        GraphState(ViewArea p_366764_) {
            this(new GraphStorage(p_366764_), new GraphEvents());
        }
    }

    static class GraphStorage {
        public final SectionToNodeMap sectionToNodeMap;
        public final Octree sectionTree;
        public final Long2ObjectMap<List<SectionRenderDispatcher.RenderSection>> chunksWaitingForNeighbors;

        public GraphStorage(ViewArea p_366828_) {
            this.sectionToNodeMap = new SectionToNodeMap(p_366828_.sections.length);
            this.sectionTree = new Octree(p_366828_.getCameraSectionPos(), p_366828_.getViewDistance(), p_366828_.sectionGridSizeY, p_366828_.level.getMinY());
            this.chunksWaitingForNeighbors = new Long2ObjectOpenHashMap();
        }
    }

    record GraphEvents(LongSet chunksWhichReceivedNeighbors, BlockingQueue<SectionRenderDispatcher.RenderSection> sectionsToPropagateFrom) {
        GraphEvents() {
            this((LongSet)new LongOpenHashSet(), new LinkedBlockingQueue<SectionRenderDispatcher.RenderSection>());
        }
    }

    static class SectionToNodeMap {
        private final Node[] nodes;

        SectionToNodeMap(int p_296136_) {
            this.nodes = new Node[p_296136_];
        }

        public void put(SectionRenderDispatcher.RenderSection p_295644_, Node p_295953_) {
            this.nodes[p_295644_.index] = p_295953_;
        }

        @Nullable
        public Node get(SectionRenderDispatcher.RenderSection p_295721_) {
            int $$1 = p_295721_.index;
            if ($$1 < 0 || $$1 >= this.nodes.length) {
                return null;
            }
            return this.nodes[$$1];
        }
    }

    @VisibleForDebug
    public static class Node {
        @VisibleForDebug
        protected final SectionRenderDispatcher.RenderSection section;
        private byte sourceDirections;
        byte directions;
        @VisibleForDebug
        public final int step;

        Node(SectionRenderDispatcher.RenderSection p_295110_, @Nullable Direction p_295920_, int p_295951_) {
            this.section = p_295110_;
            if (p_295920_ != null) {
                this.addSourceDirection(p_295920_);
            }
            this.step = p_295951_;
        }

        void setDirections(byte p_295029_, Direction p_296033_) {
            this.directions = (byte)(this.directions | (p_295029_ | 1 << p_296033_.ordinal()));
        }

        boolean hasDirection(Direction p_294996_) {
            return (this.directions & 1 << p_294996_.ordinal()) > 0;
        }

        void addSourceDirection(Direction p_295444_) {
            this.sourceDirections = (byte)(this.sourceDirections | (this.sourceDirections | 1 << p_295444_.ordinal()));
        }

        @VisibleForDebug
        public boolean hasSourceDirection(int p_294302_) {
            return (this.sourceDirections & 1 << p_294302_) > 0;
        }

        boolean hasSourceDirections() {
            return this.sourceDirections != 0;
        }

        public int hashCode() {
            return Long.hashCode(this.section.getSectionNode());
        }

        public boolean equals(Object p_295498_) {
            if (!(p_295498_ instanceof Node)) {
                return false;
            }
            Node $$1 = (Node)p_295498_;
            return this.section.getSectionNode() == $$1.section.getSectionNode();
        }
    }
}

