/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.RenderTargetDescriptor;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.shaders.UniformType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.PostChainConfig;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class PostChain
implements AutoCloseable {
    public static final ResourceLocation MAIN_TARGET_ID = ResourceLocation.withDefaultNamespace("main");
    private final List<PostPass> passes;
    private final Map<ResourceLocation, PostChainConfig.InternalTarget> internalTargets;
    private final Set<ResourceLocation> externalTargets;
    private final Map<ResourceLocation, RenderTarget> persistentTargets = new HashMap<ResourceLocation, RenderTarget>();
    private final CachedOrthoProjectionMatrixBuffer projectionMatrixBuffer;

    private PostChain(List<PostPass> p_364536_, Map<ResourceLocation, PostChainConfig.InternalTarget> p_361479_, Set<ResourceLocation> p_361607_, CachedOrthoProjectionMatrixBuffer p_418200_) {
        this.passes = p_364536_;
        this.internalTargets = p_361479_;
        this.externalTargets = p_361607_;
        this.projectionMatrixBuffer = p_418200_;
    }

    public static PostChain load(PostChainConfig p_366777_, TextureManager p_110034_, Set<ResourceLocation> p_362436_, ResourceLocation p_405015_, CachedOrthoProjectionMatrixBuffer p_418231_) throws ShaderManager.CompilationException {
        Stream $$5 = p_366777_.passes().stream().flatMap(PostChainConfig.Pass::referencedTargets);
        Set<ResourceLocation> $$6 = $$5.filter(p_359202_ -> !p_366777_.internalTargets().containsKey(p_359202_)).collect(Collectors.toSet());
        Sets.SetView $$7 = Sets.difference($$6, p_362436_);
        if (!$$7.isEmpty()) {
            throw new ShaderManager.CompilationException("Referenced external targets are not available in this context: " + String.valueOf($$7));
        }
        ImmutableList.Builder $$8 = ImmutableList.builder();
        for (int $$9 = 0; $$9 < p_366777_.passes().size(); ++$$9) {
            PostChainConfig.Pass $$10 = p_366777_.passes().get($$9);
            $$8.add((Object)PostChain.createPass(p_110034_, $$10, p_405015_.withSuffix("/" + $$9)));
        }
        return new PostChain((List<PostPass>)$$8.build(), p_366777_.internalTargets(), $$6, p_418231_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PostPass createPass(TextureManager p_364641_, PostChainConfig.Pass p_361826_, ResourceLocation p_405738_) throws ShaderManager.CompilationException {
        RenderPipeline.Builder $$3 = RenderPipeline.builder(RenderPipelines.POST_PROCESSING_SNIPPET).withFragmentShader(p_361826_.fragmentShaderId()).withVertexShader(p_361826_.vertexShaderId()).withLocation(p_405738_);
        for (PostChainConfig.Input $$4 : p_361826_.inputs()) {
            $$3.withSampler($$4.samplerName() + "Sampler");
        }
        $$3.withUniform("SamplerInfo", UniformType.UNIFORM_BUFFER);
        for (String $$5 : p_361826_.uniforms().keySet()) {
            $$3.withUniform($$5, UniformType.UNIFORM_BUFFER);
        }
        RenderPipeline $$6 = $$3.build();
        ArrayList<PostPass.Input> $$7 = new ArrayList<PostPass.Input>();
        Iterator<PostChainConfig.Input> iterator = p_361826_.inputs().iterator();
        block9: while (true) {
            PostChainConfig.Input input;
            if (!iterator.hasNext()) {
                return new PostPass($$6, p_361826_.outputTarget(), p_361826_.uniforms(), $$7);
            }
            PostChainConfig.Input $$8 = iterator.next();
            Objects.requireNonNull($$8);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PostChainConfig.TextureInput.class, PostChainConfig.TargetInput.class}, (Object)input, n)) {
                case 0: {
                    int n2;
                    Object object;
                    PostChainConfig.TextureInput textureInput = (PostChainConfig.TextureInput)input;
                    Object $$9 = object = textureInput.samplerName();
                    Object $$10 = object = textureInput.location();
                    int $$11 = n2 = textureInput.width();
                    int $$12 = n2 = textureInput.height();
                    int $$13 = n2 = (int)(textureInput.bilinear() ? 1 : 0);
                    AbstractTexture $$14 = p_364641_.getTexture(((ResourceLocation)$$10).withPath(p_359199_ -> "textures/effect/" + p_359199_ + ".png"));
                    $$14.setFilter($$13 != 0, false);
                    $$7.add(new PostPass.TextureInput((String)$$9, $$14, $$11, $$12));
                    continue block9;
                }
                case 1: {
                    Object object = (PostChainConfig.TargetInput)input;
                    try {
                        boolean bl;
                        Object object2 = ((PostChainConfig.TargetInput)object).samplerName();
                        String $$15 = object2;
                        Object $$16 = object2 = ((PostChainConfig.TargetInput)object).targetId();
                        boolean $$17 = bl = ((PostChainConfig.TargetInput)object).useDepthBuffer();
                        boolean $$18 = bl = ((PostChainConfig.TargetInput)object).bilinear();
                        $$7.add(new PostPass.TargetInput($$15, (ResourceLocation)$$16, $$17, $$18));
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    continue block9;
                }
            }
            break;
        }
        throw new MatchException(null, null);
    }

    public void addToFrame(FrameGraphBuilder p_362523_, int p_361423_, int p_362735_, TargetBundle p_361871_) {
        GpuBufferSlice $$4 = this.projectionMatrixBuffer.getBuffer(p_361423_, p_362735_);
        HashMap<ResourceLocation, ResourceHandle<RenderTarget>> $$5 = new HashMap<ResourceLocation, ResourceHandle<RenderTarget>>(this.internalTargets.size() + this.externalTargets.size());
        for (ResourceLocation resourceLocation : this.externalTargets) {
            $$5.put(resourceLocation, p_361871_.getOrThrow(resourceLocation));
        }
        for (Map.Entry entry : this.internalTargets.entrySet()) {
            ResourceLocation $$8 = (ResourceLocation)entry.getKey();
            PostChainConfig.InternalTarget $$9 = (PostChainConfig.InternalTarget)entry.getValue();
            RenderTargetDescriptor $$10 = new RenderTargetDescriptor($$9.width().orElse(p_361423_), $$9.height().orElse(p_362735_), true, $$9.clearColor());
            if ($$9.persistent()) {
                RenderTarget $$11 = this.getOrCreatePersistentTarget($$8, $$10);
                $$5.put($$8, p_362523_.importExternal($$8.toString(), $$11));
                continue;
            }
            $$5.put($$8, p_362523_.createInternal($$8.toString(), $$10));
        }
        for (PostPass postPass : this.passes) {
            postPass.addToFrame(p_362523_, $$5, $$4);
        }
        for (ResourceLocation resourceLocation : this.externalTargets) {
            p_361871_.replace(resourceLocation, (ResourceHandle)$$5.get(resourceLocation));
        }
    }

    @Deprecated
    public void process(RenderTarget p_361528_, GraphicsResourceAllocator p_361187_) {
        FrameGraphBuilder $$2 = new FrameGraphBuilder();
        TargetBundle $$3 = TargetBundle.of(MAIN_TARGET_ID, $$2.importExternal("main", p_361528_));
        this.addToFrame($$2, p_361528_.width, p_361528_.height, $$3);
        $$2.execute(p_361187_);
    }

    private RenderTarget getOrCreatePersistentTarget(ResourceLocation p_418113_, RenderTargetDescriptor p_418259_) {
        RenderTarget $$2 = this.persistentTargets.get(p_418113_);
        if ($$2 == null || $$2.width != p_418259_.width() || $$2.height != p_418259_.height()) {
            if ($$2 != null) {
                $$2.destroyBuffers();
            }
            $$2 = p_418259_.allocate();
            p_418259_.prepare($$2);
            this.persistentTargets.put(p_418113_, $$2);
        }
        return $$2;
    }

    @Override
    public void close() {
        this.persistentTargets.values().forEach(RenderTarget::destroyBuffers);
        this.persistentTargets.clear();
        for (PostPass $$0 : this.passes) {
            $$0.close();
        }
    }

    public static interface TargetBundle {
        public static TargetBundle of(final ResourceLocation p_362084_, final ResourceHandle<RenderTarget> p_365173_) {
            return new TargetBundle(){
                private ResourceHandle<RenderTarget> handle;
                {
                    this.handle = p_365173_;
                }

                @Override
                public void replace(ResourceLocation p_363133_, ResourceHandle<RenderTarget> p_360603_) {
                    if (!p_363133_.equals(p_362084_)) {
                        throw new IllegalArgumentException("No target with id " + String.valueOf(p_363133_));
                    }
                    this.handle = p_360603_;
                }

                @Override
                @Nullable
                public ResourceHandle<RenderTarget> get(ResourceLocation p_360954_) {
                    return p_360954_.equals(p_362084_) ? this.handle : null;
                }
            };
        }

        public void replace(ResourceLocation var1, ResourceHandle<RenderTarget> var2);

        @Nullable
        public ResourceHandle<RenderTarget> get(ResourceLocation var1);

        default public ResourceHandle<RenderTarget> getOrThrow(ResourceLocation p_360758_) {
            ResourceHandle<RenderTarget> $$1 = this.get(p_360758_);
            if ($$1 == null) {
                throw new IllegalArgumentException("Missing target with id " + String.valueOf(p_360758_));
            }
            return $$1;
        }
    }
}

