/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class Octree {
    private final Branch root;
    final BlockPos cameraSectionCenter;

    public Octree(SectionPos p_366555_, int p_366900_, int p_366696_, int p_366804_) {
        int $$4 = p_366900_ * 2 + 1;
        int $$5 = Mth.smallestEncompassingPowerOfTwo($$4);
        int $$6 = p_366900_ * 16;
        BlockPos $$7 = p_366555_.origin();
        this.cameraSectionCenter = p_366555_.center();
        int $$8 = $$7.getX() - $$6;
        int $$9 = $$8 + $$5 * 16 - 1;
        int $$10 = $$5 >= p_366696_ ? p_366804_ : $$7.getY() - $$6;
        int $$11 = $$10 + $$5 * 16 - 1;
        int $$12 = $$7.getZ() - $$6;
        int $$13 = $$12 + $$5 * 16 - 1;
        this.root = new Branch(new BoundingBox($$8, $$10, $$12, $$9, $$11, $$13));
    }

    public boolean add(SectionRenderDispatcher.RenderSection p_366660_) {
        return this.root.add(p_366660_);
    }

    public void visitNodes(OctreeVisitor p_366457_, Frustum p_366899_, int p_371758_) {
        this.root.visitNodes(p_366457_, false, p_366899_, 0, p_371758_, true);
    }

    boolean isClose(double p_371839_, double p_371388_, double p_371925_, double p_371916_, double p_371235_, double p_371502_, int p_371637_) {
        int $$7 = this.cameraSectionCenter.getX();
        int $$8 = this.cameraSectionCenter.getY();
        int $$9 = this.cameraSectionCenter.getZ();
        return (double)$$7 > p_371839_ - (double)p_371637_ && (double)$$7 < p_371916_ + (double)p_371637_ && (double)$$8 > p_371388_ - (double)p_371637_ && (double)$$8 < p_371235_ + (double)p_371637_ && (double)$$9 > p_371925_ - (double)p_371637_ && (double)$$9 < p_371502_ + (double)p_371637_;
    }

    class Branch
    implements Node {
        private final Node[] nodes = new Node[8];
        private final BoundingBox boundingBox;
        private final int bbCenterX;
        private final int bbCenterY;
        private final int bbCenterZ;
        private final AxisSorting sorting;
        private final boolean cameraXDiffNegative;
        private final boolean cameraYDiffNegative;
        private final boolean cameraZDiffNegative;

        public Branch(BoundingBox p_366797_) {
            this.boundingBox = p_366797_;
            this.bbCenterX = this.boundingBox.minX() + this.boundingBox.getXSpan() / 2;
            this.bbCenterY = this.boundingBox.minY() + this.boundingBox.getYSpan() / 2;
            this.bbCenterZ = this.boundingBox.minZ() + this.boundingBox.getZSpan() / 2;
            int $$1 = Octree.this.cameraSectionCenter.getX() - this.bbCenterX;
            int $$2 = Octree.this.cameraSectionCenter.getY() - this.bbCenterY;
            int $$3 = Octree.this.cameraSectionCenter.getZ() - this.bbCenterZ;
            this.sorting = AxisSorting.getAxisSorting(Math.abs($$1), Math.abs($$2), Math.abs($$3));
            this.cameraXDiffNegative = $$1 < 0;
            this.cameraYDiffNegative = $$2 < 0;
            this.cameraZDiffNegative = $$3 < 0;
        }

        public boolean add(SectionRenderDispatcher.RenderSection p_366697_) {
            long $$1 = p_366697_.getSectionNode();
            boolean $$2 = SectionPos.sectionToBlockCoord(SectionPos.x($$1)) - this.bbCenterX < 0;
            boolean $$3 = SectionPos.sectionToBlockCoord(SectionPos.y($$1)) - this.bbCenterY < 0;
            boolean $$4 = SectionPos.sectionToBlockCoord(SectionPos.z($$1)) - this.bbCenterZ < 0;
            boolean $$5 = $$2 != this.cameraXDiffNegative;
            boolean $$6 = $$3 != this.cameraYDiffNegative;
            boolean $$7 = $$4 != this.cameraZDiffNegative;
            int $$8 = Branch.getNodeIndex(this.sorting, $$5, $$6, $$7);
            if (this.areChildrenLeaves()) {
                boolean $$9 = this.nodes[$$8] != null;
                this.nodes[$$8] = new Leaf(p_366697_);
                return !$$9;
            }
            if (this.nodes[$$8] != null) {
                Branch $$10 = (Branch)this.nodes[$$8];
                return $$10.add(p_366697_);
            }
            BoundingBox $$11 = this.createChildBoundingBox($$2, $$3, $$4);
            Branch $$12 = new Branch($$11);
            this.nodes[$$8] = $$12;
            return $$12.add(p_366697_);
        }

        private static int getNodeIndex(AxisSorting p_366829_, boolean p_366579_, boolean p_366439_, boolean p_366724_) {
            int $$4 = 0;
            if (p_366579_) {
                $$4 += p_366829_.xShift;
            }
            if (p_366439_) {
                $$4 += p_366829_.yShift;
            }
            if (p_366724_) {
                $$4 += p_366829_.zShift;
            }
            return $$4;
        }

        private boolean areChildrenLeaves() {
            return this.boundingBox.getXSpan() == 32;
        }

        private BoundingBox createChildBoundingBox(boolean p_366433_, boolean p_366456_, boolean p_366831_) {
            int $$14;
            int $$13;
            int $$10;
            int $$9;
            int $$6;
            int $$5;
            if (p_366433_) {
                int $$3 = this.boundingBox.minX();
                int $$4 = this.bbCenterX - 1;
            } else {
                $$5 = this.bbCenterX;
                $$6 = this.boundingBox.maxX();
            }
            if (p_366456_) {
                int $$7 = this.boundingBox.minY();
                int $$8 = this.bbCenterY - 1;
            } else {
                $$9 = this.bbCenterY;
                $$10 = this.boundingBox.maxY();
            }
            if (p_366831_) {
                int $$11 = this.boundingBox.minZ();
                int $$12 = this.bbCenterZ - 1;
            } else {
                $$13 = this.bbCenterZ;
                $$14 = this.boundingBox.maxZ();
            }
            return new BoundingBox($$5, $$9, $$13, $$6, $$10, $$14);
        }

        @Override
        public void visitNodes(OctreeVisitor p_366879_, boolean p_366787_, Frustum p_366666_, int p_366756_, int p_371411_, boolean p_371398_) {
            boolean $$6 = p_366787_;
            if (!p_366787_) {
                int $$7 = p_366666_.cubeInFrustum(this.boundingBox);
                p_366787_ = $$7 == -2;
                boolean bl = $$6 = $$7 == -2 || $$7 == -1;
            }
            if ($$6) {
                p_371398_ = p_371398_ && Octree.this.isClose(this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ(), p_371411_);
                p_366879_.visit(this, p_366787_, p_366756_, p_371398_);
                for (Node $$8 : this.nodes) {
                    if ($$8 == null) continue;
                    $$8.visitNodes(p_366879_, p_366787_, p_366666_, p_366756_ + 1, p_371411_, p_371398_);
                }
            }
        }

        @Override
        @Nullable
        public SectionRenderDispatcher.RenderSection getSection() {
            return null;
        }

        @Override
        public AABB getAABB() {
            return new AABB(this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() + 1, this.boundingBox.maxY() + 1, this.boundingBox.maxZ() + 1);
        }
    }

    @FunctionalInterface
    public static interface OctreeVisitor {
        public void visit(Node var1, boolean var2, int var3, boolean var4);
    }

    static enum AxisSorting {
        XYZ(4, 2, 1),
        XZY(4, 1, 2),
        YXZ(2, 4, 1),
        YZX(1, 4, 2),
        ZXY(2, 1, 4),
        ZYX(1, 2, 4);

        final int xShift;
        final int yShift;
        final int zShift;

        private AxisSorting(int p_366534_, int p_366465_, int p_366528_) {
            this.xShift = p_366534_;
            this.yShift = p_366465_;
            this.zShift = p_366528_;
        }

        public static AxisSorting getAxisSorting(int p_366469_, int p_366599_, int p_366616_) {
            if (p_366469_ > p_366599_ && p_366469_ > p_366616_) {
                if (p_366599_ > p_366616_) {
                    return XYZ;
                }
                return XZY;
            }
            if (p_366599_ > p_366469_ && p_366599_ > p_366616_) {
                if (p_366469_ > p_366616_) {
                    return YXZ;
                }
                return YZX;
            }
            if (p_366469_ > p_366599_) {
                return ZXY;
            }
            return ZYX;
        }
    }

    public static interface Node {
        public void visitNodes(OctreeVisitor var1, boolean var2, Frustum var3, int var4, int var5, boolean var6);

        @Nullable
        public SectionRenderDispatcher.RenderSection getSection();

        public AABB getAABB();
    }

    final class Leaf
    implements Node {
        private final SectionRenderDispatcher.RenderSection section;

        Leaf(SectionRenderDispatcher.RenderSection p_366798_) {
            this.section = p_366798_;
        }

        @Override
        public void visitNodes(OctreeVisitor p_366617_, boolean p_366572_, Frustum p_366767_, int p_366729_, int p_371551_, boolean p_371193_) {
            AABB $$6 = this.section.getBoundingBox();
            if (p_366572_ || p_366767_.isVisible(this.getSection().getBoundingBox())) {
                p_371193_ = p_371193_ && Octree.this.isClose($$6.minX, $$6.minY, $$6.minZ, $$6.maxX, $$6.maxY, $$6.maxZ, p_371551_);
                p_366617_.visit(this, p_366572_, p_366729_, p_371193_);
            }
        }

        @Override
        public SectionRenderDispatcher.RenderSection getSection() {
            return this.section;
        }

        @Override
        public AABB getAABB() {
            return this.section.getBoundingBox();
        }
    }
}

