/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.client.resources.MapTextureManager;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class MapRenderer {
    private static final float MAP_Z_OFFSET = -0.01f;
    private static final float DECORATION_Z_OFFSET = -0.001f;
    public static final int WIDTH = 128;
    public static final int HEIGHT = 128;
    private final MapTextureManager mapTextureManager;
    private final MapDecorationTextureManager decorationTextures;

    public MapRenderer(MapDecorationTextureManager p_364983_, MapTextureManager p_360823_) {
        this.decorationTextures = p_364983_;
        this.mapTextureManager = p_360823_;
    }

    public void render(MapRenderState p_360365_, PoseStack p_362483_, MultiBufferSource p_363581_, boolean p_362262_, int p_364872_) {
        Matrix4f $$5 = p_362483_.last().pose();
        VertexConsumer $$6 = p_363581_.getBuffer(RenderType.text(p_360365_.texture));
        $$6.addVertex($$5, 0.0f, 128.0f, -0.01f).setColor(-1).setUv(0.0f, 1.0f).setLight(p_364872_);
        $$6.addVertex($$5, 128.0f, 128.0f, -0.01f).setColor(-1).setUv(1.0f, 1.0f).setLight(p_364872_);
        $$6.addVertex($$5, 128.0f, 0.0f, -0.01f).setColor(-1).setUv(1.0f, 0.0f).setLight(p_364872_);
        $$6.addVertex($$5, 0.0f, 0.0f, -0.01f).setColor(-1).setUv(0.0f, 0.0f).setLight(p_364872_);
        int $$7 = 0;
        for (MapRenderState.MapDecorationRenderState $$8 : p_360365_.decorations) {
            if (p_362262_ && !$$8.renderOnFrame) continue;
            p_362483_.pushPose();
            p_362483_.translate((float)$$8.x / 2.0f + 64.0f, (float)$$8.y / 2.0f + 64.0f, -0.02f);
            p_362483_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)($$8.rot * 360) / 16.0f));
            p_362483_.scale(4.0f, 4.0f, 3.0f);
            p_362483_.translate(-0.125f, 0.125f, 0.0f);
            Matrix4f $$9 = p_362483_.last().pose();
            TextureAtlasSprite $$10 = $$8.atlasSprite;
            if ($$10 != null) {
                VertexConsumer $$11 = p_363581_.getBuffer(RenderType.text($$10.atlasLocation()));
                $$11.addVertex($$9, -1.0f, 1.0f, (float)$$7 * -0.001f).setColor(-1).setUv($$10.getU0(), $$10.getV0()).setLight(p_364872_);
                $$11.addVertex($$9, 1.0f, 1.0f, (float)$$7 * -0.001f).setColor(-1).setUv($$10.getU1(), $$10.getV0()).setLight(p_364872_);
                $$11.addVertex($$9, 1.0f, -1.0f, (float)$$7 * -0.001f).setColor(-1).setUv($$10.getU1(), $$10.getV1()).setLight(p_364872_);
                $$11.addVertex($$9, -1.0f, -1.0f, (float)$$7 * -0.001f).setColor(-1).setUv($$10.getU0(), $$10.getV1()).setLight(p_364872_);
                p_362483_.popPose();
            }
            if ($$8.name != null) {
                Font $$12 = Minecraft.getInstance().font;
                float $$13 = $$12.width($$8.name);
                float f = 25.0f / $$13;
                Objects.requireNonNull($$12);
                float $$14 = Mth.clamp(f, 0.0f, 6.0f / 9.0f);
                p_362483_.pushPose();
                p_362483_.translate((float)$$8.x / 2.0f + 64.0f - $$13 * $$14 / 2.0f, (float)$$8.y / 2.0f + 64.0f + 4.0f, -0.025f);
                p_362483_.scale($$14, $$14, -1.0f);
                p_362483_.translate(0.0f, 0.0f, 0.1f);
                $$12.drawInBatch($$8.name, 0.0f, 0.0f, -1, false, p_362483_.last().pose(), p_363581_, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, p_364872_);
                p_362483_.popPose();
            }
            ++$$7;
        }
    }

    public void extractRenderState(MapId p_361383_, MapItemSavedData p_363500_, MapRenderState p_364922_) {
        p_364922_.texture = this.mapTextureManager.prepareMapTexture(p_361383_, p_363500_);
        p_364922_.decorations.clear();
        for (MapDecoration $$3 : p_363500_.getDecorations()) {
            p_364922_.decorations.add(this.extractDecorationRenderState($$3));
        }
    }

    private MapRenderState.MapDecorationRenderState extractDecorationRenderState(MapDecoration p_364175_) {
        MapRenderState.MapDecorationRenderState $$1 = new MapRenderState.MapDecorationRenderState();
        $$1.atlasSprite = this.decorationTextures.get(p_364175_);
        $$1.x = p_364175_.x();
        $$1.y = p_364175_.y();
        $$1.rot = p_364175_.rot();
        $$1.name = p_364175_.name().orElse(null);
        $$1.renderOnFrame = p_364175_.renderOnFrame();
        return $$1;
    }
}

