/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.RenderTargetDescriptor;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CloudRenderer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionOcclusionGraph;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SkyRenderer;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.WeatherEffectRenderer;
import net.minecraft.client.renderer.WorldBorderRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import net.minecraft.client.renderer.chunk.ChunkSectionsToRender;
import net.minecraft.client.renderer.chunk.CompiledSectionMesh;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionBuffers;
import net.minecraft.client.renderer.chunk.SectionMesh;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.chunk.TranslucencyPointOfView;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.slf4j.Logger;

public class LevelRenderer
implements ResourceManagerReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TRANSPARENCY_POST_CHAIN_ID = ResourceLocation.withDefaultNamespace("transparency");
    private static final ResourceLocation ENTITY_OUTLINE_POST_CHAIN_ID = ResourceLocation.withDefaultNamespace("entity_outline");
    public static final int SECTION_SIZE = 16;
    public static final int HALF_SECTION_SIZE = 8;
    public static final int NEARBY_SECTION_DISTANCE_IN_BLOCKS = 32;
    private static final int MINIMUM_TRANSPARENT_SORT_COUNT = 15;
    private static final Comparator<Entity> ENTITY_COMPARATOR = Comparator.comparing(p_428750_ -> p_428750_.getType().hashCode());
    private final Minecraft minecraft;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final RenderBuffers renderBuffers;
    private final SkyRenderer skyRenderer = new SkyRenderer();
    private final CloudRenderer cloudRenderer = new CloudRenderer();
    private final WorldBorderRenderer worldBorderRenderer = new WorldBorderRenderer();
    private final WeatherEffectRenderer weatherEffectRenderer = new WeatherEffectRenderer();
    @Nullable
    private ClientLevel level;
    private final SectionOcclusionGraph sectionOcclusionGraph = new SectionOcclusionGraph();
    private final ObjectArrayList<SectionRenderDispatcher.RenderSection> visibleSections = new ObjectArrayList(10000);
    private final ObjectArrayList<SectionRenderDispatcher.RenderSection> nearbyVisibleSections = new ObjectArrayList(50);
    @Nullable
    private ViewArea viewArea;
    private int ticks;
    private final Int2ObjectMap<BlockDestructionProgress> destroyingBlocks = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = new Long2ObjectOpenHashMap();
    @Nullable
    private RenderTarget entityOutlineTarget;
    private final LevelTargetBundle targets = new LevelTargetBundle();
    private int lastCameraSectionX = Integer.MIN_VALUE;
    private int lastCameraSectionY = Integer.MIN_VALUE;
    private int lastCameraSectionZ = Integer.MIN_VALUE;
    private double prevCamX = Double.MIN_VALUE;
    private double prevCamY = Double.MIN_VALUE;
    private double prevCamZ = Double.MIN_VALUE;
    private double prevCamRotX = Double.MIN_VALUE;
    private double prevCamRotY = Double.MIN_VALUE;
    @Nullable
    private SectionRenderDispatcher sectionRenderDispatcher;
    private int lastViewDistance = -1;
    private final List<Entity> visibleEntities = new ArrayList<Entity>();
    private int visibleEntityCount;
    private Frustum cullingFrustum;
    private boolean captureFrustum;
    @Nullable
    private Frustum capturedFrustum;
    @Nullable
    private BlockPos lastTranslucentSortBlockPos;
    private int translucencyResortIterationIndex;

    public LevelRenderer(Minecraft p_234245_, EntityRenderDispatcher p_234246_, BlockEntityRenderDispatcher p_234247_, RenderBuffers p_234248_) {
        this.minecraft = p_234245_;
        this.entityRenderDispatcher = p_234246_;
        this.blockEntityRenderDispatcher = p_234247_;
        this.renderBuffers = p_234248_;
    }

    public void tickParticles(Camera p_363405_) {
        this.weatherEffectRenderer.tickRainParticles(this.minecraft.level, p_363405_, this.ticks, this.minecraft.options.particles().get());
    }

    @Override
    public void close() {
        if (this.entityOutlineTarget != null) {
            this.entityOutlineTarget.destroyBuffers();
        }
        this.skyRenderer.close();
        this.cloudRenderer.close();
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_109513_) {
        this.initOutline();
    }

    public void initOutline() {
        if (this.entityOutlineTarget != null) {
            this.entityOutlineTarget.destroyBuffers();
        }
        this.entityOutlineTarget = new TextureTarget("Entity Outline", this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight(), true);
    }

    @Nullable
    private PostChain getTransparencyChain() {
        if (!Minecraft.useShaderTransparency()) {
            return null;
        }
        PostChain $$0 = this.minecraft.getShaderManager().getPostChain(TRANSPARENCY_POST_CHAIN_ID, LevelTargetBundle.SORTING_TARGETS);
        if ($$0 == null) {
            this.minecraft.options.graphicsMode().set(GraphicsStatus.FANCY);
            this.minecraft.options.save();
        }
        return $$0;
    }

    public void doEntityOutline() {
        if (this.shouldShowEntityOutlines()) {
            this.entityOutlineTarget.blitAndBlendToTexture(this.minecraft.getMainRenderTarget().getColorTextureView());
        }
    }

    protected boolean shouldShowEntityOutlines() {
        return !this.minecraft.gameRenderer.isPanoramicMode() && this.entityOutlineTarget != null && this.minecraft.player != null;
    }

    public void setLevel(@Nullable ClientLevel p_109702_) {
        this.lastCameraSectionX = Integer.MIN_VALUE;
        this.lastCameraSectionY = Integer.MIN_VALUE;
        this.lastCameraSectionZ = Integer.MIN_VALUE;
        this.entityRenderDispatcher.setLevel(p_109702_);
        this.level = p_109702_;
        if (p_109702_ != null) {
            this.allChanged();
        } else {
            if (this.viewArea != null) {
                this.viewArea.releaseAllBuffers();
                this.viewArea = null;
            }
            if (this.sectionRenderDispatcher != null) {
                this.sectionRenderDispatcher.dispose();
            }
            this.sectionRenderDispatcher = null;
            this.sectionOcclusionGraph.waitAndReset(null);
            this.clearVisibleSections();
        }
    }

    private void clearVisibleSections() {
        this.visibleSections.clear();
        this.nearbyVisibleSections.clear();
    }

    public void allChanged() {
        if (this.level == null) {
            return;
        }
        this.level.clearTintCaches();
        if (this.sectionRenderDispatcher == null) {
            this.sectionRenderDispatcher = new SectionRenderDispatcher(this.level, this, Util.backgroundExecutor(), this.renderBuffers, this.minecraft.getBlockRenderer(), this.minecraft.getBlockEntityRenderDispatcher());
        } else {
            this.sectionRenderDispatcher.setLevel(this.level);
        }
        this.cloudRenderer.markForRebuild();
        ItemBlockRenderTypes.setFancy(Minecraft.useFancyGraphics());
        this.lastViewDistance = this.minecraft.options.getEffectiveRenderDistance();
        if (this.viewArea != null) {
            this.viewArea.releaseAllBuffers();
        }
        this.sectionRenderDispatcher.clearCompileQueue();
        this.viewArea = new ViewArea(this.sectionRenderDispatcher, this.level, this.minecraft.options.getEffectiveRenderDistance(), this);
        this.sectionOcclusionGraph.waitAndReset(this.viewArea);
        this.clearVisibleSections();
        Camera $$0 = this.minecraft.gameRenderer.getMainCamera();
        this.viewArea.repositionCamera(SectionPos.of($$0.getPosition()));
    }

    public void resize(int p_109488_, int p_109489_) {
        this.needsUpdate();
        if (this.entityOutlineTarget != null) {
            this.entityOutlineTarget.resize(p_109488_, p_109489_);
        }
    }

    public String getSectionStatistics() {
        int $$0 = this.viewArea.sections.length;
        int $$1 = this.countRenderedSections();
        return String.format(Locale.ROOT, "C: %d/%d %sD: %d, %s", $$1, $$0, this.minecraft.smartCull ? "(s) " : "", this.lastViewDistance, this.sectionRenderDispatcher == null ? "null" : this.sectionRenderDispatcher.getStats());
    }

    public SectionRenderDispatcher getSectionRenderDispatcher() {
        return this.sectionRenderDispatcher;
    }

    public double getTotalSections() {
        return this.viewArea.sections.length;
    }

    public double getLastViewDistance() {
        return this.lastViewDistance;
    }

    public int countRenderedSections() {
        int $$0 = 0;
        for (SectionRenderDispatcher.RenderSection $$1 : this.visibleSections) {
            if (!$$1.getSectionMesh().hasRenderableLayers()) continue;
            ++$$0;
        }
        return $$0;
    }

    public String getEntityStatistics() {
        return "E: " + this.visibleEntityCount + "/" + this.level.getEntityCount() + ", SD: " + this.level.getServerSimulationDistance();
    }

    private void setupRender(Camera p_194339_, Frustum p_194340_, boolean p_194341_, boolean p_194342_) {
        Vec3 $$4 = p_194339_.getPosition();
        if (this.minecraft.options.getEffectiveRenderDistance() != this.lastViewDistance) {
            this.allChanged();
        }
        ProfilerFiller $$5 = Profiler.get();
        $$5.push("camera");
        int $$6 = SectionPos.posToSectionCoord($$4.x());
        int $$7 = SectionPos.posToSectionCoord($$4.y());
        int $$8 = SectionPos.posToSectionCoord($$4.z());
        if (this.lastCameraSectionX != $$6 || this.lastCameraSectionY != $$7 || this.lastCameraSectionZ != $$8) {
            this.lastCameraSectionX = $$6;
            this.lastCameraSectionY = $$7;
            this.lastCameraSectionZ = $$8;
            this.viewArea.repositionCamera(SectionPos.of($$4));
            this.worldBorderRenderer.invalidate();
        }
        this.sectionRenderDispatcher.setCameraPosition($$4);
        $$5.popPush("cull");
        double $$9 = Math.floor($$4.x / 8.0);
        double $$10 = Math.floor($$4.y / 8.0);
        double $$11 = Math.floor($$4.z / 8.0);
        if ($$9 != this.prevCamX || $$10 != this.prevCamY || $$11 != this.prevCamZ) {
            this.sectionOcclusionGraph.invalidate();
        }
        this.prevCamX = $$9;
        this.prevCamY = $$10;
        this.prevCamZ = $$11;
        $$5.popPush("update");
        if (!p_194341_) {
            boolean $$12 = this.minecraft.smartCull;
            if (p_194342_ && this.level.getBlockState(p_194339_.getBlockPosition()).isSolidRender()) {
                $$12 = false;
            }
            $$5.push("section_occlusion_graph");
            this.sectionOcclusionGraph.update($$12, p_194339_, p_194340_, (List<SectionRenderDispatcher.RenderSection>)this.visibleSections, this.level.getChunkSource().getLoadedEmptySections());
            $$5.pop();
            double $$13 = Math.floor(p_194339_.getXRot() / 2.0f);
            double $$14 = Math.floor(p_194339_.getYRot() / 2.0f);
            if (this.sectionOcclusionGraph.consumeFrustumUpdate() || $$13 != this.prevCamRotX || $$14 != this.prevCamRotY) {
                this.applyFrustum(LevelRenderer.offsetFrustum(p_194340_));
                this.prevCamRotX = $$13;
                this.prevCamRotY = $$14;
            }
        }
        $$5.pop();
    }

    public static Frustum offsetFrustum(Frustum p_296151_) {
        return new Frustum(p_296151_).offsetToFullyIncludeCameraCube(8);
    }

    private void applyFrustum(Frustum p_194355_) {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new IllegalStateException("applyFrustum called from wrong thread: " + Thread.currentThread().getName());
        }
        Profiler.get().push("apply_frustum");
        this.clearVisibleSections();
        this.sectionOcclusionGraph.addSectionsInFrustum(p_194355_, (List<SectionRenderDispatcher.RenderSection>)this.visibleSections, (List<SectionRenderDispatcher.RenderSection>)this.nearbyVisibleSections);
        Profiler.get().pop();
    }

    public void addRecentlyCompiledSection(SectionRenderDispatcher.RenderSection p_295462_) {
        this.sectionOcclusionGraph.schedulePropagationFrom(p_295462_);
    }

    public void prepareCullFrustum(Vec3 p_253766_, Matrix4f p_254341_, Matrix4f p_323487_) {
        this.cullingFrustum = new Frustum(p_254341_, p_323487_);
        this.cullingFrustum.prepare(p_253766_.x(), p_253766_.y(), p_253766_.z());
    }

    public void renderLevel(GraphicsResourceAllocator p_361796_, DeltaTracker p_348530_, boolean p_109603_, Camera p_109604_, Matrix4f p_254120_, Matrix4f p_323920_, GpuBufferSlice p_425977_, Vector4f p_425544_, boolean p_426302_) {
        Optional<Integer> $$27;
        float $$9 = p_348530_.getGameTimeDeltaPartialTick(false);
        this.blockEntityRenderDispatcher.prepare(this.level, p_109604_, this.minecraft.hitResult);
        this.entityRenderDispatcher.prepare(this.level, p_109604_, this.minecraft.crosshairPickEntity);
        final ProfilerFiller $$10 = Profiler.get();
        $$10.push("light_update_queue");
        this.level.pollLightUpdates();
        $$10.popPush("light_updates");
        this.level.getChunkSource().getLightEngine().runLightUpdates();
        Vec3 $$11 = p_109604_.getPosition();
        double $$12 = $$11.x();
        double $$13 = $$11.y();
        double $$14 = $$11.z();
        $$10.popPush("culling");
        boolean $$15 = this.capturedFrustum != null;
        Frustum $$16 = $$15 ? this.capturedFrustum : this.cullingFrustum;
        $$10.popPush("captureFrustum");
        if (this.captureFrustum) {
            this.capturedFrustum = $$15 ? new Frustum(p_254120_, p_323920_) : $$16;
            this.capturedFrustum.prepare($$12, $$13, $$14);
            this.captureFrustum = false;
        }
        $$10.popPush("cullEntities");
        boolean $$17 = this.collectVisibleEntities(p_109604_, $$16, this.visibleEntities);
        this.visibleEntityCount = this.visibleEntities.size();
        $$10.popPush("terrain_setup");
        this.setupRender(p_109604_, $$16, $$15, this.minecraft.player.isSpectator());
        $$10.popPush("compile_sections");
        this.compileSections(p_109604_);
        Matrix4fStack $$18 = RenderSystem.getModelViewStack();
        $$18.pushMatrix();
        $$18.mul((Matrix4fc)p_254120_);
        FrameGraphBuilder $$19 = new FrameGraphBuilder();
        this.targets.main = $$19.importExternal("main", this.minecraft.getMainRenderTarget());
        int $$20 = this.minecraft.getMainRenderTarget().width;
        int $$21 = this.minecraft.getMainRenderTarget().height;
        RenderTargetDescriptor $$22 = new RenderTargetDescriptor($$20, $$21, true, 0);
        PostChain $$23 = this.getTransparencyChain();
        if ($$23 != null) {
            this.targets.translucent = $$19.createInternal("translucent", $$22);
            this.targets.itemEntity = $$19.createInternal("item_entity", $$22);
            this.targets.particles = $$19.createInternal("particles", $$22);
            this.targets.weather = $$19.createInternal("weather", $$22);
            this.targets.clouds = $$19.createInternal("clouds", $$22);
        }
        if (this.entityOutlineTarget != null) {
            this.targets.entityOutline = $$19.importExternal("entity_outline", this.entityOutlineTarget);
        }
        FramePass $$24 = $$19.addPass("clear");
        this.targets.main = $$24.readsAndWrites(this.targets.main);
        $$24.executes(() -> {
            RenderTarget $$1 = this.minecraft.getMainRenderTarget();
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures($$1.getColorTexture(), ARGB.colorFromFloat(0.0f, p_409053_.x, p_409053_.y, p_409053_.z), $$1.getDepthTexture(), 1.0);
        });
        if (p_426302_) {
            this.addSkyPass($$19, p_109604_, $$9, p_425977_);
        }
        this.addMainPass($$19, $$16, p_109604_, p_254120_, p_425977_, p_109603_, $$17, p_348530_, $$10);
        PostChain $$25 = this.minecraft.getShaderManager().getPostChain(ENTITY_OUTLINE_POST_CHAIN_ID, LevelTargetBundle.OUTLINE_TARGETS);
        if ($$17 && $$25 != null) {
            $$25.addToFrame($$19, $$20, $$21, this.targets);
        }
        this.addParticlesPass($$19, p_109604_, $$9, p_425977_);
        CloudStatus $$26 = this.minecraft.options.getCloudsType();
        if ($$26 != CloudStatus.OFF && ($$27 = this.level.dimensionType().cloudHeight()).isPresent()) {
            float $$28 = (float)this.ticks + $$9;
            int $$29 = this.level.getCloudColor($$9);
            this.addCloudsPass($$19, $$26, p_109604_.getPosition(), $$28, $$29, (float)$$27.get().intValue() + 0.33f);
        }
        this.addWeatherPass($$19, p_109604_.getPosition(), $$9, p_425977_);
        if ($$23 != null) {
            $$23.addToFrame($$19, $$20, $$21, this.targets);
        }
        this.addLateDebugPass($$19, $$11, p_425977_);
        $$10.popPush("framegraph");
        $$19.execute(p_361796_, new FrameGraphBuilder.Inspector(){

            @Override
            public void beforeExecutePass(String p_363206_) {
                $$10.push(p_363206_);
            }

            @Override
            public void afterExecutePass(String p_362054_) {
                $$10.pop();
            }
        });
        this.visibleEntities.clear();
        this.targets.clear();
        $$18.popMatrix();
        $$10.pop();
    }

    private void addMainPass(FrameGraphBuilder p_361593_, Frustum p_366590_, Camera p_363453_, Matrix4f p_362420_, GpuBufferSlice p_418185_, boolean p_363964_, boolean p_362137_, DeltaTracker p_360931_, ProfilerFiller p_362234_) {
        FramePass $$9 = p_361593_.addPass("main");
        this.targets.main = $$9.readsAndWrites(this.targets.main);
        if (this.targets.translucent != null) {
            this.targets.translucent = $$9.readsAndWrites(this.targets.translucent);
        }
        if (this.targets.itemEntity != null) {
            this.targets.itemEntity = $$9.readsAndWrites(this.targets.itemEntity);
        }
        if (this.targets.weather != null) {
            this.targets.weather = $$9.readsAndWrites(this.targets.weather);
        }
        if (p_362137_ && this.targets.entityOutline != null) {
            this.targets.entityOutline = $$9.readsAndWrites(this.targets.entityOutline);
        }
        ResourceHandle<RenderTarget> $$10 = this.targets.main;
        ResourceHandle<RenderTarget> $$11 = this.targets.translucent;
        ResourceHandle<RenderTarget> $$12 = this.targets.itemEntity;
        ResourceHandle<RenderTarget> $$13 = this.targets.entityOutline;
        $$9.executes(() -> {
            RenderSystem.setShaderFog(p_418185_);
            float $$11 = p_360931_.getGameTimeDeltaPartialTick(false);
            Vec3 $$12 = p_363453_.getPosition();
            double $$13 = $$12.x();
            double $$14 = $$12.y();
            double $$15 = $$12.z();
            p_362234_.push("terrain");
            ChunkSectionsToRender $$16 = this.prepareChunkRenders((Matrix4fc)p_362420_, $$13, $$14, $$15);
            $$16.renderGroup(ChunkSectionLayerGroup.OPAQUE);
            this.minecraft.gameRenderer.getLighting().setupFor(Lighting.Entry.LEVEL);
            if ($$12 != null) {
                ((RenderTarget)$$12.get()).copyDepthFrom(this.minecraft.getMainRenderTarget());
            }
            if (this.shouldShowEntityOutlines() && $$13 != null) {
                RenderTarget $$17 = (RenderTarget)$$13.get();
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures($$17.getColorTexture(), 0, $$17.getDepthTexture(), 1.0);
            }
            PoseStack $$18 = new PoseStack();
            MultiBufferSource.BufferSource $$19 = this.renderBuffers.bufferSource();
            MultiBufferSource.BufferSource $$20 = this.renderBuffers.crumblingBufferSource();
            p_362234_.popPush("entities");
            this.visibleEntities.sort(ENTITY_COMPARATOR);
            this.renderEntities($$18, $$19, p_363453_, p_360931_, this.visibleEntities);
            $$19.endLastBatch();
            this.checkPoseStack($$18);
            p_362234_.popPush("blockentities");
            this.renderBlockEntities($$18, $$19, $$20, p_363453_, $$11);
            $$19.endLastBatch();
            this.checkPoseStack($$18);
            $$19.endBatch(RenderType.solid());
            $$19.endBatch(RenderType.endPortal());
            $$19.endBatch(RenderType.endGateway());
            $$19.endBatch(Sheets.solidBlockSheet());
            $$19.endBatch(Sheets.cutoutBlockSheet());
            $$19.endBatch(Sheets.bedSheet());
            $$19.endBatch(Sheets.shulkerBoxSheet());
            $$19.endBatch(Sheets.signSheet());
            $$19.endBatch(Sheets.hangingSignSheet());
            $$19.endBatch(Sheets.chestSheet());
            this.renderBuffers.outlineBufferSource().endOutlineBatch();
            if (p_363964_) {
                this.renderBlockOutline(p_363453_, $$19, $$18, false);
            }
            p_362234_.popPush("debug");
            this.minecraft.debugRenderer.render($$18, p_366590_, $$19, $$13, $$14, $$15);
            $$19.endLastBatch();
            this.checkPoseStack($$18);
            $$19.endBatch(Sheets.translucentItemSheet());
            $$19.endBatch(Sheets.bannerSheet());
            $$19.endBatch(Sheets.shieldSheet());
            $$19.endBatch(RenderType.armorEntityGlint());
            $$19.endBatch(RenderType.glint());
            $$19.endBatch(RenderType.glintTranslucent());
            $$19.endBatch(RenderType.entityGlint());
            p_362234_.popPush("destroyProgress");
            this.renderBlockDestroyAnimation($$18, p_363453_, $$20);
            $$20.endBatch();
            this.checkPoseStack($$18);
            $$19.endBatch(RenderType.waterMask());
            $$19.endBatch();
            if ($$11 != null) {
                ((RenderTarget)$$11.get()).copyDepthFrom((RenderTarget)$$10.get());
            }
            p_362234_.popPush("translucent");
            $$16.renderGroup(ChunkSectionLayerGroup.TRANSLUCENT);
            p_362234_.popPush("string");
            $$16.renderGroup(ChunkSectionLayerGroup.TRIPWIRE);
            if (p_363964_) {
                this.renderBlockOutline(p_363453_, $$19, $$18, true);
            }
            $$19.endBatch();
            p_362234_.pop();
        });
    }

    private void addParticlesPass(FrameGraphBuilder p_363357_, Camera p_365299_, float p_364282_, GpuBufferSlice p_418328_) {
        FramePass $$4 = p_363357_.addPass("particles");
        if (this.targets.particles != null) {
            this.targets.particles = $$4.readsAndWrites(this.targets.particles);
            $$4.reads(this.targets.main);
        } else {
            this.targets.main = $$4.readsAndWrites(this.targets.main);
        }
        ResourceHandle<RenderTarget> $$5 = this.targets.main;
        ResourceHandle<RenderTarget> $$6 = this.targets.particles;
        $$4.executes(() -> {
            RenderSystem.setShaderFog(p_418328_);
            if ($$6 != null) {
                ((RenderTarget)$$6.get()).copyDepthFrom((RenderTarget)$$5.get());
            }
            this.minecraft.particleEngine.render(p_365299_, p_364282_, this.renderBuffers.bufferSource());
        });
    }

    private void addCloudsPass(FrameGraphBuilder p_361907_, CloudStatus p_364196_, Vec3 p_362985_, float p_365209_, int p_362342_, float p_362337_) {
        FramePass $$6 = p_361907_.addPass("clouds");
        if (this.targets.clouds != null) {
            this.targets.clouds = $$6.readsAndWrites(this.targets.clouds);
        } else {
            this.targets.main = $$6.readsAndWrites(this.targets.main);
        }
        $$6.executes(() -> this.cloudRenderer.render(p_362342_, p_364196_, p_362337_, p_362985_, p_365209_));
    }

    private void addWeatherPass(FrameGraphBuilder p_364025_, Vec3 p_360771_, float p_362434_, GpuBufferSlice p_418104_) {
        int $$4 = this.minecraft.options.getEffectiveRenderDistance() * 16;
        float $$5 = this.minecraft.gameRenderer.getDepthFar();
        FramePass $$6 = p_364025_.addPass("weather");
        if (this.targets.weather != null) {
            this.targets.weather = $$6.readsAndWrites(this.targets.weather);
        } else {
            this.targets.main = $$6.readsAndWrites(this.targets.main);
        }
        $$6.executes(() -> {
            RenderSystem.setShaderFog(p_418104_);
            MultiBufferSource.BufferSource $$5 = this.renderBuffers.bufferSource();
            this.weatherEffectRenderer.render(this.minecraft.level, $$5, this.ticks, p_362434_, p_360771_);
            this.worldBorderRenderer.render(this.level.getWorldBorder(), p_360771_, $$4, $$5);
            $$5.endBatch();
        });
    }

    private void addLateDebugPass(FrameGraphBuilder p_361973_, Vec3 p_363812_, GpuBufferSlice p_418393_) {
        FramePass $$3 = p_361973_.addPass("late_debug");
        this.targets.main = $$3.readsAndWrites(this.targets.main);
        if (this.targets.itemEntity != null) {
            this.targets.itemEntity = $$3.readsAndWrites(this.targets.itemEntity);
        }
        ResourceHandle<RenderTarget> $$4 = this.targets.main;
        $$3.executes(() -> {
            RenderSystem.setShaderFog(p_418393_);
            PoseStack $$2 = new PoseStack();
            MultiBufferSource.BufferSource $$3 = this.renderBuffers.bufferSource();
            this.minecraft.debugRenderer.renderAfterTranslucents($$2, $$3, p_417666_.x, p_417666_.y, p_417666_.z);
            $$3.endLastBatch();
            this.checkPoseStack($$2);
        });
    }

    private boolean collectVisibleEntities(Camera p_363510_, Frustum p_361275_, List<Entity> p_363380_) {
        Vec3 $$3 = p_363510_.getPosition();
        double $$4 = $$3.x();
        double $$5 = $$3.y();
        double $$6 = $$3.z();
        boolean $$7 = false;
        boolean $$8 = this.shouldShowEntityOutlines();
        Entity.setViewScale(Mth.clamp((double)this.minecraft.options.getEffectiveRenderDistance() / 8.0, 1.0, 2.5) * this.minecraft.options.entityDistanceScaling().get());
        for (Entity $$9 : this.level.entitiesForRendering()) {
            BlockPos $$10;
            if (!this.entityRenderDispatcher.shouldRender($$9, p_361275_, $$4, $$5, $$6) && !$$9.hasIndirectPassenger(this.minecraft.player) || !this.level.isOutsideBuildHeight(($$10 = $$9.blockPosition()).getY()) && !this.isSectionCompiled($$10) || $$9 == p_363510_.getEntity() && !p_363510_.isDetached() && (!(p_363510_.getEntity() instanceof LivingEntity) || !((LivingEntity)p_363510_.getEntity()).isSleeping()) || $$9 instanceof LocalPlayer && p_363510_.getEntity() != $$9) continue;
            p_363380_.add($$9);
            if (!$$8 || !this.minecraft.shouldEntityAppearGlowing($$9)) continue;
            $$7 = true;
        }
        return $$7;
    }

    private void renderEntities(PoseStack p_363182_, MultiBufferSource.BufferSource p_360990_, Camera p_360717_, DeltaTracker p_362965_, List<Entity> p_362298_) {
        Vec3 $$5 = p_360717_.getPosition();
        double $$6 = $$5.x();
        double $$7 = $$5.y();
        double $$8 = $$5.z();
        TickRateManager $$9 = this.minecraft.level.tickRateManager();
        boolean $$10 = this.shouldShowEntityOutlines();
        for (Entity $$11 : p_362298_) {
            MultiBufferSource.BufferSource $$15;
            if ($$11.tickCount == 0) {
                $$11.xOld = $$11.getX();
                $$11.yOld = $$11.getY();
                $$11.zOld = $$11.getZ();
            }
            if ($$10 && this.minecraft.shouldEntityAppearGlowing($$11)) {
                OutlineBufferSource $$12;
                OutlineBufferSource $$13 = $$12 = this.renderBuffers.outlineBufferSource();
                int $$14 = $$11.getTeamColor();
                $$12.setColor(ARGB.red($$14), ARGB.green($$14), ARGB.blue($$14), 255);
            } else {
                $$15 = p_360990_;
            }
            float $$16 = p_362965_.getGameTimeDeltaPartialTick(!$$9.isEntityFrozen($$11));
            this.renderEntity($$11, $$6, $$7, $$8, $$16, p_363182_, $$15);
        }
    }

    private void renderBlockEntities(PoseStack p_362832_, MultiBufferSource.BufferSource p_363819_, MultiBufferSource.BufferSource p_361830_, Camera p_362042_, float p_362089_) {
        Vec3 $$5 = p_362042_.getPosition();
        double $$6 = $$5.x();
        double $$7 = $$5.y();
        double $$8 = $$5.z();
        for (SectionRenderDispatcher.RenderSection $$9 : this.visibleSections) {
            List<BlockEntity> $$10 = $$9.getSectionMesh().getRenderableBlockEntities();
            if ($$10.isEmpty()) continue;
            for (BlockEntity $$11 : $$10) {
                int $$15;
                BlockPos $$12 = $$11.getBlockPos();
                MultiBufferSource $$13 = p_363819_;
                p_362832_.pushPose();
                p_362832_.translate((double)$$12.getX() - $$6, (double)$$12.getY() - $$7, (double)$$12.getZ() - $$8);
                SortedSet $$14 = (SortedSet)this.destructionProgress.get($$12.asLong());
                if ($$14 != null && !$$14.isEmpty() && ($$15 = ((BlockDestructionProgress)$$14.last()).getProgress()) >= 0) {
                    PoseStack.Pose $$16 = p_362832_.last();
                    SheetedDecalTextureGenerator $$17 = new SheetedDecalTextureGenerator(p_361830_.getBuffer(ModelBakery.DESTROY_TYPES.get($$15)), $$16, 1.0f);
                    $$13 = p_234298_ -> {
                        VertexConsumer $$3 = p_363819_.getBuffer(p_234298_);
                        if (p_234298_.affectsCrumbling()) {
                            return VertexMultiConsumer.create($$17, $$3);
                        }
                        return $$3;
                    };
                }
                this.blockEntityRenderDispatcher.render($$11, p_362089_, p_362832_, $$13);
                p_362832_.popPose();
            }
        }
        Iterator<BlockEntity> $$18 = this.level.getGloballyRenderedBlockEntities().iterator();
        while ($$18.hasNext()) {
            BlockEntity $$19 = $$18.next();
            if ($$19.isRemoved()) {
                $$18.remove();
                continue;
            }
            BlockPos $$20 = $$19.getBlockPos();
            p_362832_.pushPose();
            p_362832_.translate((double)$$20.getX() - $$6, (double)$$20.getY() - $$7, (double)$$20.getZ() - $$8);
            this.blockEntityRenderDispatcher.render($$19, p_362089_, p_362832_, p_363819_);
            p_362832_.popPose();
        }
    }

    private void renderBlockDestroyAnimation(PoseStack p_363901_, Camera p_361175_, MultiBufferSource.BufferSource p_365216_) {
        Vec3 $$3 = p_361175_.getPosition();
        double $$4 = $$3.x();
        double $$5 = $$3.y();
        double $$6 = $$3.z();
        for (Long2ObjectMap.Entry $$7 : this.destructionProgress.long2ObjectEntrySet()) {
            SortedSet $$9;
            BlockPos $$8 = BlockPos.of($$7.getLongKey());
            if ($$8.distToCenterSqr($$4, $$5, $$6) > 1024.0 || ($$9 = (SortedSet)$$7.getValue()) == null || $$9.isEmpty()) continue;
            int $$10 = ((BlockDestructionProgress)$$9.last()).getProgress();
            p_363901_.pushPose();
            p_363901_.translate((double)$$8.getX() - $$4, (double)$$8.getY() - $$5, (double)$$8.getZ() - $$6);
            PoseStack.Pose $$11 = p_363901_.last();
            SheetedDecalTextureGenerator $$12 = new SheetedDecalTextureGenerator(p_365216_.getBuffer(ModelBakery.DESTROY_TYPES.get($$10)), $$11, 1.0f);
            this.minecraft.getBlockRenderer().renderBreakingTexture(this.level.getBlockState($$8), $$8, this.level, p_363901_, $$12);
            p_363901_.popPose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void renderBlockOutline(Camera p_363911_, MultiBufferSource.BufferSource p_362782_, PoseStack p_361893_, boolean p_361698_) {
        void $$5;
        HitResult hitResult = this.minecraft.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult $$4 = (BlockHitResult)hitResult;
        if ($$5.getType() == HitResult.Type.MISS) {
            return;
        }
        BlockPos $$6 = $$5.getBlockPos();
        BlockState $$7 = this.level.getBlockState($$6);
        if (!$$7.isAir() && this.level.getWorldBorder().isWithinBounds($$6)) {
            boolean $$8 = ItemBlockRenderTypes.getChunkRenderType($$7).sortOnUpload();
            if ($$8 != p_361698_) {
                return;
            }
            Vec3 $$9 = p_363911_.getPosition();
            Boolean $$10 = this.minecraft.options.highContrastBlockOutline().get();
            if ($$10.booleanValue()) {
                VertexConsumer $$11 = p_362782_.getBuffer(RenderType.secondaryBlockOutline());
                this.renderHitOutline(p_361893_, $$11, p_363911_.getEntity(), $$9.x, $$9.y, $$9.z, $$6, $$7, -16777216);
            }
            VertexConsumer $$12 = p_362782_.getBuffer(RenderType.lines());
            int $$13 = $$10 != false ? -11010079 : ARGB.color(102, -16777216);
            this.renderHitOutline(p_361893_, $$12, p_363911_.getEntity(), $$9.x, $$9.y, $$9.z, $$6, $$7, $$13);
            p_362782_.endLastBatch();
        }
    }

    private void checkPoseStack(PoseStack p_109589_) {
        if (!p_109589_.isEmpty()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    private void renderEntity(Entity p_109518_, double p_109519_, double p_109520_, double p_109521_, float p_109522_, PoseStack p_109523_, MultiBufferSource p_109524_) {
        double $$7 = Mth.lerp((double)p_109522_, p_109518_.xOld, p_109518_.getX());
        double $$8 = Mth.lerp((double)p_109522_, p_109518_.yOld, p_109518_.getY());
        double $$9 = Mth.lerp((double)p_109522_, p_109518_.zOld, p_109518_.getZ());
        this.entityRenderDispatcher.render(p_109518_, $$7 - p_109519_, $$8 - p_109520_, $$9 - p_109521_, p_109522_, p_109523_, p_109524_, this.entityRenderDispatcher.getPackedLightCoords(p_109518_, p_109522_));
    }

    private void scheduleTranslucentSectionResort(Vec3 p_361632_) {
        if (this.visibleSections.isEmpty()) {
            return;
        }
        BlockPos $$1 = BlockPos.containing(p_361632_);
        boolean $$2 = !$$1.equals(this.lastTranslucentSortBlockPos);
        Profiler.get().push("translucent_sort");
        TranslucencyPointOfView $$3 = new TranslucencyPointOfView();
        for (SectionRenderDispatcher.RenderSection $$4 : this.nearbyVisibleSections) {
            this.scheduleResort($$4, $$3, p_361632_, $$2, true);
        }
        this.translucencyResortIterationIndex %= this.visibleSections.size();
        int $$5 = Math.max(this.visibleSections.size() / 8, 15);
        while ($$5-- > 0) {
            int $$6 = this.translucencyResortIterationIndex++ % this.visibleSections.size();
            this.scheduleResort((SectionRenderDispatcher.RenderSection)this.visibleSections.get($$6), $$3, p_361632_, $$2, false);
        }
        this.lastTranslucentSortBlockPos = $$1;
        Profiler.get().pop();
    }

    private void scheduleResort(SectionRenderDispatcher.RenderSection p_371775_, TranslucencyPointOfView p_427314_, Vec3 p_371372_, boolean p_371855_, boolean p_371355_) {
        boolean $$6;
        p_427314_.set(p_371372_, p_371775_.getSectionNode());
        boolean $$5 = p_371775_.getSectionMesh().isDifferentPointOfView(p_427314_);
        boolean bl = $$6 = p_371855_ && (p_427314_.isAxisAligned() || p_371355_);
        if (($$6 || $$5) && !p_371775_.transparencyResortingScheduled() && p_371775_.hasTranslucentGeometry()) {
            p_371775_.resortTransparency(this.sectionRenderDispatcher);
        }
    }

    private ChunkSectionsToRender prepareChunkRenders(Matrix4fc p_428537_, double p_428258_, double p_428243_, double p_428448_) {
        ObjectListIterator $$4 = this.visibleSections.listIterator(0);
        EnumMap<ChunkSectionLayer, List<RenderPass.Draw<GpuBufferSlice[]>>> $$5 = new EnumMap<ChunkSectionLayer, List<RenderPass.Draw<GpuBufferSlice[]>>>(ChunkSectionLayer.class);
        int $$6 = 0;
        for (ChunkSectionLayer $$7 : ChunkSectionLayer.values()) {
            $$5.put($$7, new ArrayList());
        }
        ArrayList<DynamicUniforms.Transform> $$8 = new ArrayList<DynamicUniforms.Transform>();
        Vector4f $$9 = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        Matrix4f $$10 = new Matrix4f();
        while ($$4.hasNext()) {
            SectionRenderDispatcher.RenderSection $$11 = (SectionRenderDispatcher.RenderSection)$$4.next();
            SectionMesh $$12 = $$11.getSectionMesh();
            for (ChunkSectionLayer $$13 : ChunkSectionLayer.values()) {
                VertexFormat.IndexType $$18;
                GpuBuffer $$17;
                SectionBuffers $$14 = $$12.getBuffers($$13);
                if ($$14 == null) continue;
                if ($$14.getIndexBuffer() == null) {
                    if ($$14.getIndexCount() > $$6) {
                        $$6 = $$14.getIndexCount();
                    }
                    Object $$15 = null;
                    Object $$16 = null;
                } else {
                    $$17 = $$14.getIndexBuffer();
                    $$18 = $$14.getIndexType();
                }
                BlockPos $$19 = $$11.getRenderOrigin();
                int $$20 = $$8.size();
                $$8.add(new DynamicUniforms.Transform(p_428537_, (Vector4fc)$$9, (Vector3fc)new Vector3f((float)((double)$$19.getX() - p_428258_), (float)((double)$$19.getY() - p_428243_), (float)((double)$$19.getZ() - p_428448_)), (Matrix4fc)$$10, 1.0f));
                $$5.get((Object)$$13).add(new RenderPass.Draw<GpuBufferSlice[]>(0, $$14.getVertexBuffer(), $$17, $$18, 0, $$14.getIndexCount(), (p_428086_, p_428087_) -> p_428087_.upload("DynamicTransforms", p_428086_[$$20])));
            }
        }
        GpuBufferSlice[] $$21 = RenderSystem.getDynamicUniforms().writeTransforms($$8.toArray(new DynamicUniforms.Transform[0]));
        return new ChunkSectionsToRender($$5, $$6, $$21);
    }

    public void endFrame() {
        this.cloudRenderer.endFrame();
    }

    public void captureFrustum() {
        this.captureFrustum = true;
    }

    public void killFrustum() {
        this.capturedFrustum = null;
    }

    public void tick() {
        if (this.level.tickRateManager().runsNormally()) {
            ++this.ticks;
        }
        if (this.ticks % 20 != 0) {
            return;
        }
        ObjectIterator $$0 = this.destroyingBlocks.values().iterator();
        while ($$0.hasNext()) {
            BlockDestructionProgress $$1 = (BlockDestructionProgress)$$0.next();
            int $$2 = $$1.getUpdatedRenderTick();
            if (this.ticks - $$2 <= 400) continue;
            $$0.remove();
            this.removeProgress($$1);
        }
    }

    private void removeProgress(BlockDestructionProgress p_109766_) {
        long $$1 = p_109766_.getPos().asLong();
        Set $$2 = (Set)this.destructionProgress.get($$1);
        $$2.remove(p_109766_);
        if ($$2.isEmpty()) {
            this.destructionProgress.remove($$1);
        }
    }

    private void addSkyPass(FrameGraphBuilder p_362870_, Camera p_362177_, float p_363799_, GpuBufferSlice p_418294_) {
        FogType $$4 = p_362177_.getFluidInCamera();
        if ($$4 == FogType.POWDER_SNOW || $$4 == FogType.LAVA || this.doesMobEffectBlockSky(p_362177_)) {
            return;
        }
        DimensionSpecialEffects $$5 = this.level.effects();
        DimensionSpecialEffects.SkyType $$6 = $$5.skyType();
        if ($$6 == DimensionSpecialEffects.SkyType.NONE) {
            return;
        }
        FramePass $$7 = p_362870_.addPass("sky");
        this.targets.main = $$7.readsAndWrites(this.targets.main);
        $$7.executes(() -> {
            RenderSystem.setShaderFog(p_418294_);
            if ($$6 == DimensionSpecialEffects.SkyType.END) {
                this.skyRenderer.renderEndSky();
                return;
            }
            PoseStack $$4 = new PoseStack();
            float $$5 = this.level.getSunAngle(p_363799_);
            float $$6 = this.level.getTimeOfDay(p_363799_);
            float $$7 = 1.0f - this.level.getRainLevel(p_363799_);
            float $$8 = this.level.getStarBrightness(p_363799_) * $$7;
            int $$9 = $$5.getSunriseOrSunsetColor($$6);
            int $$10 = this.level.getMoonPhase();
            int $$11 = this.level.getSkyColor(this.minecraft.gameRenderer.getMainCamera().getPosition(), p_363799_);
            float $$12 = ARGB.redFloat($$11);
            float $$13 = ARGB.greenFloat($$11);
            float $$14 = ARGB.blueFloat($$11);
            this.skyRenderer.renderSkyDisc($$12, $$13, $$14);
            MultiBufferSource.BufferSource $$15 = this.renderBuffers.bufferSource();
            if ($$5.isSunriseOrSunset($$6)) {
                this.skyRenderer.renderSunriseAndSunset($$4, $$15, $$5, $$9);
            }
            this.skyRenderer.renderSunMoonAndStars($$4, $$15, $$6, $$10, $$7, $$8);
            $$15.endBatch();
            if (this.shouldRenderDarkDisc(p_363799_)) {
                this.skyRenderer.renderDarkDisc();
            }
        });
    }

    private boolean shouldRenderDarkDisc(float p_362498_) {
        return this.minecraft.player.getEyePosition((float)p_362498_).y - this.level.getLevelData().getHorizonHeight(this.level) < 0.0;
    }

    private boolean doesMobEffectBlockSky(Camera p_234311_) {
        Entity entity = p_234311_.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity $$1 = (LivingEntity)entity;
            return $$1.hasEffect(MobEffects.BLINDNESS) || $$1.hasEffect(MobEffects.DARKNESS);
        }
        return false;
    }

    private void compileSections(Camera p_194371_) {
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("populate_sections_to_compile");
        RenderRegionCache $$2 = new RenderRegionCache();
        BlockPos $$3 = p_194371_.getBlockPosition();
        ArrayList $$4 = Lists.newArrayList();
        for (SectionRenderDispatcher.RenderSection $$5 : this.visibleSections) {
            if (!$$5.isDirty() || $$5.getSectionMesh() == CompiledSectionMesh.UNCOMPILED && !$$5.hasAllNeighbors()) continue;
            boolean $$6 = false;
            if (this.minecraft.options.prioritizeChunkUpdates().get() == PrioritizeChunkUpdates.NEARBY) {
                BlockPos $$7 = SectionPos.of($$5.getSectionNode()).center();
                $$6 = $$7.distSqr($$3) < 768.0 || $$5.isDirtyFromPlayer();
            } else if (this.minecraft.options.prioritizeChunkUpdates().get() == PrioritizeChunkUpdates.PLAYER_AFFECTED) {
                $$6 = $$5.isDirtyFromPlayer();
            }
            if ($$6) {
                $$1.push("build_near_sync");
                this.sectionRenderDispatcher.rebuildSectionSync($$5, $$2);
                $$5.setNotDirty();
                $$1.pop();
                continue;
            }
            $$4.add($$5);
        }
        $$1.popPush("upload");
        this.sectionRenderDispatcher.uploadAllPendingUploads();
        $$1.popPush("schedule_async_compile");
        for (SectionRenderDispatcher.RenderSection $$8 : $$4) {
            $$8.rebuildSectionAsync($$2);
            $$8.setNotDirty();
        }
        $$1.pop();
        this.scheduleTranslucentSectionResort(p_194371_.getPosition());
    }

    private void renderHitOutline(PoseStack p_109638_, VertexConsumer p_109639_, Entity p_109640_, double p_109641_, double p_109642_, double p_109643_, BlockPos p_109644_, BlockState p_109645_, int p_380403_) {
        ShapeRenderer.renderShape(p_109638_, p_109639_, p_109645_.getShape(this.level, p_109644_, CollisionContext.of(p_109640_)), (double)p_109644_.getX() - p_109641_, (double)p_109644_.getY() - p_109642_, (double)p_109644_.getZ() - p_109643_, p_380403_);
    }

    public void blockChanged(BlockGetter p_109545_, BlockPos p_109546_, BlockState p_109547_, BlockState p_109548_, int p_109549_) {
        this.setBlockDirty(p_109546_, (p_109549_ & 8) != 0);
    }

    private void setBlockDirty(BlockPos p_109733_, boolean p_109734_) {
        for (int $$2 = p_109733_.getZ() - 1; $$2 <= p_109733_.getZ() + 1; ++$$2) {
            for (int $$3 = p_109733_.getX() - 1; $$3 <= p_109733_.getX() + 1; ++$$3) {
                for (int $$4 = p_109733_.getY() - 1; $$4 <= p_109733_.getY() + 1; ++$$4) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord($$3), SectionPos.blockToSectionCoord($$4), SectionPos.blockToSectionCoord($$2), p_109734_);
                }
            }
        }
    }

    public void setBlocksDirty(int p_109495_, int p_109496_, int p_109497_, int p_109498_, int p_109499_, int p_109500_) {
        for (int $$6 = p_109497_ - 1; $$6 <= p_109500_ + 1; ++$$6) {
            for (int $$7 = p_109495_ - 1; $$7 <= p_109498_ + 1; ++$$7) {
                for (int $$8 = p_109496_ - 1; $$8 <= p_109499_ + 1; ++$$8) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord($$7), SectionPos.blockToSectionCoord($$8), SectionPos.blockToSectionCoord($$6));
                }
            }
        }
    }

    public void setBlockDirty(BlockPos p_109722_, BlockState p_109723_, BlockState p_109724_) {
        if (this.minecraft.getModelManager().requiresRender(p_109723_, p_109724_)) {
            this.setBlocksDirty(p_109722_.getX(), p_109722_.getY(), p_109722_.getZ(), p_109722_.getX(), p_109722_.getY(), p_109722_.getZ());
        }
    }

    public void setSectionDirtyWithNeighbors(int p_109491_, int p_109492_, int p_109493_) {
        this.setSectionRangeDirty(p_109491_ - 1, p_109492_ - 1, p_109493_ - 1, p_109491_ + 1, p_109492_ + 1, p_109493_ + 1);
    }

    public void setSectionRangeDirty(int p_363248_, int p_360721_, int p_360463_, int p_362591_, int p_364598_, int p_365249_) {
        for (int $$6 = p_360463_; $$6 <= p_365249_; ++$$6) {
            for (int $$7 = p_363248_; $$7 <= p_362591_; ++$$7) {
                for (int $$8 = p_360721_; $$8 <= p_364598_; ++$$8) {
                    this.setSectionDirty($$7, $$8, $$6);
                }
            }
        }
    }

    public void setSectionDirty(int p_109771_, int p_109772_, int p_109773_) {
        this.setSectionDirty(p_109771_, p_109772_, p_109773_, false);
    }

    private void setSectionDirty(int p_109502_, int p_109503_, int p_109504_, boolean p_109505_) {
        this.viewArea.setDirty(p_109502_, p_109503_, p_109504_, p_109505_);
    }

    public void onSectionBecomingNonEmpty(long p_366463_) {
        SectionRenderDispatcher.RenderSection $$1 = this.viewArea.getRenderSection(p_366463_);
        if ($$1 != null) {
            this.sectionOcclusionGraph.schedulePropagationFrom($$1);
        }
    }

    public void addParticle(ParticleOptions p_109744_, boolean p_109745_, double p_109746_, double p_109747_, double p_109748_, double p_109749_, double p_109750_, double p_109751_) {
        this.addParticle(p_109744_, p_109745_, false, p_109746_, p_109747_, p_109748_, p_109749_, p_109750_, p_109751_);
    }

    public void addParticle(ParticleOptions p_109753_, boolean p_109754_, boolean p_109755_, double p_109756_, double p_109757_, double p_109758_, double p_109759_, double p_109760_, double p_109761_) {
        try {
            this.addParticleInternal(p_109753_, p_109754_, p_109755_, p_109756_, p_109757_, p_109758_, p_109759_, p_109760_, p_109761_);
        }
        catch (Throwable $$9) {
            CrashReport $$10 = CrashReport.forThrowable($$9, "Exception while adding particle");
            CrashReportCategory $$11 = $$10.addCategory("Particle being added");
            $$11.setDetail("ID", BuiltInRegistries.PARTICLE_TYPE.getKey(p_109753_.getType()));
            $$11.setDetail("Parameters", () -> ParticleTypes.CODEC.encodeStart(this.level.registryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)p_109753_).toString());
            $$11.setDetail("Position", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, p_109756_, p_109757_, p_109758_));
            throw new ReportedException($$10);
        }
    }

    public <T extends ParticleOptions> void addParticle(T p_109736_, double p_109737_, double p_109738_, double p_109739_, double p_109740_, double p_109741_, double p_109742_) {
        this.addParticle(p_109736_, p_109736_.getType().getOverrideLimiter(), p_109737_, p_109738_, p_109739_, p_109740_, p_109741_, p_109742_);
    }

    @Nullable
    Particle addParticleInternal(ParticleOptions p_109796_, boolean p_109797_, double p_109798_, double p_109799_, double p_109800_, double p_109801_, double p_109802_, double p_109803_) {
        return this.addParticleInternal(p_109796_, p_109797_, false, p_109798_, p_109799_, p_109800_, p_109801_, p_109802_, p_109803_);
    }

    @Nullable
    private Particle addParticleInternal(ParticleOptions p_109805_, boolean p_109806_, boolean p_109807_, double p_109808_, double p_109809_, double p_109810_, double p_109811_, double p_109812_, double p_109813_) {
        Camera $$9 = this.minecraft.gameRenderer.getMainCamera();
        ParticleStatus $$10 = this.calculateParticleLevel(p_109807_);
        if (p_109806_) {
            return this.minecraft.particleEngine.createParticle(p_109805_, p_109808_, p_109809_, p_109810_, p_109811_, p_109812_, p_109813_);
        }
        if ($$9.getPosition().distanceToSqr(p_109808_, p_109809_, p_109810_) > 1024.0) {
            return null;
        }
        if ($$10 == ParticleStatus.MINIMAL) {
            return null;
        }
        return this.minecraft.particleEngine.createParticle(p_109805_, p_109808_, p_109809_, p_109810_, p_109811_, p_109812_, p_109813_);
    }

    private ParticleStatus calculateParticleLevel(boolean p_109768_) {
        ParticleStatus $$1 = this.minecraft.options.particles().get();
        if (p_109768_ && $$1 == ParticleStatus.MINIMAL && this.level.random.nextInt(10) == 0) {
            $$1 = ParticleStatus.DECREASED;
        }
        if ($$1 == ParticleStatus.DECREASED && this.level.random.nextInt(3) == 0) {
            $$1 = ParticleStatus.MINIMAL;
        }
        return $$1;
    }

    public void destroyBlockProgress(int p_109775_, BlockPos p_109776_, int p_109777_) {
        if (p_109777_ < 0 || p_109777_ >= 10) {
            BlockDestructionProgress $$3 = (BlockDestructionProgress)this.destroyingBlocks.remove(p_109775_);
            if ($$3 != null) {
                this.removeProgress($$3);
            }
        } else {
            BlockDestructionProgress $$4 = (BlockDestructionProgress)this.destroyingBlocks.get(p_109775_);
            if ($$4 != null) {
                this.removeProgress($$4);
            }
            if ($$4 == null || $$4.getPos().getX() != p_109776_.getX() || $$4.getPos().getY() != p_109776_.getY() || $$4.getPos().getZ() != p_109776_.getZ()) {
                $$4 = new BlockDestructionProgress(p_109775_, p_109776_);
                this.destroyingBlocks.put(p_109775_, (Object)$$4);
            }
            $$4.setProgress(p_109777_);
            $$4.updateTick(this.ticks);
            ((SortedSet)this.destructionProgress.computeIfAbsent($$4.getPos().asLong(), p_234254_ -> Sets.newTreeSet())).add($$4);
        }
    }

    public boolean hasRenderedAllSections() {
        return this.sectionRenderDispatcher.isQueueEmpty();
    }

    public void onChunkReadyToRender(ChunkPos p_383159_) {
        this.sectionOcclusionGraph.onChunkReadyToRender(p_383159_);
    }

    public void needsUpdate() {
        this.sectionOcclusionGraph.invalidate();
        this.cloudRenderer.markForRebuild();
    }

    public static int getLightColor(BlockAndTintGetter p_109542_, BlockPos p_109543_) {
        return LevelRenderer.getLightColor(BrightnessGetter.DEFAULT, p_109542_, p_109542_.getBlockState(p_109543_), p_109543_);
    }

    public static int getLightColor(BrightnessGetter p_412967_, BlockAndTintGetter p_109538_, BlockState p_109539_, BlockPos p_109540_) {
        int $$6;
        if (p_109539_.emissiveRendering(p_109538_, p_109540_)) {
            return 0xF000F0;
        }
        int $$4 = p_412967_.packedBrightness(p_109538_, p_109540_);
        int $$5 = LightTexture.block($$4);
        if ($$5 < ($$6 = p_109539_.getLightEmission())) {
            int $$7 = LightTexture.sky($$4);
            return LightTexture.pack($$6, $$7);
        }
        return $$4;
    }

    public boolean isSectionCompiled(BlockPos p_295788_) {
        SectionRenderDispatcher.RenderSection $$1 = this.viewArea.getRenderSectionAt(p_295788_);
        return $$1 != null && $$1.sectionMesh.get() != CompiledSectionMesh.UNCOMPILED;
    }

    @Nullable
    public RenderTarget entityOutlineTarget() {
        return this.targets.entityOutline != null ? this.targets.entityOutline.get() : null;
    }

    @Nullable
    public RenderTarget getTranslucentTarget() {
        return this.targets.translucent != null ? this.targets.translucent.get() : null;
    }

    @Nullable
    public RenderTarget getItemEntityTarget() {
        return this.targets.itemEntity != null ? this.targets.itemEntity.get() : null;
    }

    @Nullable
    public RenderTarget getParticlesTarget() {
        return this.targets.particles != null ? this.targets.particles.get() : null;
    }

    @Nullable
    public RenderTarget getWeatherTarget() {
        return this.targets.weather != null ? this.targets.weather.get() : null;
    }

    @Nullable
    public RenderTarget getCloudsTarget() {
        return this.targets.clouds != null ? this.targets.clouds.get() : null;
    }

    @VisibleForDebug
    public ObjectArrayList<SectionRenderDispatcher.RenderSection> getVisibleSections() {
        return this.visibleSections;
    }

    @VisibleForDebug
    public SectionOcclusionGraph getSectionOcclusionGraph() {
        return this.sectionOcclusionGraph;
    }

    @Nullable
    public Frustum getCapturedFrustum() {
        return this.capturedFrustum;
    }

    public CloudRenderer getCloudRenderer() {
        return this.cloudRenderer;
    }

    @FunctionalInterface
    public static interface BrightnessGetter {
        public static final BrightnessGetter DEFAULT = (p_412971_, p_412968_) -> {
            int $$2 = p_412971_.getBrightness(LightLayer.SKY, p_412968_);
            int $$3 = p_412971_.getBrightness(LightLayer.BLOCK, p_412968_);
            return Brightness.pack($$3, $$2);
        };

        public int packedBrightness(BlockAndTintGetter var1, BlockPos var2);
    }
}

