/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.slf4j.Logger;

public class CloudRenderer
extends SimplePreparableReloadListener<Optional<TextureData>>
implements AutoCloseable {
    private static final int FLAG_INSIDE_FACE = 16;
    private static final int FLAG_USE_TOP_COLOR = 32;
    private static final int MAX_RADIUS_CHUNKS = 128;
    private static final float CELL_SIZE_IN_BLOCKS = 12.0f;
    private static final int UBO_SIZE = new Std140SizeCalculator().putVec4().putVec3().putVec3().get();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/clouds.png");
    private static final float BLOCKS_PER_SECOND = 0.6f;
    private static final long EMPTY_CELL = 0L;
    private static final int COLOR_OFFSET = 4;
    private static final int NORTH_OFFSET = 3;
    private static final int EAST_OFFSET = 2;
    private static final int SOUTH_OFFSET = 1;
    private static final int WEST_OFFSET = 0;
    private boolean needsRebuild = true;
    private int prevCellX = Integer.MIN_VALUE;
    private int prevCellZ = Integer.MIN_VALUE;
    private RelativeCameraPos prevRelativeCameraPos = RelativeCameraPos.INSIDE_CLOUDS;
    @Nullable
    private CloudStatus prevType;
    @Nullable
    private TextureData texture;
    private int quadCount = 0;
    private final RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
    private final MappableRingBuffer ubo = new MappableRingBuffer(() -> "Cloud UBO", 130, UBO_SIZE);
    @Nullable
    private MappableRingBuffer utb;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<TextureData> prepare(ResourceManager p_363181_, ProfilerFiller p_361418_) {
        try (InputStream $$2 = p_363181_.open(TEXTURE_LOCATION);){
            NativeImage $$3 = NativeImage.read($$2);
            try {
                int $$4 = $$3.getWidth();
                int $$5 = $$3.getHeight();
                long[] $$6 = new long[$$4 * $$5];
                for (int $$7 = 0; $$7 < $$5; ++$$7) {
                    for (int $$8 = 0; $$8 < $$4; ++$$8) {
                        int $$9 = $$3.getPixel($$8, $$7);
                        if (CloudRenderer.isCellEmpty($$9)) {
                            $$6[$$8 + $$7 * $$4] = 0L;
                            continue;
                        }
                        boolean $$10 = CloudRenderer.isCellEmpty($$3.getPixel($$8, Math.floorMod($$7 - 1, $$5)));
                        boolean $$11 = CloudRenderer.isCellEmpty($$3.getPixel(Math.floorMod($$8 + 1, $$5), $$7));
                        boolean $$12 = CloudRenderer.isCellEmpty($$3.getPixel($$8, Math.floorMod($$7 + 1, $$5)));
                        boolean $$13 = CloudRenderer.isCellEmpty($$3.getPixel(Math.floorMod($$8 - 1, $$5), $$7));
                        $$6[$$8 + $$7 * $$4] = CloudRenderer.packCellData($$9, $$10, $$11, $$12, $$13);
                    }
                }
                Optional<TextureData> optional = Optional.of(new TextureData($$6, $$4, $$5));
                if ($$3 != null) {
                    $$3.close();
                }
                return optional;
            }
            catch (Throwable throwable) {
                if ($$3 != null) {
                    try {
                        $$3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException $$14) {
            LOGGER.error("Failed to load cloud texture", (Throwable)$$14);
            return Optional.empty();
        }
    }

    private static int getSizeForCloudDistance(int p_419493_) {
        int $$1 = 4;
        int $$2 = (p_419493_ + 1) * 2 * ((p_419493_ + 1) * 2) / 2;
        int $$3 = $$2 * 4 + 54;
        return $$3 * 3;
    }

    @Override
    protected void apply(Optional<TextureData> p_362811_, ResourceManager p_364101_, ProfilerFiller p_360749_) {
        this.texture = p_362811_.orElse(null);
        this.needsRebuild = true;
    }

    private static boolean isCellEmpty(int p_363144_) {
        return ARGB.alpha(p_363144_) < 10;
    }

    private static long packCellData(int p_363244_, boolean p_365018_, boolean p_363077_, boolean p_360343_, boolean p_360813_) {
        return (long)p_363244_ << 4 | (long)((p_365018_ ? 1 : 0) << 3) | (long)((p_363077_ ? 1 : 0) << 2) | (long)((p_360343_ ? 1 : 0) << 1) | (long)((p_360813_ ? 1 : 0) << 0);
    }

    private static boolean isNorthEmpty(long p_361438_) {
        return (p_361438_ >> 3 & 1L) != 0L;
    }

    private static boolean isEastEmpty(long p_361625_) {
        return (p_361625_ >> 2 & 1L) != 0L;
    }

    private static boolean isSouthEmpty(long p_361797_) {
        return (p_361797_ >> 1 & 1L) != 0L;
    }

    private static boolean isWestEmpty(long p_363963_) {
        return (p_363963_ >> 0 & 1L) != 0L;
    }

    public void render(int p_363907_, CloudStatus p_364293_, float p_363260_, Vec3 p_363573_, float p_360711_) {
        GpuTextureView $$33;
        GpuTextureView $$32;
        RenderPipeline $$22;
        RelativeCameraPos $$12;
        float $$8;
        float $$9;
        if (this.texture == null) {
            return;
        }
        int $$5 = Math.min(Minecraft.getInstance().options.cloudRange().get(), 128) * 16;
        int $$6 = Mth.ceil((float)$$5 / 12.0f);
        int $$7 = CloudRenderer.getSizeForCloudDistance($$6);
        if (this.utb == null || this.utb.currentBuffer().size() != $$7) {
            if (this.utb != null) {
                this.utb.close();
            }
            this.utb = new MappableRingBuffer(() -> "Cloud UTB", 258, $$7);
        }
        if (($$9 = ($$8 = (float)((double)p_363260_ - p_363573_.y)) + 4.0f) < 0.0f) {
            RelativeCameraPos $$10 = RelativeCameraPos.ABOVE_CLOUDS;
        } else if ($$8 > 0.0f) {
            RelativeCameraPos $$11 = RelativeCameraPos.BELOW_CLOUDS;
        } else {
            $$12 = RelativeCameraPos.INSIDE_CLOUDS;
        }
        double $$13 = p_363573_.x + (double)(p_360711_ * 0.030000001f);
        double $$14 = p_363573_.z + (double)3.96f;
        double $$15 = (double)this.texture.width * 12.0;
        double $$16 = (double)this.texture.height * 12.0;
        $$13 -= (double)Mth.floor($$13 / $$15) * $$15;
        $$14 -= (double)Mth.floor($$14 / $$16) * $$16;
        int $$17 = Mth.floor($$13 / 12.0);
        int $$18 = Mth.floor($$14 / 12.0);
        float $$19 = (float)($$13 - (double)((float)$$17 * 12.0f));
        float $$20 = (float)($$14 - (double)((float)$$18 * 12.0f));
        boolean $$21 = p_364293_ == CloudStatus.FANCY;
        RenderPipeline renderPipeline = $$22 = $$21 ? RenderPipelines.CLOUDS : RenderPipelines.FLAT_CLOUDS;
        if (this.needsRebuild || $$17 != this.prevCellX || $$18 != this.prevCellZ || $$12 != this.prevRelativeCameraPos || p_364293_ != this.prevType) {
            this.needsRebuild = false;
            this.prevCellX = $$17;
            this.prevCellZ = $$18;
            this.prevRelativeCameraPos = $$12;
            this.prevType = p_364293_;
            this.utb.rotate();
            try (GpuBuffer.MappedView $$23 = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.utb.currentBuffer(), false, true);){
                this.buildMesh($$12, $$23.data(), $$17, $$18, $$21, $$6);
                this.quadCount = $$23.data().position() / 3;
            }
        }
        if (this.quadCount == 0) {
            return;
        }
        try (GpuBuffer.MappedView $$24 = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.ubo.currentBuffer(), false, true);){
            Std140Builder.intoBuffer($$24.data()).putVec4(ARGB.redFloat(p_363907_), ARGB.greenFloat(p_363907_), ARGB.blueFloat(p_363907_), 1.0f).putVec3(-$$19, $$8, -$$20).putVec3(12.0f, 4.0f, 12.0f);
        }
        GpuBufferSlice $$25 = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        RenderTarget $$26 = Minecraft.getInstance().getMainRenderTarget();
        RenderTarget $$27 = Minecraft.getInstance().levelRenderer.getCloudsTarget();
        RenderSystem.AutoStorageIndexBuffer $$28 = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
        GpuBuffer $$29 = $$28.getBuffer(6 * this.quadCount);
        if ($$27 != null) {
            GpuTextureView $$30 = $$27.getColorTextureView();
            GpuTextureView $$31 = $$27.getDepthTextureView();
        } else {
            $$32 = $$26.getColorTextureView();
            $$33 = $$26.getDepthTextureView();
        }
        try (RenderPass $$34 = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Clouds", $$32, OptionalInt.empty(), $$33, OptionalDouble.empty());){
            $$34.setPipeline($$22);
            RenderSystem.bindDefaultUniforms($$34);
            $$34.setUniform("DynamicTransforms", $$25);
            $$34.setIndexBuffer($$29, $$28.type());
            $$34.setVertexBuffer(0, RenderSystem.getQuadVertexBuffer());
            $$34.setUniform("CloudInfo", this.ubo.currentBuffer());
            $$34.setUniform("CloudFaces", this.utb.currentBuffer());
            $$34.setPipeline($$22);
            $$34.drawIndexed(0, 0, 6 * this.quadCount, 1);
        }
    }

    private void buildMesh(RelativeCameraPos p_364842_, ByteBuffer p_418203_, int p_362701_, int p_361589_, boolean p_418059_, int p_419903_) {
        if (this.texture == null) {
            return;
        }
        long[] $$6 = this.texture.cells;
        int $$7 = this.texture.width;
        int $$8 = this.texture.height;
        for (int $$9 = 0; $$9 <= 2 * p_419903_; ++$$9) {
            for (int $$10 = -$$9; $$10 <= $$9; ++$$10) {
                int $$11 = $$9 - Math.abs($$10);
                if ($$11 < 0 || $$11 > p_419903_ || $$10 * $$10 + $$11 * $$11 > p_419903_ * p_419903_) continue;
                if ($$11 != 0) {
                    this.tryBuildCell(p_364842_, p_418203_, p_362701_, p_361589_, p_418059_, $$10, $$7, -$$11, $$8, $$6);
                }
                this.tryBuildCell(p_364842_, p_418203_, p_362701_, p_361589_, p_418059_, $$10, $$7, $$11, $$8, $$6);
            }
        }
    }

    private void tryBuildCell(RelativeCameraPos p_428373_, ByteBuffer p_428298_, int p_428405_, int p_428485_, boolean p_428426_, int p_428326_, int p_428303_, int p_428570_, int p_428476_, long[] p_428541_) {
        int $$11;
        int $$10 = Math.floorMod(p_428405_ + p_428326_, p_428303_);
        long $$12 = p_428541_[$$10 + ($$11 = Math.floorMod(p_428485_ + p_428570_, p_428476_)) * p_428303_];
        if ($$12 == 0L) {
            return;
        }
        if (p_428426_) {
            this.buildExtrudedCell(p_428373_, p_428298_, p_428326_, p_428570_, $$12);
        } else {
            this.buildFlatCell(p_428298_, p_428326_, p_428570_);
        }
    }

    private void buildFlatCell(ByteBuffer p_418189_, int p_364027_, int p_361818_) {
        this.encodeFace(p_418189_, p_364027_, p_361818_, Direction.DOWN, 32);
    }

    private void encodeFace(ByteBuffer p_418193_, int p_418174_, int p_418379_, Direction p_418493_, int p_418242_) {
        int $$5 = p_418493_.get3DDataValue() | p_418242_;
        $$5 |= (p_418174_ & 1) << 7;
        p_418193_.put((byte)(p_418174_ >> 1)).put((byte)(p_418379_ >> 1)).put((byte)($$5 |= (p_418379_ & 1) << 6));
    }

    private void buildExtrudedCell(RelativeCameraPos p_360766_, ByteBuffer p_418364_, int p_362180_, int p_364234_, long p_364423_) {
        boolean $$5;
        if (p_360766_ != RelativeCameraPos.BELOW_CLOUDS) {
            this.encodeFace(p_418364_, p_362180_, p_364234_, Direction.UP, 0);
        }
        if (p_360766_ != RelativeCameraPos.ABOVE_CLOUDS) {
            this.encodeFace(p_418364_, p_362180_, p_364234_, Direction.DOWN, 0);
        }
        if (CloudRenderer.isNorthEmpty(p_364423_) && p_364234_ > 0) {
            this.encodeFace(p_418364_, p_362180_, p_364234_, Direction.NORTH, 0);
        }
        if (CloudRenderer.isSouthEmpty(p_364423_) && p_364234_ < 0) {
            this.encodeFace(p_418364_, p_362180_, p_364234_, Direction.SOUTH, 0);
        }
        if (CloudRenderer.isWestEmpty(p_364423_) && p_362180_ > 0) {
            this.encodeFace(p_418364_, p_362180_, p_364234_, Direction.WEST, 0);
        }
        if (CloudRenderer.isEastEmpty(p_364423_) && p_362180_ < 0) {
            this.encodeFace(p_418364_, p_362180_, p_364234_, Direction.EAST, 0);
        }
        boolean bl = $$5 = Math.abs(p_362180_) <= 1 && Math.abs(p_364234_) <= 1;
        if ($$5) {
            for (Direction $$6 : Direction.values()) {
                this.encodeFace(p_418364_, p_362180_, p_364234_, $$6, 16);
            }
        }
    }

    public void markForRebuild() {
        this.needsRebuild = true;
    }

    public void endFrame() {
        this.ubo.rotate();
    }

    @Override
    public void close() {
        this.ubo.close();
        if (this.utb != null) {
            this.utb.close();
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }

    static enum RelativeCameraPos {
        ABOVE_CLOUDS,
        INSIDE_CLOUDS,
        BELOW_CLOUDS;

    }

    public record TextureData(long[] cells, int width, int height) {
    }
}

