/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TrailParticle
extends TextureSheetParticle {
    private final Vec3 target;

    TrailParticle(ClientLevel p_380008_, double p_380201_, double p_380198_, double p_380357_, double p_380375_, double p_380026_, double p_379483_, Vec3 p_379353_, int p_379830_) {
        super(p_380008_, p_380201_, p_380198_, p_380357_, p_380375_, p_380026_, p_379483_);
        p_379830_ = ARGB.scaleRGB(p_379830_, 0.875f + this.random.nextFloat() * 0.25f, 0.875f + this.random.nextFloat() * 0.25f, 0.875f + this.random.nextFloat() * 0.25f);
        this.rCol = (float)ARGB.red(p_379830_) / 255.0f;
        this.gCol = (float)ARGB.green(p_379830_) / 255.0f;
        this.bCol = (float)ARGB.blue(p_379830_) / 255.0f;
        this.quadSize = 0.26f;
        this.target = p_379353_;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        int $$0 = this.lifetime - this.age;
        double $$1 = 1.0 / (double)$$0;
        this.x = Mth.lerp($$1, this.x, this.target.x());
        this.y = Mth.lerp($$1, this.y, this.target.y());
        this.z = Mth.lerp($$1, this.z, this.target.z());
    }

    @Override
    public int getLightColor(float p_379977_) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<TrailParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_380057_) {
            this.sprite = p_380057_;
        }

        @Override
        public Particle createParticle(TrailParticleOption p_383016_, ClientLevel p_379929_, double p_380369_, double p_380404_, double p_379536_, double p_380010_, double p_379607_, double p_379901_) {
            TrailParticle $$8 = new TrailParticle(p_379929_, p_380369_, p_380404_, p_379536_, p_380010_, p_379607_, p_379901_, p_383016_.target(), p_383016_.color());
            $$8.pickSprite(this.sprite);
            $$8.setLifetime(p_383016_.duration());
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((TrailParticleOption)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }
}

