/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.AshParticle;
import net.minecraft.client.particle.AttackSweepParticle;
import net.minecraft.client.particle.BlockMarker;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.BubblePopParticle;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.particle.DragonBreathParticle;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.DustColorTransitionParticle;
import net.minecraft.client.particle.DustParticle;
import net.minecraft.client.particle.DustPlumeParticle;
import net.minecraft.client.particle.EndRodParticle;
import net.minecraft.client.particle.ExplodeParticle;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.FallingLeavesParticle;
import net.minecraft.client.particle.FireflyParticle;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.FlyStraightTowardsParticle;
import net.minecraft.client.particle.FlyTowardsPositionParticle;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.GustParticle;
import net.minecraft.client.particle.GustSeedParticle;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.HugeExplosionSeedParticle;
import net.minecraft.client.particle.LargeSmokeParticle;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.NoteParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.PlayerCloudParticle;
import net.minecraft.client.particle.PortalParticle;
import net.minecraft.client.particle.ReversePortalParticle;
import net.minecraft.client.particle.SculkChargeParticle;
import net.minecraft.client.particle.SculkChargePopParticle;
import net.minecraft.client.particle.ShriekParticle;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.SonicBoomParticle;
import net.minecraft.client.particle.SoulParticle;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.SpitParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.SquidInkParticle;
import net.minecraft.client.particle.SuspendedParticle;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.particle.TotemParticle;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.particle.TrailParticle;
import net.minecraft.client.particle.TrialSpawnerDetectionParticle;
import net.minecraft.client.particle.VibrationSignalParticle;
import net.minecraft.client.particle.WakeParticle;
import net.minecraft.client.particle.WaterCurrentDownParticle;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.particle.WhiteAshParticle;
import net.minecraft.client.particle.WhiteSmokeParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasIds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class ParticleEngine
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter PARTICLE_LISTER = FileToIdConverter.json("particles");
    private static final int MAX_PARTICLES_PER_LAYER = 16384;
    private static final List<ParticleRenderType> RENDER_ORDER = List.of(ParticleRenderType.TERRAIN_SHEET, ParticleRenderType.PARTICLE_SHEET_OPAQUE, ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT);
    protected ClientLevel level;
    private final Map<ParticleRenderType, Queue<Particle>> particles = Maps.newIdentityHashMap();
    private final Queue<TrackingEmitter> trackingEmitters = Queues.newArrayDeque();
    private final RandomSource random = RandomSource.create();
    private final Int2ObjectMap<ParticleProvider<?>> providers = new Int2ObjectOpenHashMap();
    private final Queue<Particle> particlesToAdd = Queues.newArrayDeque();
    private final Map<ResourceLocation, MutableSpriteSet> spriteSets = Maps.newHashMap();
    private final TextureAtlas textureAtlas;
    private final Object2IntOpenHashMap<ParticleGroup> trackedParticleCounts = new Object2IntOpenHashMap();

    public ParticleEngine(ClientLevel p_107299_, TextureManager p_107300_) {
        this.textureAtlas = new TextureAtlas(TextureAtlas.LOCATION_PARTICLES);
        p_107300_.register(this.textureAtlas.location(), this.textureAtlas);
        this.level = p_107299_;
        this.registerProviders();
    }

    private void registerProviders() {
        this.register(ParticleTypes.ANGRY_VILLAGER, HeartParticle.AngryVillagerProvider::new);
        this.register(ParticleTypes.BLOCK_MARKER, new BlockMarker.Provider());
        this.register(ParticleTypes.BLOCK, new TerrainParticle.Provider());
        this.register(ParticleTypes.BUBBLE, BubbleParticle.Provider::new);
        this.register(ParticleTypes.BUBBLE_COLUMN_UP, BubbleColumnUpParticle.Provider::new);
        this.register(ParticleTypes.BUBBLE_POP, BubblePopParticle.Provider::new);
        this.register(ParticleTypes.CAMPFIRE_COSY_SMOKE, CampfireSmokeParticle.CosyProvider::new);
        this.register(ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, CampfireSmokeParticle.SignalProvider::new);
        this.register(ParticleTypes.CLOUD, PlayerCloudParticle.Provider::new);
        this.register(ParticleTypes.COMPOSTER, SuspendedTownParticle.ComposterFillProvider::new);
        this.register(ParticleTypes.CRIT, CritParticle.Provider::new);
        this.register(ParticleTypes.CURRENT_DOWN, WaterCurrentDownParticle.Provider::new);
        this.register(ParticleTypes.DAMAGE_INDICATOR, CritParticle.DamageIndicatorProvider::new);
        this.register(ParticleTypes.DRAGON_BREATH, DragonBreathParticle.Provider::new);
        this.register(ParticleTypes.DOLPHIN, SuspendedTownParticle.DolphinSpeedProvider::new);
        this.register(ParticleTypes.DRIPPING_LAVA, DripParticle::createLavaHangParticle);
        this.register(ParticleTypes.FALLING_LAVA, DripParticle::createLavaFallParticle);
        this.register(ParticleTypes.LANDING_LAVA, DripParticle::createLavaLandParticle);
        this.register(ParticleTypes.DRIPPING_WATER, DripParticle::createWaterHangParticle);
        this.register(ParticleTypes.FALLING_WATER, DripParticle::createWaterFallParticle);
        this.register(ParticleTypes.DUST, DustParticle.Provider::new);
        this.register(ParticleTypes.DUST_COLOR_TRANSITION, DustColorTransitionParticle.Provider::new);
        this.register(ParticleTypes.EFFECT, SpellParticle.Provider::new);
        this.register(ParticleTypes.ELDER_GUARDIAN, new MobAppearanceParticle.Provider());
        this.register(ParticleTypes.ENCHANTED_HIT, CritParticle.MagicProvider::new);
        this.register(ParticleTypes.ENCHANT, FlyTowardsPositionParticle.EnchantProvider::new);
        this.register(ParticleTypes.END_ROD, EndRodParticle.Provider::new);
        this.register(ParticleTypes.ENTITY_EFFECT, SpellParticle.MobEffectProvider::new);
        this.register(ParticleTypes.EXPLOSION_EMITTER, new HugeExplosionSeedParticle.Provider());
        this.register(ParticleTypes.EXPLOSION, HugeExplosionParticle.Provider::new);
        this.register(ParticleTypes.SONIC_BOOM, SonicBoomParticle.Provider::new);
        this.register(ParticleTypes.FALLING_DUST, FallingDustParticle.Provider::new);
        this.register(ParticleTypes.GUST, GustParticle.Provider::new);
        this.register(ParticleTypes.SMALL_GUST, GustParticle.SmallProvider::new);
        this.register(ParticleTypes.GUST_EMITTER_LARGE, new GustSeedParticle.Provider(3.0, 7, 0));
        this.register(ParticleTypes.GUST_EMITTER_SMALL, new GustSeedParticle.Provider(1.0, 3, 2));
        this.register(ParticleTypes.FIREWORK, FireworkParticles.SparkProvider::new);
        this.register(ParticleTypes.FISHING, WakeParticle.Provider::new);
        this.register(ParticleTypes.FLAME, FlameParticle.Provider::new);
        this.register(ParticleTypes.INFESTED, SpellParticle.Provider::new);
        this.register(ParticleTypes.SCULK_SOUL, SoulParticle.EmissiveProvider::new);
        this.register(ParticleTypes.SCULK_CHARGE, SculkChargeParticle.Provider::new);
        this.register(ParticleTypes.SCULK_CHARGE_POP, SculkChargePopParticle.Provider::new);
        this.register(ParticleTypes.SOUL, SoulParticle.Provider::new);
        this.register(ParticleTypes.SOUL_FIRE_FLAME, FlameParticle.Provider::new);
        this.register(ParticleTypes.FLASH, FireworkParticles.FlashProvider::new);
        this.register(ParticleTypes.HAPPY_VILLAGER, SuspendedTownParticle.HappyVillagerProvider::new);
        this.register(ParticleTypes.HEART, HeartParticle.Provider::new);
        this.register(ParticleTypes.INSTANT_EFFECT, SpellParticle.InstantProvider::new);
        this.register(ParticleTypes.ITEM, new BreakingItemParticle.Provider());
        this.register(ParticleTypes.ITEM_SLIME, new BreakingItemParticle.SlimeProvider());
        this.register(ParticleTypes.ITEM_COBWEB, new BreakingItemParticle.CobwebProvider());
        this.register(ParticleTypes.ITEM_SNOWBALL, new BreakingItemParticle.SnowballProvider());
        this.register(ParticleTypes.LARGE_SMOKE, LargeSmokeParticle.Provider::new);
        this.register(ParticleTypes.LAVA, LavaParticle.Provider::new);
        this.register(ParticleTypes.MYCELIUM, SuspendedTownParticle.Provider::new);
        this.register(ParticleTypes.NAUTILUS, FlyTowardsPositionParticle.NautilusProvider::new);
        this.register(ParticleTypes.NOTE, NoteParticle.Provider::new);
        this.register(ParticleTypes.POOF, ExplodeParticle.Provider::new);
        this.register(ParticleTypes.PORTAL, PortalParticle.Provider::new);
        this.register(ParticleTypes.RAIN, WaterDropParticle.Provider::new);
        this.register(ParticleTypes.SMOKE, SmokeParticle.Provider::new);
        this.register(ParticleTypes.WHITE_SMOKE, WhiteSmokeParticle.Provider::new);
        this.register(ParticleTypes.SNEEZE, PlayerCloudParticle.SneezeProvider::new);
        this.register(ParticleTypes.SNOWFLAKE, SnowflakeParticle.Provider::new);
        this.register(ParticleTypes.SPIT, SpitParticle.Provider::new);
        this.register(ParticleTypes.SWEEP_ATTACK, AttackSweepParticle.Provider::new);
        this.register(ParticleTypes.TOTEM_OF_UNDYING, TotemParticle.Provider::new);
        this.register(ParticleTypes.SQUID_INK, SquidInkParticle.Provider::new);
        this.register(ParticleTypes.UNDERWATER, SuspendedParticle.UnderwaterProvider::new);
        this.register(ParticleTypes.SPLASH, SplashParticle.Provider::new);
        this.register(ParticleTypes.WITCH, SpellParticle.WitchProvider::new);
        this.register(ParticleTypes.DRIPPING_HONEY, DripParticle::createHoneyHangParticle);
        this.register(ParticleTypes.FALLING_HONEY, DripParticle::createHoneyFallParticle);
        this.register(ParticleTypes.LANDING_HONEY, DripParticle::createHoneyLandParticle);
        this.register(ParticleTypes.FALLING_NECTAR, DripParticle::createNectarFallParticle);
        this.register(ParticleTypes.FALLING_SPORE_BLOSSOM, DripParticle::createSporeBlossomFallParticle);
        this.register(ParticleTypes.SPORE_BLOSSOM_AIR, SuspendedParticle.SporeBlossomAirProvider::new);
        this.register(ParticleTypes.ASH, AshParticle.Provider::new);
        this.register(ParticleTypes.CRIMSON_SPORE, SuspendedParticle.CrimsonSporeProvider::new);
        this.register(ParticleTypes.WARPED_SPORE, SuspendedParticle.WarpedSporeProvider::new);
        this.register(ParticleTypes.DRIPPING_OBSIDIAN_TEAR, DripParticle::createObsidianTearHangParticle);
        this.register(ParticleTypes.FALLING_OBSIDIAN_TEAR, DripParticle::createObsidianTearFallParticle);
        this.register(ParticleTypes.LANDING_OBSIDIAN_TEAR, DripParticle::createObsidianTearLandParticle);
        this.register(ParticleTypes.REVERSE_PORTAL, ReversePortalParticle.ReversePortalProvider::new);
        this.register(ParticleTypes.WHITE_ASH, WhiteAshParticle.Provider::new);
        this.register(ParticleTypes.SMALL_FLAME, FlameParticle.SmallFlameProvider::new);
        this.register(ParticleTypes.DRIPPING_DRIPSTONE_WATER, DripParticle::createDripstoneWaterHangParticle);
        this.register(ParticleTypes.FALLING_DRIPSTONE_WATER, DripParticle::createDripstoneWaterFallParticle);
        this.register(ParticleTypes.CHERRY_LEAVES, FallingLeavesParticle.CherryProvider::new);
        this.register(ParticleTypes.PALE_OAK_LEAVES, FallingLeavesParticle.PaleOakProvider::new);
        this.register(ParticleTypes.TINTED_LEAVES, FallingLeavesParticle.TintedLeavesProvider::new);
        this.register(ParticleTypes.DRIPPING_DRIPSTONE_LAVA, DripParticle::createDripstoneLavaHangParticle);
        this.register(ParticleTypes.FALLING_DRIPSTONE_LAVA, DripParticle::createDripstoneLavaFallParticle);
        this.register(ParticleTypes.VIBRATION, VibrationSignalParticle.Provider::new);
        this.register(ParticleTypes.TRAIL, TrailParticle.Provider::new);
        this.register(ParticleTypes.GLOW_SQUID_INK, SquidInkParticle.GlowInkProvider::new);
        this.register(ParticleTypes.GLOW, GlowParticle.GlowSquidProvider::new);
        this.register(ParticleTypes.WAX_ON, GlowParticle.WaxOnProvider::new);
        this.register(ParticleTypes.WAX_OFF, GlowParticle.WaxOffProvider::new);
        this.register(ParticleTypes.ELECTRIC_SPARK, GlowParticle.ElectricSparkProvider::new);
        this.register(ParticleTypes.SCRAPE, GlowParticle.ScrapeProvider::new);
        this.register(ParticleTypes.SHRIEK, ShriekParticle.Provider::new);
        this.register(ParticleTypes.EGG_CRACK, SuspendedTownParticle.EggCrackProvider::new);
        this.register(ParticleTypes.DUST_PLUME, DustPlumeParticle.Provider::new);
        this.register(ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER, TrialSpawnerDetectionParticle.Provider::new);
        this.register(ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, TrialSpawnerDetectionParticle.Provider::new);
        this.register(ParticleTypes.VAULT_CONNECTION, FlyTowardsPositionParticle.VaultConnectionProvider::new);
        this.register(ParticleTypes.DUST_PILLAR, new TerrainParticle.DustPillarProvider());
        this.register(ParticleTypes.RAID_OMEN, SpellParticle.Provider::new);
        this.register(ParticleTypes.TRIAL_OMEN, SpellParticle.Provider::new);
        this.register(ParticleTypes.OMINOUS_SPAWNING, FlyStraightTowardsParticle.OminousSpawnProvider::new);
        this.register(ParticleTypes.BLOCK_CRUMBLE, new TerrainParticle.CrumblingProvider());
        this.register(ParticleTypes.FIREFLY, FireflyParticle.FireflyProvider::new);
    }

    private <T extends ParticleOptions> void register(ParticleType<T> p_107382_, ParticleProvider<T> p_107383_) {
        this.providers.put(BuiltInRegistries.PARTICLE_TYPE.getId(p_107382_), p_107383_);
    }

    private <T extends ParticleOptions> void register(ParticleType<T> p_273423_, ParticleProvider.Sprite<T> p_273134_) {
        this.register(p_273423_, (SpriteSet p_272320_) -> (p_272323_, p_272324_, p_272325_, p_272326_, p_272327_, p_272328_, p_272329_, p_272330_) -> {
            TextureSheetParticle $$10 = p_273134_.createParticle(p_272323_, p_272324_, p_272325_, p_272326_, p_272327_, p_272328_, p_272329_, p_272330_);
            if ($$10 != null) {
                $$10.pickSprite(p_272320_);
            }
            return $$10;
        });
    }

    private <T extends ParticleOptions> void register(ParticleType<T> p_107379_, SpriteParticleRegistration<T> p_107380_) {
        MutableSpriteSet $$2 = new MutableSpriteSet();
        this.spriteSets.put(BuiltInRegistries.PARTICLE_TYPE.getKey(p_107379_), $$2);
        this.providers.put(BuiltInRegistries.PARTICLE_TYPE.getId(p_107379_), p_107380_.create($$2));
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_107305_, ResourceManager p_107306_, Executor p_107309_, Executor p_107310_) {
        CompletionStage $$4 = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.listMatchingResources(p_107306_), p_107309_).thenCompose(p_247914_ -> {
            ArrayList $$2 = new ArrayList(p_247914_.size());
            p_247914_.forEach((p_247903_, p_247904_) -> {
                ResourceLocation $$4 = PARTICLE_LISTER.fileToId((ResourceLocation)p_247903_);
                $$2.add(CompletableFuture.supplyAsync(() -> {
                    record ParticleDefinition(ResourceLocation id, Optional<List<ResourceLocation>> sprites) {
                    }
                    return new ParticleDefinition($$4, this.loadParticleDescription($$4, (Resource)p_247904_));
                }, p_107309_));
            });
            return Util.sequence($$2);
        });
        CompletionStage $$5 = SpriteLoader.create(this.textureAtlas).loadAndStitch(p_107306_, AtlasIds.PARTICLES, 0, p_107309_).thenCompose(SpriteLoader.Preparations::waitForUpload);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{$$5, $$4}).thenCompose(p_107305_::wait)).thenAcceptAsync(arg_0 -> this.lambda$reload$7((CompletableFuture)$$5, (CompletableFuture)$$4, arg_0), p_107310_);
    }

    public void close() {
        this.textureAtlas.clearTextureData();
    }

    private Optional<List<ResourceLocation>> loadParticleDescription(ResourceLocation p_250648_, Resource p_248793_) {
        Optional<List<ResourceLocation>> optional;
        block9: {
            if (!this.spriteSets.containsKey(p_250648_)) {
                LOGGER.debug("Redundant texture list for particle: {}", (Object)p_250648_);
                return Optional.empty();
            }
            BufferedReader $$2 = p_248793_.openAsReader();
            try {
                ParticleDescription $$3 = ParticleDescription.fromJson(GsonHelper.parse($$2));
                optional = Optional.of($$3.getTextures());
                if ($$2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$2 != null) {
                        try {
                            ((Reader)$$2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException $$4) {
                    throw new IllegalStateException("Failed to load description for particle " + String.valueOf(p_250648_), $$4);
                }
            }
            ((Reader)$$2).close();
        }
        return optional;
    }

    public void createTrackingEmitter(Entity p_107330_, ParticleOptions p_107331_) {
        this.trackingEmitters.add(new TrackingEmitter(this.level, p_107330_, p_107331_));
    }

    public void createTrackingEmitter(Entity p_107333_, ParticleOptions p_107334_, int p_107335_) {
        this.trackingEmitters.add(new TrackingEmitter(this.level, p_107333_, p_107334_, p_107335_));
    }

    @Nullable
    public Particle createParticle(ParticleOptions p_107371_, double p_107372_, double p_107373_, double p_107374_, double p_107375_, double p_107376_, double p_107377_) {
        Particle $$7 = this.makeParticle(p_107371_, p_107372_, p_107373_, p_107374_, p_107375_, p_107376_, p_107377_);
        if ($$7 != null) {
            this.add($$7);
            return $$7;
        }
        return null;
    }

    @Nullable
    private <T extends ParticleOptions> Particle makeParticle(T p_107396_, double p_107397_, double p_107398_, double p_107399_, double p_107400_, double p_107401_, double p_107402_) {
        ParticleProvider $$7 = (ParticleProvider)this.providers.get(BuiltInRegistries.PARTICLE_TYPE.getId(p_107396_.getType()));
        if ($$7 == null) {
            return null;
        }
        return $$7.createParticle(p_107396_, this.level, p_107397_, p_107398_, p_107399_, p_107400_, p_107401_, p_107402_);
    }

    public void add(Particle p_107345_) {
        Optional<ParticleGroup> $$1 = p_107345_.getParticleGroup();
        if ($$1.isPresent()) {
            if (this.hasSpaceInParticleLimit($$1.get())) {
                this.particlesToAdd.add(p_107345_);
                this.updateCount($$1.get(), 1);
            }
        } else {
            this.particlesToAdd.add(p_107345_);
        }
    }

    public void tick() {
        this.particles.forEach((p_382525_, p_382526_) -> {
            Profiler.get().push(p_382525_.toString());
            this.tickParticleList((Collection<Particle>)p_382526_);
            Profiler.get().pop();
        });
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList $$0 = Lists.newArrayList();
            for (TrackingEmitter $$1 : this.trackingEmitters) {
                $$1.tick();
                if ($$1.isAlive()) continue;
                $$0.add($$1);
            }
            this.trackingEmitters.removeAll($$0);
        }
        if (!this.particlesToAdd.isEmpty()) {
            Particle $$2;
            while (($$2 = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent($$2.getRenderType(), p_107347_ -> EvictingQueue.create((int)16384)).add($$2);
            }
        }
    }

    private void tickParticleList(Collection<Particle> p_107385_) {
        if (!p_107385_.isEmpty()) {
            Iterator<Particle> $$1 = p_107385_.iterator();
            while ($$1.hasNext()) {
                Particle $$2 = $$1.next();
                this.tickParticle($$2);
                if ($$2.isAlive()) continue;
                $$2.getParticleGroup().ifPresent(p_172289_ -> this.updateCount((ParticleGroup)p_172289_, -1));
                $$1.remove();
            }
        }
    }

    private void updateCount(ParticleGroup p_172282_, int p_172283_) {
        this.trackedParticleCounts.addTo((Object)p_172282_, p_172283_);
    }

    private void tickParticle(Particle p_107394_) {
        try {
            p_107394_.tick();
        }
        catch (Throwable $$1) {
            CrashReport $$2 = CrashReport.forThrowable($$1, "Ticking Particle");
            CrashReportCategory $$3 = $$2.addCategory("Particle being ticked");
            $$3.setDetail("Particle", p_107394_::toString);
            $$3.setDetail("Particle Type", p_107394_.getRenderType()::toString);
            throw new ReportedException($$2);
        }
    }

    public void render(Camera p_107340_, float p_107341_, MultiBufferSource.BufferSource p_383193_) {
        for (ParticleRenderType $$3 : RENDER_ORDER) {
            Queue<Particle> $$4 = this.particles.get($$3);
            if ($$4 == null || $$4.isEmpty()) continue;
            ParticleEngine.renderParticleType(p_107340_, p_107341_, p_383193_, $$3, $$4);
        }
        Queue<Particle> $$5 = this.particles.get(ParticleRenderType.CUSTOM);
        if ($$5 != null && !$$5.isEmpty()) {
            ParticleEngine.renderCustomParticles(p_107340_, p_107341_, p_383193_, $$5);
        }
        p_383193_.endBatch();
    }

    private static void renderParticleType(Camera p_382847_, float p_383032_, MultiBufferSource.BufferSource p_383105_, ParticleRenderType p_383179_, Queue<Particle> p_383046_) {
        VertexConsumer $$5 = p_383105_.getBuffer(Objects.requireNonNull(p_383179_.renderType()));
        for (Particle $$6 : p_383046_) {
            try {
                $$6.render($$5, p_382847_, p_383032_);
            }
            catch (Throwable $$7) {
                CrashReport $$8 = CrashReport.forThrowable($$7, "Rendering Particle");
                CrashReportCategory $$9 = $$8.addCategory("Particle being rendered");
                $$9.setDetail("Particle", $$6::toString);
                $$9.setDetail("Particle Type", p_383179_::toString);
                throw new ReportedException($$8);
            }
        }
    }

    private static void renderCustomParticles(Camera p_383089_, float p_383167_, MultiBufferSource.BufferSource p_382990_, Queue<Particle> p_383010_) {
        PoseStack $$4 = new PoseStack();
        for (Particle $$5 : p_383010_) {
            try {
                $$5.renderCustom($$4, p_382990_, p_383089_, p_383167_);
            }
            catch (Throwable $$6) {
                CrashReport $$7 = CrashReport.forThrowable($$6, "Rendering Particle");
                CrashReportCategory $$8 = $$7.addCategory("Particle being rendered");
                $$8.setDetail("Particle", $$5::toString);
                $$8.setDetail("Particle Type", "Custom");
                throw new ReportedException($$7);
            }
        }
    }

    public void setLevel(@Nullable ClientLevel p_107343_) {
        this.level = p_107343_;
        this.clearParticles();
        this.trackingEmitters.clear();
    }

    public void destroy(BlockPos p_107356_, BlockState p_107357_) {
        if (p_107357_.isAir() || !p_107357_.shouldSpawnTerrainParticles()) {
            return;
        }
        VoxelShape $$2 = p_107357_.getShape(this.level, p_107356_);
        double $$3 = 0.25;
        $$2.forAllBoxes((p_172273_, p_172274_, p_172275_, p_172276_, p_172277_, p_172278_) -> {
            double $$8 = Math.min(1.0, p_172276_ - p_172273_);
            double $$9 = Math.min(1.0, p_172277_ - p_172274_);
            double $$10 = Math.min(1.0, p_172278_ - p_172275_);
            int $$11 = Math.max(2, Mth.ceil($$8 / 0.25));
            int $$12 = Math.max(2, Mth.ceil($$9 / 0.25));
            int $$13 = Math.max(2, Mth.ceil($$10 / 0.25));
            for (int $$14 = 0; $$14 < $$11; ++$$14) {
                for (int $$15 = 0; $$15 < $$12; ++$$15) {
                    for (int $$16 = 0; $$16 < $$13; ++$$16) {
                        double $$17 = ((double)$$14 + 0.5) / (double)$$11;
                        double $$18 = ((double)$$15 + 0.5) / (double)$$12;
                        double $$19 = ((double)$$16 + 0.5) / (double)$$13;
                        double $$20 = $$17 * $$8 + p_172273_;
                        double $$21 = $$18 * $$9 + p_172274_;
                        double $$22 = $$19 * $$10 + p_172275_;
                        this.add(new TerrainParticle(this.level, (double)p_107356_.getX() + $$20, (double)p_107356_.getY() + $$21, (double)p_107356_.getZ() + $$22, $$17 - 0.5, $$18 - 0.5, $$19 - 0.5, p_107357_, p_107356_));
                    }
                }
            }
        });
    }

    public void crack(BlockPos p_107368_, Direction p_107369_) {
        BlockState $$2 = this.level.getBlockState(p_107368_);
        if ($$2.getRenderShape() == RenderShape.INVISIBLE || !$$2.shouldSpawnTerrainParticles()) {
            return;
        }
        int $$3 = p_107368_.getX();
        int $$4 = p_107368_.getY();
        int $$5 = p_107368_.getZ();
        float $$6 = 0.1f;
        AABB $$7 = $$2.getShape(this.level, p_107368_).bounds();
        double $$8 = (double)$$3 + this.random.nextDouble() * ($$7.maxX - $$7.minX - (double)0.2f) + (double)0.1f + $$7.minX;
        double $$9 = (double)$$4 + this.random.nextDouble() * ($$7.maxY - $$7.minY - (double)0.2f) + (double)0.1f + $$7.minY;
        double $$10 = (double)$$5 + this.random.nextDouble() * ($$7.maxZ - $$7.minZ - (double)0.2f) + (double)0.1f + $$7.minZ;
        if (p_107369_ == Direction.DOWN) {
            $$9 = (double)$$4 + $$7.minY - (double)0.1f;
        }
        if (p_107369_ == Direction.UP) {
            $$9 = (double)$$4 + $$7.maxY + (double)0.1f;
        }
        if (p_107369_ == Direction.NORTH) {
            $$10 = (double)$$5 + $$7.minZ - (double)0.1f;
        }
        if (p_107369_ == Direction.SOUTH) {
            $$10 = (double)$$5 + $$7.maxZ + (double)0.1f;
        }
        if (p_107369_ == Direction.WEST) {
            $$8 = (double)$$3 + $$7.minX - (double)0.1f;
        }
        if (p_107369_ == Direction.EAST) {
            $$8 = (double)$$3 + $$7.maxX + (double)0.1f;
        }
        this.add(new TerrainParticle(this.level, $$8, $$9, $$10, 0.0, 0.0, 0.0, $$2, p_107368_).setPower(0.2f).scale(0.6f));
    }

    public String countParticles() {
        return String.valueOf(this.particles.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean hasSpaceInParticleLimit(ParticleGroup p_172280_) {
        return this.trackedParticleCounts.getInt((Object)p_172280_) < p_172280_.getLimit();
    }

    private void clearParticles() {
        this.particles.clear();
        this.particlesToAdd.clear();
        this.trackingEmitters.clear();
        this.trackedParticleCounts.clear();
    }

    private /* synthetic */ void lambda$reload$7(CompletableFuture p_372546_, CompletableFuture p_372547_, Void p_372548_) {
        this.clearParticles();
        ProfilerFiller $$3 = Profiler.get();
        $$3.push("upload");
        SpriteLoader.Preparations $$4 = (SpriteLoader.Preparations)p_372546_.join();
        this.textureAtlas.upload($$4);
        $$3.popPush("bindSpriteSets");
        HashSet $$5 = new HashSet();
        TextureAtlasSprite $$6 = $$4.missing();
        ((List)p_372547_.join()).forEach(p_247911_ -> {
            Optional<List<ResourceLocation>> $$4 = p_247911_.sprites();
            if ($$4.isEmpty()) {
                return;
            }
            ArrayList<TextureAtlasSprite> $$5 = new ArrayList<TextureAtlasSprite>();
            for (ResourceLocation $$6 : $$4.get()) {
                TextureAtlasSprite $$7 = $$4.regions().get($$6);
                if ($$7 == null) {
                    $$5.add($$6);
                    $$5.add($$6);
                    continue;
                }
                $$5.add($$7);
            }
            if ($$5.isEmpty()) {
                $$5.add($$6);
            }
            this.spriteSets.get(p_247911_.id()).rebind($$5);
        });
        if (!$$5.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)$$5.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
        $$3.pop();
    }

    @FunctionalInterface
    static interface SpriteParticleRegistration<T extends ParticleOptions> {
        public ParticleProvider<T> create(SpriteSet var1);
    }

    static class MutableSpriteSet
    implements SpriteSet {
        private List<TextureAtlasSprite> sprites;

        MutableSpriteSet() {
        }

        @Override
        public TextureAtlasSprite get(int p_107413_, int p_107414_) {
            return this.sprites.get(p_107413_ * (this.sprites.size() - 1) / p_107414_);
        }

        @Override
        public TextureAtlasSprite get(RandomSource p_233889_) {
            return this.sprites.get(p_233889_.nextInt(this.sprites.size()));
        }

        public void rebind(List<TextureAtlasSprite> p_107416_) {
            this.sprites = ImmutableList.copyOf(p_107416_);
        }
    }
}

