/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.component.FireworkExplosion;

public class FireworkParticles {

    public static class SparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SparkProvider(SpriteSet p_106733_) {
            this.sprites = p_106733_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_106744_, ClientLevel p_106745_, double p_106746_, double p_106747_, double p_106748_, double p_106749_, double p_106750_, double p_106751_) {
            SparkParticle $$8 = new SparkParticle(p_106745_, p_106746_, p_106747_, p_106748_, p_106749_, p_106750_, p_106751_, Minecraft.getInstance().particleEngine, this.sprites);
            $$8.setAlpha(0.99f);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class FlashProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public FlashProvider(SpriteSet p_106657_) {
            this.sprite = p_106657_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_106668_, ClientLevel p_106669_, double p_106670_, double p_106671_, double p_106672_, double p_106673_, double p_106674_, double p_106675_) {
            OverlayParticle $$8 = new OverlayParticle(p_106669_, p_106670_, p_106671_, p_106672_);
            $$8.pickSprite(this.sprite);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class OverlayParticle
    extends TextureSheetParticle {
        OverlayParticle(ClientLevel p_106677_, double p_106678_, double p_106679_, double p_106680_) {
            super(p_106677_, p_106678_, p_106679_, p_106680_);
            this.lifetime = 4;
        }

        @Override
        public ParticleRenderType getRenderType() {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }

        @Override
        public void render(VertexConsumer p_106688_, Camera p_106689_, float p_106690_) {
            this.setAlpha(0.6f - ((float)this.age + p_106690_ - 1.0f) * 0.25f * 0.5f);
            super.render(p_106688_, p_106689_, p_106690_);
        }

        @Override
        public float getQuadSize(float p_106693_) {
            return 7.1f * Mth.sin(((float)this.age + p_106693_ - 1.0f) * 0.25f * (float)Math.PI);
        }
    }

    static class SparkParticle
    extends SimpleAnimatedParticle {
        private boolean trail;
        private boolean twinkle;
        private final ParticleEngine engine;
        private float fadeR;
        private float fadeG;
        private float fadeB;
        private boolean hasFade;

        SparkParticle(ClientLevel p_106702_, double p_106703_, double p_106704_, double p_106705_, double p_106706_, double p_106707_, double p_106708_, ParticleEngine p_106709_, SpriteSet p_106710_) {
            super(p_106702_, p_106703_, p_106704_, p_106705_, p_106710_, 0.1f);
            this.xd = p_106706_;
            this.yd = p_106707_;
            this.zd = p_106708_;
            this.engine = p_106709_;
            this.quadSize *= 0.75f;
            this.lifetime = 48 + this.random.nextInt(12);
            this.setSpriteFromAge(p_106710_);
        }

        public void setTrail(boolean p_106728_) {
            this.trail = p_106728_;
        }

        public void setTwinkle(boolean p_331940_) {
            this.twinkle = p_331940_;
        }

        @Override
        public void render(VertexConsumer p_106724_, Camera p_106725_, float p_106726_) {
            if (!this.twinkle || this.age < this.lifetime / 3 || (this.age + this.lifetime) / 3 % 2 == 0) {
                super.render(p_106724_, p_106725_, p_106726_);
            }
        }

        @Override
        public void tick() {
            super.tick();
            if (this.trail && this.age < this.lifetime / 2 && (this.age + this.lifetime) % 2 == 0) {
                SparkParticle $$0 = new SparkParticle(this.level, this.x, this.y, this.z, 0.0, 0.0, 0.0, this.engine, this.sprites);
                $$0.setAlpha(0.99f);
                $$0.setColor(this.rCol, this.gCol, this.bCol);
                $$0.age = $$0.lifetime / 2;
                if (this.hasFade) {
                    $$0.hasFade = true;
                    $$0.fadeR = this.fadeR;
                    $$0.fadeG = this.fadeG;
                    $$0.fadeB = this.fadeB;
                }
                $$0.twinkle = this.twinkle;
                this.engine.add($$0);
            }
        }
    }

    public static class Starter
    extends NoRenderParticle {
        private static final double[][] CREEPER_PARTICLE_COORDS = new double[][]{{0.0, 0.2}, {0.2, 0.2}, {0.2, 0.6}, {0.6, 0.6}, {0.6, 0.2}, {0.2, 0.2}, {0.2, 0.0}, {0.4, 0.0}, {0.4, -0.6}, {0.2, -0.6}, {0.2, -0.4}, {0.0, -0.4}};
        private static final double[][] STAR_PARTICLE_COORDS = new double[][]{{0.0, 1.0}, {0.3455, 0.309}, {0.9511, 0.309}, {0.3795918367346939, -0.12653061224489795}, {0.6122448979591837, -0.8040816326530612}, {0.0, -0.35918367346938773}};
        private int life;
        private final ParticleEngine engine;
        private final List<FireworkExplosion> explosions;
        private boolean twinkleDelay;

        public Starter(ClientLevel p_106757_, double p_106758_, double p_106759_, double p_106760_, double p_106761_, double p_106762_, double p_106763_, ParticleEngine p_106764_, List<FireworkExplosion> p_330899_) {
            super(p_106757_, p_106758_, p_106759_, p_106760_);
            this.xd = p_106761_;
            this.yd = p_106762_;
            this.zd = p_106763_;
            this.engine = p_106764_;
            if (p_330899_.isEmpty()) {
                throw new IllegalArgumentException("Cannot create firework starter with no explosions");
            }
            this.explosions = p_330899_;
            this.lifetime = p_330899_.size() * 2 - 1;
            for (FireworkExplosion $$9 : p_330899_) {
                if (!$$9.hasTwinkle()) continue;
                this.twinkleDelay = true;
                this.lifetime += 15;
                break;
            }
        }

        @Override
        public void tick() {
            if (this.life == 0) {
                SoundEvent $$4;
                boolean $$0 = this.isFarAwayFromCamera();
                boolean $$1 = false;
                if (this.explosions.size() >= 3) {
                    $$1 = true;
                } else {
                    for (FireworkExplosion $$2 : this.explosions) {
                        if ($$2.shape() != FireworkExplosion.Shape.LARGE_BALL) continue;
                        $$1 = true;
                        break;
                    }
                }
                if ($$1) {
                    SoundEvent $$3 = $$0 ? SoundEvents.FIREWORK_ROCKET_LARGE_BLAST_FAR : SoundEvents.FIREWORK_ROCKET_LARGE_BLAST;
                } else {
                    $$4 = $$0 ? SoundEvents.FIREWORK_ROCKET_BLAST_FAR : SoundEvents.FIREWORK_ROCKET_BLAST;
                }
                this.level.playLocalSound(this.x, this.y, this.z, $$4, SoundSource.AMBIENT, 20.0f, 0.95f + this.random.nextFloat() * 0.1f, true);
            }
            if (this.life % 2 == 0 && this.life / 2 < this.explosions.size()) {
                int $$5 = this.life / 2;
                FireworkExplosion $$6 = this.explosions.get($$5);
                boolean $$7 = $$6.hasTrail();
                boolean $$8 = $$6.hasTwinkle();
                IntList $$9 = $$6.colors();
                IntList $$10 = $$6.fadeColors();
                if ($$9.isEmpty()) {
                    $$9 = IntList.of((int)DyeColor.BLACK.getFireworkColor());
                }
                switch ($$6.shape()) {
                    case SMALL_BALL: {
                        this.createParticleBall(0.25, 2, $$9, $$10, $$7, $$8);
                        break;
                    }
                    case LARGE_BALL: {
                        this.createParticleBall(0.5, 4, $$9, $$10, $$7, $$8);
                        break;
                    }
                    case STAR: {
                        this.createParticleShape(0.5, STAR_PARTICLE_COORDS, $$9, $$10, $$7, $$8, false);
                        break;
                    }
                    case CREEPER: {
                        this.createParticleShape(0.5, CREEPER_PARTICLE_COORDS, $$9, $$10, $$7, $$8, true);
                        break;
                    }
                    case BURST: {
                        this.createParticleBurst($$9, $$10, $$7, $$8);
                    }
                }
                int $$11 = $$9.getInt(0);
                Particle $$12 = this.engine.createParticle(ParticleTypes.FLASH, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                $$12.setColor((float)ARGB.red($$11) / 255.0f, (float)ARGB.green($$11) / 255.0f, (float)ARGB.blue($$11) / 255.0f);
            }
            ++this.life;
            if (this.life > this.lifetime) {
                if (this.twinkleDelay) {
                    boolean $$13 = this.isFarAwayFromCamera();
                    SoundEvent $$14 = $$13 ? SoundEvents.FIREWORK_ROCKET_TWINKLE_FAR : SoundEvents.FIREWORK_ROCKET_TWINKLE;
                    this.level.playLocalSound(this.x, this.y, this.z, $$14, SoundSource.AMBIENT, 20.0f, 0.9f + this.random.nextFloat() * 0.15f, true);
                }
                this.remove();
            }
        }

        private boolean isFarAwayFromCamera() {
            Minecraft $$0 = Minecraft.getInstance();
            return $$0.gameRenderer.getMainCamera().getPosition().distanceToSqr(this.x, this.y, this.z) >= 256.0;
        }

        private void createParticle(double p_106768_, double p_106769_, double p_106770_, double p_106771_, double p_106772_, double p_106773_, IntList p_330262_, IntList p_330897_, boolean p_106776_, boolean p_106777_) {
            SparkParticle $$10 = (SparkParticle)this.engine.createParticle(ParticleTypes.FIREWORK, p_106768_, p_106769_, p_106770_, p_106771_, p_106772_, p_106773_);
            $$10.setTrail(p_106776_);
            $$10.setTwinkle(p_106777_);
            $$10.setAlpha(0.99f);
            $$10.setColor((Integer)Util.getRandom(p_330262_, this.random));
            if (!p_330897_.isEmpty()) {
                $$10.setFadeColor((Integer)Util.getRandom(p_330897_, this.random));
            }
        }

        private void createParticleBall(double p_106779_, int p_106780_, IntList p_331243_, IntList p_330912_, boolean p_106783_, boolean p_106784_) {
            double $$6 = this.x;
            double $$7 = this.y;
            double $$8 = this.z;
            for (int $$9 = -p_106780_; $$9 <= p_106780_; ++$$9) {
                for (int $$10 = -p_106780_; $$10 <= p_106780_; ++$$10) {
                    for (int $$11 = -p_106780_; $$11 <= p_106780_; ++$$11) {
                        double $$12 = (double)$$10 + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double $$13 = (double)$$9 + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double $$14 = (double)$$11 + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double $$15 = Math.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14) / p_106779_ + this.random.nextGaussian() * 0.05;
                        this.createParticle($$6, $$7, $$8, $$12 / $$15, $$13 / $$15, $$14 / $$15, p_331243_, p_330912_, p_106783_, p_106784_);
                        if ($$9 == -p_106780_ || $$9 == p_106780_ || $$10 == -p_106780_ || $$10 == p_106780_) continue;
                        $$11 += p_106780_ * 2 - 1;
                    }
                }
            }
        }

        private void createParticleShape(double p_106786_, double[][] p_106787_, IntList p_330715_, IntList p_331438_, boolean p_106790_, boolean p_106791_, boolean p_106792_) {
            double $$7 = p_106787_[0][0];
            double $$8 = p_106787_[0][1];
            this.createParticle(this.x, this.y, this.z, $$7 * p_106786_, $$8 * p_106786_, 0.0, p_330715_, p_331438_, p_106790_, p_106791_);
            float $$9 = this.random.nextFloat() * (float)Math.PI;
            double $$10 = p_106792_ ? 0.034 : 0.34;
            for (int $$11 = 0; $$11 < 3; ++$$11) {
                double $$12 = (double)$$9 + (double)((float)$$11 * (float)Math.PI) * $$10;
                double $$13 = $$7;
                double $$14 = $$8;
                for (int $$15 = 1; $$15 < p_106787_.length; ++$$15) {
                    double $$16 = p_106787_[$$15][0];
                    double $$17 = p_106787_[$$15][1];
                    for (double $$18 = 0.25; $$18 <= 1.0; $$18 += 0.25) {
                        double $$19 = Mth.lerp($$18, $$13, $$16) * p_106786_;
                        double $$20 = Mth.lerp($$18, $$14, $$17) * p_106786_;
                        double $$21 = $$19 * Math.sin($$12);
                        $$19 *= Math.cos($$12);
                        for (double $$22 = -1.0; $$22 <= 1.0; $$22 += 2.0) {
                            this.createParticle(this.x, this.y, this.z, $$19 * $$22, $$20, $$21 * $$22, p_330715_, p_331438_, p_106790_, p_106791_);
                        }
                    }
                    $$13 = $$16;
                    $$14 = $$17;
                }
            }
        }

        private void createParticleBurst(IntList p_330681_, IntList p_331575_, boolean p_106796_, boolean p_106797_) {
            double $$4 = this.random.nextGaussian() * 0.05;
            double $$5 = this.random.nextGaussian() * 0.05;
            for (int $$6 = 0; $$6 < 70; ++$$6) {
                double $$7 = this.xd * 0.5 + this.random.nextGaussian() * 0.15 + $$4;
                double $$8 = this.zd * 0.5 + this.random.nextGaussian() * 0.15 + $$5;
                double $$9 = this.yd * 0.5 + this.random.nextDouble() * 0.5;
                this.createParticle(this.x, this.y, this.z, $$7, $$9, $$8, p_330681_, p_331575_, p_106796_, p_106797_);
            }
        }
    }
}

