/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.multiplayer.ClientRegistryLayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagNetworkSerialization;

public class RegistryDataCollector {
    @Nullable
    private ContentsCollector contentsCollector;
    @Nullable
    private TagCollector tagCollector;

    public void appendContents(ResourceKey<? extends Registry<?>> p_321794_, List<RegistrySynchronization.PackedRegistryEntry> p_321772_) {
        if (this.contentsCollector == null) {
            this.contentsCollector = new ContentsCollector();
        }
        this.contentsCollector.append(p_321794_, p_321772_);
    }

    public void appendTags(Map<ResourceKey<? extends Registry<?>>, TagNetworkSerialization.NetworkPayload> p_321771_) {
        if (this.tagCollector == null) {
            this.tagCollector = new TagCollector();
        }
        p_321771_.forEach(this.tagCollector::append);
    }

    private static <T> Registry.PendingTags<T> resolveRegistryTags(RegistryAccess.Frozen p_361269_, ResourceKey<? extends Registry<? extends T>> p_363497_, TagNetworkSerialization.NetworkPayload p_364570_) {
        HolderLookup.RegistryLookup $$3 = p_361269_.lookupOrThrow((ResourceKey)p_363497_);
        return $$3.prepareTagReload(p_364570_.resolve($$3));
    }

    /*
     * WARNING - void declaration
     */
    private RegistryAccess loadNewElementsAndTags(ResourceProvider p_363026_, ContentsCollector p_360790_, boolean p_360761_) {
        void $$11;
        LayeredRegistryAccess<ClientRegistryLayer> $$3 = ClientRegistryLayer.createRegistryAccess();
        RegistryAccess.Frozen $$4 = $$3.getAccessForLoading(ClientRegistryLayer.REMOTE);
        HashMap $$5 = new HashMap();
        p_360790_.elements.forEach((p_360955_, p_361011_) -> $$5.put((ResourceKey<? extends Registry<?>>)p_360955_, new RegistryDataLoader.NetworkedRegistryData((List<RegistrySynchronization.PackedRegistryEntry>)p_361011_, TagNetworkSerialization.NetworkPayload.EMPTY)));
        ArrayList $$6 = new ArrayList();
        if (this.tagCollector != null) {
            this.tagCollector.forEach((p_364406_, p_365188_) -> {
                if (p_365188_.isEmpty()) {
                    return;
                }
                if (RegistrySynchronization.isNetworkable(p_364406_)) {
                    $$5.compute((ResourceKey<? extends Registry<?>>)p_364406_, (p_363401_, p_364225_) -> {
                        List<RegistrySynchronization.PackedRegistryEntry> $$3 = p_364225_ != null ? p_364225_.elements() : List.of();
                        return new RegistryDataLoader.NetworkedRegistryData($$3, (TagNetworkSerialization.NetworkPayload)p_365188_);
                    });
                } else if (!p_360761_) {
                    $$6.add(RegistryDataCollector.resolveRegistryTags($$4, p_364406_, p_365188_));
                }
            });
        }
        List<HolderLookup.RegistryLookup<?>> $$7 = TagLoader.buildUpdatedLookups($$4, $$6);
        try {
            RegistryAccess.Frozen $$8 = RegistryDataLoader.load($$5, p_363026_, $$7, RegistryDataLoader.SYNCHRONIZED_REGISTRIES).freeze();
        }
        catch (Exception $$9) {
            CrashReport $$10 = CrashReport.forThrowable($$9, "Network Registry Load");
            RegistryDataCollector.addCrashDetails($$10, $$5, $$6);
            throw new ReportedException($$10);
        }
        RegistryAccess.Frozen $$12 = $$3.replaceFrom(ClientRegistryLayer.REMOTE, new RegistryAccess.Frozen[]{$$11}).compositeAccess();
        $$6.forEach(Registry.PendingTags::apply);
        return $$12;
    }

    private static void addCrashDetails(CrashReport p_380152_, Map<ResourceKey<? extends Registry<?>>, RegistryDataLoader.NetworkedRegistryData> p_380213_, List<Registry.PendingTags<?>> p_379926_) {
        CrashReportCategory $$3 = p_380152_.addCategory("Received Elements and Tags");
        $$3.setDetail("Dynamic Registries", () -> p_380213_.entrySet().stream().sorted(Comparator.comparing(p_378804_ -> ((ResourceKey)p_378804_.getKey()).location())).map(p_378806_ -> String.format(Locale.ROOT, "\n\t\t%s: elements=%d tags=%d", ((ResourceKey)p_378806_.getKey()).location(), ((RegistryDataLoader.NetworkedRegistryData)p_378806_.getValue()).elements().size(), ((RegistryDataLoader.NetworkedRegistryData)p_378806_.getValue()).tags().size())).collect(Collectors.joining()));
        $$3.setDetail("Static Registries", () -> p_379926_.stream().sorted(Comparator.comparing(p_378808_ -> p_378808_.key().location())).map(p_378803_ -> String.format(Locale.ROOT, "\n\t\t%s: tags=%d", p_378803_.key().location(), p_378803_.size())).collect(Collectors.joining()));
    }

    private void loadOnlyTags(TagCollector p_361700_, RegistryAccess.Frozen p_363342_, boolean p_360419_) {
        p_361700_.forEach((p_360314_, p_361795_) -> {
            if (p_360419_ || RegistrySynchronization.isNetworkable(p_360314_)) {
                RegistryDataCollector.resolveRegistryTags(p_363342_, p_360314_, p_361795_).apply();
            }
        });
    }

    public RegistryAccess.Frozen collectGameRegistries(ResourceProvider p_326319_, RegistryAccess.Frozen p_363224_, boolean p_321683_) {
        RegistryAccess.Frozen $$4;
        if (this.contentsCollector != null) {
            RegistryAccess $$3 = this.loadNewElementsAndTags(p_326319_, this.contentsCollector, p_321683_);
        } else {
            if (this.tagCollector != null) {
                this.loadOnlyTags(this.tagCollector, p_363224_, !p_321683_);
            }
            $$4 = p_363224_;
        }
        return $$4.freeze();
    }

    static class ContentsCollector {
        final Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> elements = new HashMap();

        ContentsCollector() {
        }

        public void append(ResourceKey<? extends Registry<?>> p_321577_, List<RegistrySynchronization.PackedRegistryEntry> p_321551_) {
            this.elements.computeIfAbsent(p_321577_, p_321745_ -> new ArrayList()).addAll(p_321551_);
        }
    }

    static class TagCollector {
        private final Map<ResourceKey<? extends Registry<?>>, TagNetworkSerialization.NetworkPayload> tags = new HashMap();

        TagCollector() {
        }

        public void append(ResourceKey<? extends Registry<?>> p_360353_, TagNetworkSerialization.NetworkPayload p_361162_) {
            this.tags.put(p_360353_, p_361162_);
        }

        public void forEach(BiConsumer<? super ResourceKey<? extends Registry<?>>, ? super TagNetworkSerialization.NetworkPayload> p_361476_) {
            this.tags.forEach(p_361476_);
        }
    }
}

