/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;

public class ClientChunkCache
extends ChunkSource {
    static final Logger LOGGER = LogUtils.getLogger();
    private final LevelChunk emptyChunk;
    private final LevelLightEngine lightEngine;
    volatile Storage storage;
    final ClientLevel level;

    public ClientChunkCache(ClientLevel p_104414_, int p_104415_) {
        this.level = p_104414_;
        this.emptyChunk = new EmptyLevelChunk(p_104414_, new ChunkPos(0, 0), p_104414_.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS));
        this.lightEngine = new LevelLightEngine(this, true, p_104414_.dimensionType().hasSkyLight());
        this.storage = new Storage(ClientChunkCache.calculateStorageRange(p_104415_));
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    private static boolean isValidChunk(@Nullable LevelChunk p_104439_, int p_104440_, int p_104441_) {
        if (p_104439_ == null) {
            return false;
        }
        ChunkPos $$3 = p_104439_.getPos();
        return $$3.x == p_104440_ && $$3.z == p_104441_;
    }

    public void drop(ChunkPos p_295783_) {
        if (!this.storage.inRange(p_295783_.x, p_295783_.z)) {
            return;
        }
        int $$1 = this.storage.getIndex(p_295783_.x, p_295783_.z);
        LevelChunk $$2 = this.storage.getChunk($$1);
        if (ClientChunkCache.isValidChunk($$2, p_295783_.x, p_295783_.z)) {
            this.storage.drop($$1, $$2);
        }
    }

    @Override
    @Nullable
    public LevelChunk getChunk(int p_104451_, int p_104452_, ChunkStatus p_330230_, boolean p_104454_) {
        LevelChunk $$4;
        if (this.storage.inRange(p_104451_, p_104452_) && ClientChunkCache.isValidChunk($$4 = this.storage.getChunk(this.storage.getIndex(p_104451_, p_104452_)), p_104451_, p_104452_)) {
            return $$4;
        }
        if (p_104454_) {
            return this.emptyChunk;
        }
        return null;
    }

    @Override
    public BlockGetter getLevel() {
        return this.level;
    }

    public void replaceBiomes(int p_275374_, int p_275226_, FriendlyByteBuf p_275745_) {
        if (!this.storage.inRange(p_275374_, p_275226_)) {
            LOGGER.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_275374_, (Object)p_275226_);
            return;
        }
        int $$3 = this.storage.getIndex(p_275374_, p_275226_);
        LevelChunk $$4 = this.storage.chunks.get($$3);
        if (!ClientChunkCache.isValidChunk($$4, p_275374_, p_275226_)) {
            LOGGER.warn("Ignoring chunk since it's not present: {}, {}", (Object)p_275374_, (Object)p_275226_);
        } else {
            $$4.replaceBiomes(p_275745_);
        }
    }

    @Nullable
    public LevelChunk replaceWithPacketData(int p_194117_, int p_194118_, FriendlyByteBuf p_194119_, Map<Heightmap.Types, long[]> p_405767_, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> p_194121_) {
        if (!this.storage.inRange(p_194117_, p_194118_)) {
            LOGGER.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_194117_, (Object)p_194118_);
            return null;
        }
        int $$5 = this.storage.getIndex(p_194117_, p_194118_);
        LevelChunk $$6 = this.storage.chunks.get($$5);
        ChunkPos $$7 = new ChunkPos(p_194117_, p_194118_);
        if (!ClientChunkCache.isValidChunk($$6, p_194117_, p_194118_)) {
            $$6 = new LevelChunk(this.level, $$7);
            $$6.replaceWithPacketData(p_194119_, p_405767_, p_194121_);
            this.storage.replace($$5, $$6);
        } else {
            $$6.replaceWithPacketData(p_194119_, p_405767_, p_194121_);
            this.storage.refreshEmptySections($$6);
        }
        this.level.onChunkLoaded($$7);
        return $$6;
    }

    @Override
    public void tick(BooleanSupplier p_202421_, boolean p_202422_) {
    }

    public void updateViewCenter(int p_104460_, int p_104461_) {
        this.storage.viewCenterX = p_104460_;
        this.storage.viewCenterZ = p_104461_;
    }

    public void updateViewRadius(int p_104417_) {
        int $$1 = this.storage.chunkRadius;
        int $$2 = ClientChunkCache.calculateStorageRange(p_104417_);
        if ($$1 != $$2) {
            Storage $$3 = new Storage($$2);
            $$3.viewCenterX = this.storage.viewCenterX;
            $$3.viewCenterZ = this.storage.viewCenterZ;
            for (int $$4 = 0; $$4 < this.storage.chunks.length(); ++$$4) {
                LevelChunk $$5 = this.storage.chunks.get($$4);
                if ($$5 == null) continue;
                ChunkPos $$6 = $$5.getPos();
                if (!$$3.inRange($$6.x, $$6.z)) continue;
                $$3.replace($$3.getIndex($$6.x, $$6.z), $$5);
            }
            this.storage = $$3;
        }
    }

    private static int calculateStorageRange(int p_104449_) {
        return Math.max(2, p_104449_) + 3;
    }

    @Override
    public String gatherStats() {
        return this.storage.chunks.length() + ", " + this.getLoadedChunksCount();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.storage.chunkCount;
    }

    @Override
    public void onLightUpdate(LightLayer p_104436_, SectionPos p_104437_) {
        Minecraft.getInstance().levelRenderer.setSectionDirty(p_104437_.x(), p_104437_.y(), p_104437_.z());
    }

    public LongOpenHashSet getLoadedEmptySections() {
        return this.storage.loadedEmptySections;
    }

    @Override
    public void onSectionEmptinessChanged(int p_366524_, int p_366407_, int p_366651_, boolean p_366887_) {
        this.storage.onSectionEmptinessChanged(p_366524_, p_366407_, p_366651_, p_366887_);
    }

    @Override
    @Nullable
    public /* synthetic */ ChunkAccess getChunk(int n, int n2, ChunkStatus chunkStatus, boolean bl) {
        return this.getChunk(n, n2, chunkStatus, bl);
    }

    final class Storage {
        final AtomicReferenceArray<LevelChunk> chunks;
        final LongOpenHashSet loadedEmptySections = new LongOpenHashSet();
        final int chunkRadius;
        private final int viewRange;
        volatile int viewCenterX;
        volatile int viewCenterZ;
        int chunkCount;

        Storage(int p_104474_) {
            this.chunkRadius = p_104474_;
            this.viewRange = p_104474_ * 2 + 1;
            this.chunks = new AtomicReferenceArray(this.viewRange * this.viewRange);
        }

        int getIndex(int p_104482_, int p_104483_) {
            return Math.floorMod(p_104483_, this.viewRange) * this.viewRange + Math.floorMod(p_104482_, this.viewRange);
        }

        void replace(int p_104485_, @Nullable LevelChunk p_104486_) {
            LevelChunk $$2 = this.chunks.getAndSet(p_104485_, p_104486_);
            if ($$2 != null) {
                --this.chunkCount;
                this.dropEmptySections($$2);
                ClientChunkCache.this.level.unload($$2);
            }
            if (p_104486_ != null) {
                ++this.chunkCount;
                this.addEmptySections(p_104486_);
            }
        }

        void drop(int p_366627_, LevelChunk p_366475_) {
            if (this.chunks.compareAndSet(p_366627_, p_366475_, null)) {
                --this.chunkCount;
                this.dropEmptySections(p_366475_);
            }
            ClientChunkCache.this.level.unload(p_366475_);
        }

        public void onSectionEmptinessChanged(int p_366606_, int p_366859_, int p_366870_, boolean p_366411_) {
            if (!this.inRange(p_366606_, p_366870_)) {
                return;
            }
            long $$4 = SectionPos.asLong(p_366606_, p_366859_, p_366870_);
            if (p_366411_) {
                this.loadedEmptySections.add($$4);
            } else if (this.loadedEmptySections.remove($$4)) {
                ClientChunkCache.this.level.onSectionBecomingNonEmpty($$4);
            }
        }

        private void dropEmptySections(LevelChunk p_366765_) {
            LevelChunkSection[] $$1 = p_366765_.getSections();
            for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
                ChunkPos $$3 = p_366765_.getPos();
                this.loadedEmptySections.remove(SectionPos.asLong($$3.x, p_366765_.getSectionYFromSectionIndex($$2), $$3.z));
            }
        }

        private void addEmptySections(LevelChunk p_366694_) {
            LevelChunkSection[] $$1 = p_366694_.getSections();
            for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
                LevelChunkSection $$3 = $$1[$$2];
                if (!$$3.hasOnlyAir()) continue;
                ChunkPos $$4 = p_366694_.getPos();
                this.loadedEmptySections.add(SectionPos.asLong($$4.x, p_366694_.getSectionYFromSectionIndex($$2), $$4.z));
            }
        }

        void refreshEmptySections(LevelChunk p_386574_) {
            ChunkPos $$1 = p_386574_.getPos();
            LevelChunkSection[] $$2 = p_386574_.getSections();
            for (int $$3 = 0; $$3 < $$2.length; ++$$3) {
                LevelChunkSection $$4 = $$2[$$3];
                long $$5 = SectionPos.asLong($$1.x, p_386574_.getSectionYFromSectionIndex($$3), $$1.z);
                if ($$4.hasOnlyAir()) {
                    this.loadedEmptySections.add($$5);
                    continue;
                }
                if (!this.loadedEmptySections.remove($$5)) continue;
                ClientChunkCache.this.level.onSectionBecomingNonEmpty($$5);
            }
        }

        boolean inRange(int p_104501_, int p_104502_) {
            return Math.abs(p_104501_ - this.viewCenterX) <= this.chunkRadius && Math.abs(p_104502_ - this.viewCenterZ) <= this.chunkRadius;
        }

        @Nullable
        protected LevelChunk getChunk(int p_104480_) {
            return this.chunks.get(p_104480_);
        }

        private void dumpChunks(String p_171623_) {
            try (FileOutputStream $$1 = new FileOutputStream(p_171623_);){
                int $$2 = ClientChunkCache.this.storage.chunkRadius;
                for (int $$3 = this.viewCenterZ - $$2; $$3 <= this.viewCenterZ + $$2; ++$$3) {
                    for (int $$4 = this.viewCenterX - $$2; $$4 <= this.viewCenterX + $$2; ++$$4) {
                        LevelChunk $$5 = ClientChunkCache.this.storage.chunks.get(ClientChunkCache.this.storage.getIndex($$4, $$3));
                        if ($$5 == null) continue;
                        ChunkPos $$6 = $$5.getPos();
                        $$1.write(($$6.x + "\t" + $$6.z + "\t" + $$5.isEmpty() + "\n").getBytes(StandardCharsets.UTF_8));
                    }
                }
            }
            catch (IOException $$7) {
                LOGGER.error("Failed to dump chunks to file {}", (Object)p_171623_, (Object)$$7);
            }
        }
    }
}

