/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class QuadrupedModel<T extends LivingEntityRenderState>
extends EntityModel<T> {
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;

    protected QuadrupedModel(ModelPart p_170857_) {
        super(p_170857_);
        this.head = p_170857_.getChild("head");
        this.body = p_170857_.getChild("body");
        this.rightHindLeg = p_170857_.getChild("right_hind_leg");
        this.leftHindLeg = p_170857_.getChild("left_hind_leg");
        this.rightFrontLeg = p_170857_.getChild("right_front_leg");
        this.leftFrontLeg = p_170857_.getChild("left_front_leg");
    }

    public static MeshDefinition createBodyMesh(int p_170865_, boolean p_415888_, boolean p_415959_, CubeDeformation p_170866_) {
        MeshDefinition $$4 = new MeshDefinition();
        PartDefinition $$5 = $$4.getRoot();
        $$5.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, p_170866_), PartPose.offset(0.0f, 18 - p_170865_, -6.0f));
        $$5.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-5.0f, -10.0f, -7.0f, 10.0f, 16.0f, 8.0f, p_170866_), PartPose.offsetAndRotation(0.0f, 17 - p_170865_, 2.0f, 1.5707964f, 0.0f, 0.0f));
        QuadrupedModel.createLegs($$5, p_415888_, p_415959_, p_170865_, p_170866_);
        return $$4;
    }

    static void createLegs(PartDefinition p_415934_, boolean p_415630_, boolean p_416371_, int p_416746_, CubeDeformation p_416541_) {
        CubeListBuilder $$5 = CubeListBuilder.create().mirror(p_416371_).texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, (float)p_416746_, 4.0f, p_416541_);
        CubeListBuilder $$6 = CubeListBuilder.create().mirror(p_415630_).texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, (float)p_416746_, 4.0f, p_416541_);
        p_415934_.addOrReplaceChild("right_hind_leg", $$5, PartPose.offset(-3.0f, 24 - p_416746_, 7.0f));
        p_415934_.addOrReplaceChild("left_hind_leg", $$6, PartPose.offset(3.0f, 24 - p_416746_, 7.0f));
        p_415934_.addOrReplaceChild("right_front_leg", $$5, PartPose.offset(-3.0f, 24 - p_416746_, -5.0f));
        p_415934_.addOrReplaceChild("left_front_leg", $$6, PartPose.offset(3.0f, 24 - p_416746_, -5.0f));
    }

    @Override
    public void setupAnim(T p_362548_) {
        super.setupAnim(p_362548_);
        this.head.xRot = ((LivingEntityRenderState)p_362548_).xRot * ((float)Math.PI / 180);
        this.head.yRot = ((LivingEntityRenderState)p_362548_).yRot * ((float)Math.PI / 180);
        float $$1 = ((LivingEntityRenderState)p_362548_).walkAnimationPos;
        float $$2 = ((LivingEntityRenderState)p_362548_).walkAnimationSpeed;
        this.rightHindLeg.xRot = Mth.cos($$1 * 0.6662f) * 1.4f * $$2;
        this.leftHindLeg.xRot = Mth.cos($$1 * 0.6662f + (float)Math.PI) * 1.4f * $$2;
        this.rightFrontLeg.xRot = Mth.cos($$1 * 0.6662f + (float)Math.PI) * 1.4f * $$2;
        this.leftFrontLeg.xRot = Mth.cos($$1 * 0.6662f) * 1.4f * $$2;
    }
}

