/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

public class PlayerModel
extends HumanoidModel<PlayerRenderState> {
    private static final String LEFT_SLEEVE = "left_sleeve";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_PANTS = "left_pants";
    private static final String RIGHT_PANTS = "right_pants";
    private final List<ModelPart> bodyParts;
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;
    private final boolean slim;

    public PlayerModel(ModelPart p_170821_, boolean p_170822_) {
        super(p_170821_, RenderType::entityTranslucent);
        this.slim = p_170822_;
        this.leftSleeve = this.leftArm.getChild(LEFT_SLEEVE);
        this.rightSleeve = this.rightArm.getChild(RIGHT_SLEEVE);
        this.leftPants = this.leftLeg.getChild(LEFT_PANTS);
        this.rightPants = this.rightLeg.getChild(RIGHT_PANTS);
        this.jacket = this.body.getChild("jacket");
        this.bodyParts = List.of(this.head, this.body, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg);
    }

    public static MeshDefinition createMesh(CubeDeformation p_170826_, boolean p_170827_) {
        MeshDefinition $$2 = HumanoidModel.createMesh(p_170826_, 0.0f);
        PartDefinition $$3 = $$2.getRoot();
        float $$4 = 0.25f;
        if (p_170827_) {
            PartDefinition $$5 = $$3.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(5.0f, 2.0f, 0.0f));
            PartDefinition $$6 = $$3.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(-5.0f, 2.0f, 0.0f));
            $$5.addOrReplaceChild(LEFT_SLEEVE, CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
            $$6.addOrReplaceChild(RIGHT_SLEEVE, CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        } else {
            PartDefinition $$7 = $$3.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(5.0f, 2.0f, 0.0f));
            PartDefinition $$8 = $$3.getChild("right_arm");
            $$7.addOrReplaceChild(LEFT_SLEEVE, CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
            $$8.addOrReplaceChild(RIGHT_SLEEVE, CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        }
        PartDefinition $$9 = $$3.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(1.9f, 12.0f, 0.0f));
        PartDefinition $$10 = $$3.getChild("right_leg");
        $$9.addOrReplaceChild(LEFT_PANTS, CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        $$10.addOrReplaceChild(RIGHT_PANTS, CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        PartDefinition $$11 = $$3.getChild("body");
        $$11.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        return $$2;
    }

    @Override
    public void setupAnim(PlayerRenderState p_365286_) {
        boolean $$1;
        this.body.visible = $$1 = !p_365286_.isSpectator;
        this.rightArm.visible = $$1;
        this.leftArm.visible = $$1;
        this.rightLeg.visible = $$1;
        this.leftLeg.visible = $$1;
        this.hat.visible = p_365286_.showHat;
        this.jacket.visible = p_365286_.showJacket;
        this.leftPants.visible = p_365286_.showLeftPants;
        this.rightPants.visible = p_365286_.showRightPants;
        this.leftSleeve.visible = p_365286_.showLeftSleeve;
        this.rightSleeve.visible = p_365286_.showRightSleeve;
        super.setupAnim(p_365286_);
    }

    @Override
    public void setAllVisible(boolean p_103419_) {
        super.setAllVisible(p_103419_);
        this.leftSleeve.visible = p_103419_;
        this.rightSleeve.visible = p_103419_;
        this.leftPants.visible = p_103419_;
        this.rightPants.visible = p_103419_;
        this.jacket.visible = p_103419_;
    }

    @Override
    public void translateToHand(HumanoidArm p_103392_, PoseStack p_103393_) {
        this.root().translateAndRotate(p_103393_);
        ModelPart $$2 = this.getArm(p_103392_);
        if (this.slim) {
            float $$3 = 0.5f * (float)(p_103392_ == HumanoidArm.RIGHT ? 1 : -1);
            $$2.x += $$3;
            $$2.translateAndRotate(p_103393_);
            $$2.x -= $$3;
        } else {
            $$2.translateAndRotate(p_103393_);
        }
    }

    public ModelPart getRandomBodyPart(RandomSource p_365097_) {
        return Util.getRandom(this.bodyParts, p_365097_);
    }
}

