/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.AxolotlRenderState;
import net.minecraft.util.Mth;

public class AxolotlModel
extends EntityModel<AxolotlRenderState> {
    public static final float SWIMMING_LEG_XROT = 1.8849558f;
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling(0.5f);
    private final ModelPart tail;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart topGills;
    private final ModelPart leftGills;
    private final ModelPart rightGills;

    public AxolotlModel(ModelPart p_170370_) {
        super(p_170370_);
        this.body = p_170370_.getChild("body");
        this.head = this.body.getChild("head");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.tail = this.body.getChild("tail");
        this.topGills = this.head.getChild("top_gills");
        this.leftGills = this.head.getChild("left_gills");
        this.rightGills = this.head.getChild("right_gills");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        PartDefinition $$2 = $$1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f).texOffs(2, 17).addBox(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f), PartPose.offset(0.0f, 20.0f, 5.0f));
        CubeDeformation $$3 = new CubeDeformation(0.001f);
        PartDefinition $$4 = $$2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 1).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, $$3), PartPose.offset(0.0f, 0.0f, -9.0f));
        CubeListBuilder $$5 = CubeListBuilder.create().texOffs(3, 37).addBox(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, $$3);
        CubeListBuilder $$6 = CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, $$3);
        CubeListBuilder $$7 = CubeListBuilder.create().texOffs(11, 40).addBox(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, $$3);
        $$4.addOrReplaceChild("top_gills", $$5, PartPose.offset(0.0f, -3.0f, -1.0f));
        $$4.addOrReplaceChild("left_gills", $$6, PartPose.offset(-4.0f, 0.0f, -1.0f));
        $$4.addOrReplaceChild("right_gills", $$7, PartPose.offset(4.0f, 0.0f, -1.0f));
        CubeListBuilder $$8 = CubeListBuilder.create().texOffs(2, 13).addBox(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, $$3);
        CubeListBuilder $$9 = CubeListBuilder.create().texOffs(2, 13).addBox(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, $$3);
        $$2.addOrReplaceChild("right_hind_leg", $$9, PartPose.offset(-3.5f, 1.0f, -1.0f));
        $$2.addOrReplaceChild("left_hind_leg", $$8, PartPose.offset(3.5f, 1.0f, -1.0f));
        $$2.addOrReplaceChild("right_front_leg", $$9, PartPose.offset(-3.5f, 1.0f, -8.0f));
        $$2.addOrReplaceChild("left_front_leg", $$8, PartPose.offset(3.5f, 1.0f, -8.0f));
        $$2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(2, 19).addBox(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f), PartPose.offset(0.0f, 0.0f, 1.0f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void setupAnim(AxolotlRenderState p_362259_) {
        super.setupAnim(p_362259_);
        float $$1 = p_362259_.playingDeadFactor;
        float $$2 = p_362259_.inWaterFactor;
        float $$3 = p_362259_.onGroundFactor;
        float $$4 = p_362259_.movingFactor;
        float $$5 = 1.0f - $$4;
        float $$6 = 1.0f - Math.min($$3, $$4);
        this.body.yRot += p_362259_.yRot * ((float)Math.PI / 180);
        this.setupSwimmingAnimation(p_362259_.ageInTicks, p_362259_.xRot, Math.min($$4, $$2));
        this.setupWaterHoveringAnimation(p_362259_.ageInTicks, Math.min($$5, $$2));
        this.setupGroundCrawlingAnimation(p_362259_.ageInTicks, Math.min($$4, $$3));
        this.setupLayStillOnGroundAnimation(p_362259_.ageInTicks, Math.min($$5, $$3));
        this.setupPlayDeadAnimation($$1);
        this.applyMirrorLegRotations($$6);
    }

    private void setupLayStillOnGroundAnimation(float p_170415_, float p_170416_) {
        if (p_170416_ <= 1.0E-5f) {
            return;
        }
        float $$2 = p_170415_ * 0.09f;
        float $$3 = Mth.sin($$2);
        float $$4 = Mth.cos($$2);
        float $$5 = $$3 * $$3 - 2.0f * $$3;
        float $$6 = $$4 * $$4 - 3.0f * $$3;
        this.head.xRot += -0.09f * $$5 * p_170416_;
        this.head.zRot += -0.2f * p_170416_;
        this.tail.yRot += (-0.1f + 0.1f * $$5) * p_170416_;
        float $$7 = (0.6f + 0.05f * $$6) * p_170416_;
        this.topGills.xRot += $$7;
        this.leftGills.yRot -= $$7;
        this.rightGills.yRot += $$7;
        this.leftHindLeg.xRot += 1.1f * p_170416_;
        this.leftHindLeg.yRot += 1.0f * p_170416_;
        this.leftFrontLeg.xRot += 0.8f * p_170416_;
        this.leftFrontLeg.yRot += 2.3f * p_170416_;
        this.leftFrontLeg.zRot -= 0.5f * p_170416_;
    }

    private void setupGroundCrawlingAnimation(float p_170419_, float p_170420_) {
        if (p_170420_ <= 1.0E-5f) {
            return;
        }
        float $$2 = p_170419_ * 0.11f;
        float $$3 = Mth.cos($$2);
        float $$4 = ($$3 * $$3 - 2.0f * $$3) / 5.0f;
        float $$5 = 0.7f * $$3;
        float $$6 = 0.09f * $$3 * p_170420_;
        this.head.yRot += $$6;
        this.tail.yRot += $$6;
        float $$7 = (0.6f - 0.08f * ($$3 * $$3 + 2.0f * Mth.sin($$2))) * p_170420_;
        this.topGills.xRot += $$7;
        this.leftGills.yRot -= $$7;
        this.rightGills.yRot += $$7;
        float $$8 = 0.9424779f * p_170420_;
        float $$9 = 1.0995574f * p_170420_;
        this.leftHindLeg.xRot += $$8;
        this.leftHindLeg.yRot += (1.5f - $$4) * p_170420_;
        this.leftHindLeg.zRot += -0.1f * p_170420_;
        this.leftFrontLeg.xRot += $$9;
        this.leftFrontLeg.yRot += (1.5707964f - $$5) * p_170420_;
        this.rightHindLeg.xRot += $$8;
        this.rightHindLeg.yRot += (-1.0f - $$4) * p_170420_;
        this.rightFrontLeg.xRot += $$9;
        this.rightFrontLeg.yRot += (-1.5707964f - $$5) * p_170420_;
    }

    private void setupWaterHoveringAnimation(float p_170373_, float p_365132_) {
        if (p_365132_ <= 1.0E-5f) {
            return;
        }
        float $$2 = p_170373_ * 0.075f;
        float $$3 = Mth.cos($$2);
        float $$4 = Mth.sin($$2) * 0.15f;
        float $$5 = (-0.15f + 0.075f * $$3) * p_365132_;
        this.body.xRot += $$5;
        this.body.y -= $$4 * p_365132_;
        this.head.xRot -= $$5;
        this.topGills.xRot += 0.2f * $$3 * p_365132_;
        float $$6 = (-0.3f * $$3 - 0.19f) * p_365132_;
        this.leftGills.yRot += $$6;
        this.rightGills.yRot -= $$6;
        this.leftHindLeg.xRot += (2.3561945f - $$3 * 0.11f) * p_365132_;
        this.leftHindLeg.yRot += 0.47123894f * p_365132_;
        this.leftHindLeg.zRot += 1.7278761f * p_365132_;
        this.leftFrontLeg.xRot += (0.7853982f - $$3 * 0.2f) * p_365132_;
        this.leftFrontLeg.yRot += 2.042035f * p_365132_;
        this.tail.yRot += 0.5f * $$3 * p_365132_;
    }

    private void setupSwimmingAnimation(float p_170423_, float p_170424_, float p_361875_) {
        if (p_361875_ <= 1.0E-5f) {
            return;
        }
        float $$3 = p_170423_ * 0.33f;
        float $$4 = Mth.sin($$3);
        float $$5 = Mth.cos($$3);
        float $$6 = 0.13f * $$4;
        this.body.xRot += (p_170424_ * ((float)Math.PI / 180) + $$6) * p_361875_;
        this.head.xRot -= $$6 * 1.8f * p_361875_;
        this.body.y -= 0.45f * $$5 * p_361875_;
        this.topGills.xRot += (-0.5f * $$4 - 0.8f) * p_361875_;
        float $$7 = (0.3f * $$4 + 0.9f) * p_361875_;
        this.leftGills.yRot += $$7;
        this.rightGills.yRot -= $$7;
        this.tail.yRot += 0.3f * Mth.cos($$3 * 0.9f) * p_361875_;
        this.leftHindLeg.xRot += 1.8849558f * p_361875_;
        this.leftHindLeg.yRot += -0.4f * $$4 * p_361875_;
        this.leftHindLeg.zRot += 1.5707964f * p_361875_;
        this.leftFrontLeg.xRot += 1.8849558f * p_361875_;
        this.leftFrontLeg.yRot += (-0.2f * $$5 - 0.1f) * p_361875_;
        this.leftFrontLeg.zRot += 1.5707964f * p_361875_;
    }

    private void setupPlayDeadAnimation(float p_170413_) {
        if (p_170413_ <= 1.0E-5f) {
            return;
        }
        this.leftHindLeg.xRot += 1.4137167f * p_170413_;
        this.leftHindLeg.yRot += 1.0995574f * p_170413_;
        this.leftHindLeg.zRot += 0.7853982f * p_170413_;
        this.leftFrontLeg.xRot += 0.7853982f * p_170413_;
        this.leftFrontLeg.yRot += 2.042035f * p_170413_;
        this.body.xRot += -0.15f * p_170413_;
        this.body.zRot += 0.35f * p_170413_;
    }

    private void applyMirrorLegRotations(float p_360669_) {
        if (p_360669_ <= 1.0E-5f) {
            return;
        }
        this.rightHindLeg.xRot += this.leftHindLeg.xRot * p_360669_;
        ModelPart modelPart = this.rightHindLeg;
        modelPart.yRot = modelPart.yRot + -this.leftHindLeg.yRot * p_360669_;
        modelPart = this.rightHindLeg;
        modelPart.zRot = modelPart.zRot + -this.leftHindLeg.zRot * p_360669_;
        this.rightFrontLeg.xRot += this.leftFrontLeg.xRot * p_360669_;
        modelPart = this.rightFrontLeg;
        modelPart.yRot = modelPart.yRot + -this.leftFrontLeg.yRot * p_360669_;
        modelPart = this.rightFrontLeg;
        modelPart.zRot = modelPart.zRot + -this.leftFrontLeg.zRot * p_360669_;
    }
}

