/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DatapackLoadFailureScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.RecoverWorldDataScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.InitialWorldCreationOptions;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.util.MemoryReserve;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.slf4j.Logger;

public class WorldOpenFlows {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UUID WORLD_PACK_ID = UUID.fromString("640a6a92-b6cb-48a0-b391-831586500359");
    private final Minecraft minecraft;
    private final LevelStorageSource levelSource;

    public WorldOpenFlows(Minecraft p_233093_, LevelStorageSource p_233094_) {
        this.minecraft = p_233093_;
        this.levelSource = p_233094_;
    }

    public void createFreshLevel(String p_233158_, LevelSettings p_233159_, WorldOptions p_249243_, Function<HolderLookup.Provider, WorldDimensions> p_249252_, Screen p_307305_) {
        this.minecraft.forceSetScreen(new GenericMessageScreen(Component.translatable("selectWorld.data_read")));
        LevelStorageSource.LevelStorageAccess $$5 = this.createWorldAccess(p_233158_);
        if ($$5 == null) {
            return;
        }
        PackRepository $$6 = ServerPacksSource.createPackRepository($$5);
        WorldDataConfiguration $$7 = p_233159_.getDataConfiguration();
        try {
            WorldLoader.PackConfig $$8 = new WorldLoader.PackConfig($$6, $$7, false, false);
            WorldStem $$9 = this.loadWorldDataBlocking($$8, p_396293_ -> {
                WorldDimensions.Complete $$4 = ((WorldDimensions)p_249252_.apply(p_396293_.datapackWorldgen())).bake((Registry<LevelStem>)p_396293_.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM));
                return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData(p_233159_, p_249243_, $$4.specialWorldProperty(), $$4.lifecycle()), $$4.dimensionsRegistryAccess());
            }, WorldStem::new);
            this.minecraft.doWorldLoad($$5, $$6, $$9, true);
        }
        catch (Exception $$10) {
            LOGGER.warn("Failed to load datapacks, can't proceed with server load", (Throwable)$$10);
            $$5.safeClose();
            this.minecraft.setScreen(p_307305_);
        }
    }

    @Nullable
    private LevelStorageSource.LevelStorageAccess createWorldAccess(String p_233156_) {
        try {
            return this.levelSource.validateAndCreateAccess(p_233156_);
        }
        catch (IOException $$1) {
            LOGGER.warn("Failed to read level {} data", (Object)p_233156_, (Object)$$1);
            SystemToast.onWorldAccessFailure(this.minecraft, p_233156_);
            this.minecraft.setScreen(null);
            return null;
        }
        catch (ContentValidationException $$2) {
            LOGGER.warn("{}", (Object)$$2.getMessage());
            this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen(null)));
            return null;
        }
    }

    public void createLevelFromExistingSettings(LevelStorageSource.LevelStorageAccess p_250919_, ReloadableServerResources p_248897_, LayeredRegistryAccess<RegistryLayer> p_250801_, WorldData p_251654_) {
        PackRepository $$4 = ServerPacksSource.createPackRepository(p_250919_);
        CloseableResourceManager $$5 = (CloseableResourceManager)new WorldLoader.PackConfig($$4, p_251654_.getDataConfiguration(), false, false).createResourceManager().getSecond();
        this.minecraft.doWorldLoad(p_250919_, $$4, new WorldStem($$5, p_248897_, p_250801_, p_251654_), true);
    }

    public WorldStem loadWorldStem(Dynamic<?> p_307491_, boolean p_233124_, PackRepository p_233125_) throws Exception {
        WorldLoader.PackConfig $$3 = LevelStorageSource.getPackConfig(p_307491_, p_233125_, p_233124_);
        return this.loadWorldDataBlocking($$3, p_396289_ -> {
            HolderLookup.RegistryLookup $$2 = p_396289_.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
            LevelDataAndDimensions $$3 = LevelStorageSource.getLevelDataAndDimensions(p_307491_, p_396289_.dataConfiguration(), (Registry<LevelStem>)$$2, p_396289_.datapackWorldgen());
            return new WorldLoader.DataLoadOutput<WorldData>($$3.worldData(), $$3.dimensions().dimensionsRegistryAccess());
        }, WorldStem::new);
    }

    public Pair<LevelSettings, WorldCreationContext> recreateWorldData(LevelStorageSource.LevelStorageAccess p_249540_) throws Exception {
        record Data(LevelSettings levelSettings, WorldOptions options, Registry<LevelStem> existingDimensions) {
        }
        PackRepository $$1 = ServerPacksSource.createPackRepository(p_249540_);
        Dynamic<?> $$2 = p_249540_.getDataTag();
        WorldLoader.PackConfig $$3 = LevelStorageSource.getPackConfig($$2, $$1, false);
        return this.loadWorldDataBlocking($$3, p_359114_ -> {
            Registry<LevelStem> $$2 = new MappedRegistry<LevelStem>(Registries.LEVEL_STEM, Lifecycle.stable()).freeze();
            LevelDataAndDimensions $$3 = LevelStorageSource.getLevelDataAndDimensions($$2, p_359114_.dataConfiguration(), $$2, p_359114_.datapackWorldgen());
            return new WorldLoader.DataLoadOutput<Data>(new Data($$3.worldData().getLevelSettings(), $$3.worldData().worldGenOptions(), $$3.dimensions().dimensions()), p_359114_.datapackDimensions());
        }, (p_372535_, p_372536_, p_372537_, p_372538_) -> {
            p_372535_.close();
            InitialWorldCreationOptions $$4 = new InitialWorldCreationOptions(WorldCreationUiState.SelectedGameMode.SURVIVAL, Set.of(), null);
            return Pair.of((Object)p_372538_.levelSettings, (Object)new WorldCreationContext(p_372538_.options, new WorldDimensions(p_372538_.existingDimensions), p_372537_, p_372536_, p_372538_.levelSettings.getDataConfiguration(), $$4));
        });
    }

    private <D, R> R loadWorldDataBlocking(WorldLoader.PackConfig p_250997_, WorldLoader.WorldDataSupplier<D> p_251759_, WorldLoader.ResultFactory<D, R> p_249635_) throws Exception {
        WorldLoader.InitConfig $$3 = new WorldLoader.InitConfig(p_250997_, Commands.CommandSelection.INTEGRATED, 2);
        CompletableFuture<R> $$4 = WorldLoader.load($$3, p_251759_, p_249635_, Util.backgroundExecutor(), this.minecraft);
        this.minecraft.managedBlock($$4::isDone);
        return $$4.get();
    }

    private void askForBackup(LevelStorageSource.LevelStorageAccess p_307627_, boolean p_233143_, Runnable p_233144_, Runnable p_307323_) {
        MutableComponent $$7;
        MutableComponent $$6;
        if (p_233143_) {
            MutableComponent $$4 = Component.translatable("selectWorld.backupQuestion.customized");
            MutableComponent $$5 = Component.translatable("selectWorld.backupWarning.customized");
        } else {
            $$6 = Component.translatable("selectWorld.backupQuestion.experimental");
            $$7 = Component.translatable("selectWorld.backupWarning.experimental");
        }
        this.minecraft.setScreen(new BackupConfirmScreen(p_307323_, (p_307085_, p_307086_) -> {
            if (p_307085_) {
                EditWorldScreen.makeBackupAndShowToast(p_307627_);
            }
            p_233144_.run();
        }, $$6, $$7, false));
    }

    public static void confirmWorldCreation(Minecraft p_270593_, CreateWorldScreen p_270733_, Lifecycle p_270539_, Runnable p_270158_, boolean p_270709_) {
        BooleanConsumer $$5 = p_233154_ -> {
            if (p_233154_) {
                p_270158_.run();
            } else {
                p_270593_.setScreen(p_270733_);
            }
        };
        if (p_270709_ || p_270539_ == Lifecycle.stable()) {
            p_270158_.run();
        } else if (p_270539_ == Lifecycle.experimental()) {
            p_270593_.setScreen(new ConfirmScreen($$5, Component.translatable("selectWorld.warning.experimental.title"), Component.translatable("selectWorld.warning.experimental.question")));
        } else {
            p_270593_.setScreen(new ConfirmScreen($$5, Component.translatable("selectWorld.warning.deprecated.title"), Component.translatable("selectWorld.warning.deprecated.question")));
        }
    }

    public void openWorld(String p_330611_, Runnable p_331729_) {
        this.minecraft.forceSetScreen(new GenericMessageScreen(Component.translatable("selectWorld.data_read")));
        LevelStorageSource.LevelStorageAccess $$2 = this.createWorldAccess(p_330611_);
        if ($$2 == null) {
            return;
        }
        this.openWorldLoadLevelData($$2, p_331729_);
    }

    /*
     * WARNING - void declaration
     */
    private void openWorldLoadLevelData(LevelStorageSource.LevelStorageAccess p_330608_, Runnable p_331368_) {
        void $$10;
        void $$11;
        this.minecraft.forceSetScreen(new GenericMessageScreen(Component.translatable("selectWorld.data_read")));
        try {
            Dynamic<?> $$2 = p_330608_.getDataTag();
            LevelSummary $$3 = p_330608_.getSummary($$2);
        }
        catch (IOException | NbtException | ReportedNbtException $$4) {
            this.minecraft.setScreen(new RecoverWorldDataScreen(this.minecraft, p_329781_ -> {
                if (p_329781_) {
                    this.openWorldLoadLevelData(p_330608_, p_331368_);
                } else {
                    p_330608_.safeClose();
                    p_331368_.run();
                }
            }, p_330608_));
            return;
        }
        catch (OutOfMemoryError $$5) {
            MemoryReserve.release();
            String $$6 = "Ran out of memory trying to read level data of world folder \"" + p_330608_.getLevelId() + "\"";
            LOGGER.error(LogUtils.FATAL_MARKER, $$6);
            OutOfMemoryError $$7 = new OutOfMemoryError("Ran out of memory reading level data");
            $$7.initCause($$5);
            CrashReport $$8 = CrashReport.forThrowable($$7, $$6);
            CrashReportCategory $$9 = $$8.addCategory("World details");
            $$9.setDetail("World folder", p_330608_.getLevelId());
            throw new ReportedException($$8);
        }
        this.openWorldCheckVersionCompatibility(p_330608_, (LevelSummary)$$11, (Dynamic<?>)$$10, p_331368_);
    }

    private void openWorldCheckVersionCompatibility(LevelStorageSource.LevelStorageAccess p_331650_, LevelSummary p_331090_, Dynamic<?> p_331358_, Runnable p_331242_) {
        if (!p_331090_.isCompatible()) {
            p_331650_.safeClose();
            this.minecraft.setScreen(new AlertScreen(p_331242_, Component.translatable("selectWorld.incompatible.title").withColor(-65536), Component.translatable("selectWorld.incompatible.description", p_331090_.getWorldVersionName())));
            return;
        }
        LevelSummary.BackupStatus $$4 = p_331090_.backupStatus();
        if ($$4.shouldBackup()) {
            String $$5 = "selectWorld.backupQuestion." + $$4.getTranslationKey();
            String $$6 = "selectWorld.backupWarning." + $$4.getTranslationKey();
            MutableComponent $$7 = Component.translatable($$5);
            if ($$4.isSevere()) {
                $$7.withColor(-2142128);
            }
            MutableComponent $$8 = Component.translatable($$6, p_331090_.getWorldVersionName(), SharedConstants.getCurrentVersion().name());
            this.minecraft.setScreen(new BackupConfirmScreen(() -> {
                p_331650_.safeClose();
                p_331242_.run();
            }, (p_329770_, p_329771_) -> {
                if (p_329770_) {
                    EditWorldScreen.makeBackupAndShowToast(p_331650_);
                }
                this.openWorldLoadLevelStem(p_331650_, p_331358_, false, p_331242_);
            }, $$7, $$8, false));
        } else {
            this.openWorldLoadLevelStem(p_331650_, p_331358_, false, p_331242_);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void openWorldLoadLevelStem(LevelStorageSource.LevelStorageAccess p_331886_, Dynamic<?> p_332037_, boolean p_330245_, Runnable p_330289_) {
        void $$8;
        this.minecraft.forceSetScreen(new GenericMessageScreen(Component.translatable("selectWorld.resource_load")));
        PackRepository $$4 = ServerPacksSource.createPackRepository(p_331886_);
        try {
            WorldStem $$5 = this.loadWorldStem(p_332037_, p_330245_, $$4);
            Iterator iterator = $$5.registries().compositeAccess().lookupOrThrow(Registries.LEVEL_STEM).iterator();
            while (iterator.hasNext()) {
                LevelStem $$6 = (LevelStem)iterator.next();
                $$6.generator().validate();
            }
        }
        catch (Exception $$7) {
            LOGGER.warn("Failed to load level data or datapacks, can't proceed with server load", (Throwable)$$7);
            if (!p_330245_) {
                this.minecraft.setScreen(new DatapackLoadFailureScreen(() -> {
                    p_331886_.safeClose();
                    p_330289_.run();
                }, () -> this.openWorldLoadLevelStem(p_331886_, p_332037_, true, p_330289_)));
            } else {
                p_331886_.safeClose();
                this.minecraft.setScreen(new AlertScreen(p_330289_, Component.translatable("datapackFailure.safeMode.failed.title"), Component.translatable("datapackFailure.safeMode.failed.description"), CommonComponents.GUI_BACK, true));
            }
            return;
        }
        this.openWorldCheckWorldStemCompatibility(p_331886_, (WorldStem)$$8, $$4, p_330289_);
    }

    private void openWorldCheckWorldStemCompatibility(LevelStorageSource.LevelStorageAccess p_331469_, WorldStem p_330774_, PackRepository p_330989_, Runnable p_332128_) {
        boolean $$6;
        WorldData $$4 = p_330774_.worldData();
        boolean $$5 = $$4.worldGenOptions().isOldCustomizedWorld();
        boolean bl = $$6 = $$4.worldGenSettingsLifecycle() != Lifecycle.stable();
        if ($$5 || $$6) {
            this.askForBackup(p_331469_, $$5, () -> this.openWorldLoadBundledResourcePack(p_331469_, p_330774_, p_330989_, p_332128_), () -> {
                p_330774_.close();
                p_331469_.safeClose();
                p_332128_.run();
            });
            return;
        }
        this.openWorldLoadBundledResourcePack(p_331469_, p_330774_, p_330989_, p_332128_);
    }

    private void openWorldLoadBundledResourcePack(LevelStorageSource.LevelStorageAccess p_331323_, WorldStem p_330675_, PackRepository p_332043_, Runnable p_330403_) {
        DownloadedPackSource $$4 = this.minecraft.getDownloadedPackSource();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.loadBundledResourcePack($$4, p_331323_).thenApply(p_233177_ -> true)).exceptionallyComposeAsync(p_233183_ -> {
            LOGGER.warn("Failed to load pack: ", p_233183_);
            return this.promptBundledPackLoadFailure();
        }, (Executor)this.minecraft)).thenAcceptAsync(p_329766_ -> {
            if (p_329766_.booleanValue()) {
                this.openWorldCheckDiskSpace(p_331323_, p_330675_, $$4, p_332043_, p_330403_);
            } else {
                $$4.popAll();
                p_330675_.close();
                p_331323_.safeClose();
                p_330403_.run();
            }
        }, (Executor)this.minecraft)).exceptionally(p_233175_ -> {
            this.minecraft.delayCrash(CrashReport.forThrowable(p_233175_, "Load world"));
            return null;
        });
    }

    private void openWorldCheckDiskSpace(LevelStorageSource.LevelStorageAccess p_330894_, WorldStem p_331981_, DownloadedPackSource p_331902_, PackRepository p_330360_, Runnable p_330719_) {
        if (p_330894_.checkForLowDiskSpace()) {
            this.minecraft.setScreen(new ConfirmScreen(p_329757_ -> {
                if (p_329757_) {
                    this.openWorldDoLoad(p_330894_, p_331981_, p_330360_);
                } else {
                    p_331902_.popAll();
                    p_331981_.close();
                    p_330894_.safeClose();
                    p_330719_.run();
                }
            }, Component.translatable("selectWorld.warning.lowDiskSpace.title").withStyle(ChatFormatting.RED), Component.translatable("selectWorld.warning.lowDiskSpace.description"), CommonComponents.GUI_CONTINUE, CommonComponents.GUI_BACK));
        } else {
            this.openWorldDoLoad(p_330894_, p_331981_, p_330360_);
        }
    }

    private void openWorldDoLoad(LevelStorageSource.LevelStorageAccess p_330420_, WorldStem p_331123_, PackRepository p_331620_) {
        this.minecraft.doWorldLoad(p_330420_, p_331620_, p_331123_, false);
    }

    private CompletableFuture<Void> loadBundledResourcePack(DownloadedPackSource p_314527_, LevelStorageSource.LevelStorageAccess p_314569_) {
        Path $$2 = p_314569_.getLevelPath(LevelResource.MAP_RESOURCE_FILE);
        if (Files.exists($$2, new LinkOption[0]) && !Files.isDirectory($$2, new LinkOption[0])) {
            p_314527_.configureForLocalWorld();
            CompletableFuture<Void> $$3 = p_314527_.waitForPackFeedback(WORLD_PACK_ID);
            p_314527_.pushLocalPack(WORLD_PACK_ID, $$2);
            return $$3;
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Boolean> promptBundledPackLoadFailure() {
        CompletableFuture<Boolean> $$0 = new CompletableFuture<Boolean>();
        this.minecraft.setScreen(new ConfirmScreen($$0::complete, Component.translatable("multiplayer.texturePrompt.failure.line1"), Component.translatable("multiplayer.texturePrompt.failure.line2"), CommonComponents.GUI_PROCEED, CommonComponents.GUI_CANCEL));
        return $$0;
    }
}

